/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.external.biz.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.bizdef.BizDefAdministrator;
import com.wily.introscope.agent.external.biz.trace.BtBaseTracer;
import com.wily.introscope.agent.external.biz.util.KExternalBizConstants;
import com.wily.introscope.agent.external.biz.util.MutableInteger;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.properties.AttributeListing;

public class SinglePerIntervalCounter
extends BtBaseTracer {
    private static final String kValuePlaceHolder = "{value}";
    private static ThreadLocal<MutableInteger> stackDepthLocal = new ThreadLocal<MutableInteger>(){

        @Override
        public MutableInteger initialValue() {
            return new MutableInteger(0);
        }
    };

    public SinglePerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected MutableInteger getStackDepth() {
        return stackDepthLocal.get();
    }

    private void updatePerIntervalMetric(InvocationData data) {
        StringBuilder sb;
        String pkey = this.getParameter("attributeKey");
        String pvalue = null;
        if (pkey != null && KExternalBizConstants.propertykeys.get(pkey) != null) {
            pvalue = (String)data.get(KExternalBizConstants.propertykeys.get(pkey));
        }
        if (pvalue != null && !"".equalsIgnoreCase(pvalue) && (sb = BizDefAdministrator.createBtMetricBuilder(data)) != null) {
            sb.append(this.getFormattedName().replace(kValuePlaceHolder, this.normalizeValue(pvalue)));
            ILongIntervalCounterDataAccumulator counter = this.dataAccumulatorfactory.safeGetBizTrxLongIntervalCounterDataAccumulator(sb.toString());
            counter.ILongAggregatingDataAccumulator_recordDataPoint(1L);
        }
    }

    private String normalizeValue(String value) {
        return value.replace('|', '.');
    }

    @Override
    protected void updateBtMetricAtStart(InvocationData data) {
    }

    @Override
    protected void updateBtMetricAtFinish(InvocationData data) {
        this.updatePerIntervalMetric(data);
    }
}

