/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.frontend.jms;

import com.ca.apm.parent.instrumentation.helper.JMSReceiveStackTraceRepository;
import com.ca.apm.parent.instrumentation.helper.JMSStackTraceWrappper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSReceiveStackTTraceController;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.util.properties.AttributeListing;
import java.util.Arrays;

public class JMSReceiveParentDetectionTracer
extends ASingleInstanceTracerFactoryHC {
    private static int maxStackElements = 15;

    public JMSReceiveParentDetectionTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        JMSReceiveStackTTraceController.init(agent);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        this.suggestStackTraceRecording(data);
    }

    protected void suggestStackTraceRecording(InvocationData data) {
        if (!JMSReceiveStackTTraceController.shouldRecordStackTrace(data)) {
            return;
        }
        StackTraceElement[] traceElements = Thread.currentThread().getStackTrace();
        ProbeIdentification probeIdentification = data.getProbeInformation().getProbeIdentification();
        try {
            int index = this.findIndex(traceElements, probeIdentification.getProbeClassName(), probeIdentification.getProbeMethodName());
            if (index != -1 && index < traceElements.length) {
                if (traceElements.length > maxStackElements + index) {
                    traceElements = Arrays.copyOfRange(traceElements, index + 1, maxStackElements + index);
                } else if (traceElements.length > index + 1) {
                    traceElements = Arrays.copyOfRange(traceElements, index + 1, traceElements.length);
                }
            }
        }
        catch (Exception exception) {}
        JMSReceiveStackTraceRepository.add(new JMSStackTraceWrappper(probeIdentification.getProbeClassName(), probeIdentification.getProbeMethodName(), traceElements));
    }

    private int findIndex(StackTraceElement[] stackTrace, String className, String method) {
        int i = 0;
        while (i < stackTrace.length) {
            String className2 = stackTrace[i].getClassName();
            String methodName = stackTrace[i].getMethodName();
            if (className2.equals(className) && methodName.equals(method)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    public void doOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
    }

    public void doOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kInstance;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    protected void doOnAbortedTransactionEndTrace(int tracerIndex, IStackElement data) {
    }
}

