/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives.apply;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Arrays;

public class ParentPersistenceFileLockHelper {
    private static File file;
    private static FileChannel channel;
    private static IAgent fAgent;
    private static FileLock fLock;
    public static volatile boolean initializeSuccessful;
    private static boolean initializeExceptionLogFlag;
    public static final String FILELOCK_NAME = "ParentPersist.lock";

    static {
        fLock = null;
        initializeSuccessful = false;
        initializeExceptionLogFlag = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize(IAgent Agent) {
        fAgent = Agent;
        String path = null;
        try {
            try {
                path = ParentPersistenceFileLockHelper.getInstallationPath();
                if (path != null) {
                    file = new File(String.valueOf(path) + "/" + FILELOCK_NAME);
                }
                if (file != null) {
                    channel = new RandomAccessFile(file, "rw").getChannel();
                }
                if (channel == null) return;
                initializeSuccessful = true;
                return;
            }
            catch (FileNotFoundException e) {
                if (!initializeExceptionLogFlag) {
                    fAgent.IAgent_getModuleFeedback().error("Cannot create the lock file in " + path + ". Please enable write permissions to this folder for JMS Parent Candidate detection to work.");
                    if (fAgent != null && fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                        fAgent.IAgent_getModuleFeedback().debug("Cannot create the lock file in " + path + " " + Arrays.toString(e.getStackTrace()));
                    }
                    initializeExceptionLogFlag = true;
                }
                if (!initializeSuccessful) {
                    if (initializeExceptionLogFlag) return;
                    fAgent.IAgent_getModuleFeedback().error("Cannot create the lock file for persistence api in " + path + " .JMS Parent Candidate detection will not work.");
                    initializeExceptionLogFlag = true;
                    return;
                } else {
                    fAgent.IAgent_getModuleFeedback().info("Lock File created in " + path);
                }
                return;
            }
            catch (Exception e) {
                block20: {
                    fAgent.IAgent_getModuleFeedback().error("Cannot create the lock file for persistence api in " + path + " .JMS Parent Candidate detection will not work.");
                    if (fAgent != null && fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                        fAgent.IAgent_getModuleFeedback().debug("Cannot create the lock file for persistence api in " + path + " .JMS Parent Candidate detection will not work." + Arrays.toString(e.getStackTrace()));
                    }
                    initializeExceptionLogFlag = true;
                    if (initializeSuccessful) break block20;
                    if (initializeExceptionLogFlag) return;
                    fAgent.IAgent_getModuleFeedback().error("Cannot create the lock file for persistence api in " + path + " .JMS Parent Candidate detection will not work.");
                    initializeExceptionLogFlag = true;
                    return;
                }
                fAgent.IAgent_getModuleFeedback().info("Lock File created in " + path);
                return;
            }
        }
        finally {
            if (!initializeSuccessful) {
                if (!initializeExceptionLogFlag) {
                    fAgent.IAgent_getModuleFeedback().error("Cannot create the lock file for persistence api in " + path + " .JMS Parent Candidate detection will not work.");
                    initializeExceptionLogFlag = true;
                }
            } else {
                fAgent.IAgent_getModuleFeedback().info("Lock File created in " + path);
            }
        }
    }

    public static void acquireExclusiveLock() throws IOException {
        fLock = channel.lock();
    }

    public static void acquireSharedLock() throws IOException {
        fLock = channel.lock(0L, Long.MAX_VALUE, true);
    }

    public static FileLock trySharedLock() throws IOException {
        fLock = channel.tryLock(0L, Long.MAX_VALUE, true);
        return fLock;
    }

    public static FileLock tryExclusiveLock() throws IOException {
        fLock = channel.tryLock(0L, Long.MAX_VALUE, false);
        return fLock;
    }

    public static boolean hasLock() {
        return fLock != null;
    }

    public static boolean isLockValid() {
        return fLock.isValid();
    }

    public static void releaseLock() throws IOException {
        if (fLock != null) {
            fLock.release();
        }
    }

    private static String getInstallationPath() {
        String[] directivesList = AutoProbeTransformer.getDirectivesFileList();
        int i = 0;
        while (i < directivesList.length) {
            if (directivesList[i].endsWith("hotdeploy")) {
                return directivesList[i];
            }
            ++i;
        }
        return null;
    }
}

