/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.constants;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.diagnos.personality.java.classfile.DGClassConstants;
import com.wily.diagnos.personality.java.classfile.constants.DGClassConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGDoubleConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGFieldMethodRefConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGFloatConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGIntegerConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGInvalidConstantPoolIndexException;
import com.wily.diagnos.personality.java.classfile.constants.DGInvalidConstantPoolTypeException;
import com.wily.diagnos.personality.java.classfile.constants.DGLongConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGNameAndTypeConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGSecondSlotConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGStringConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGUnknownConstantTypeException;
import com.wily.diagnos.personality.java.classfile.constants.DGUtf8Constant;
import com.wily.diagnos.personality.java.classfile.constants.DGUtfDataTooLongException;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class DGConstantPool
implements DGClassConstants {
    private static final String kTooManyConstantPoolEntries = "Too many constant pool entries";
    private DGClass fDGClass;
    private Vector fConstants;
    private boolean fBuilding;
    private Hashtable fClassLookup = new Hashtable();
    private Hashtable fMethodLookup = new Hashtable();
    private Hashtable fStringLookup = new Hashtable();
    private Hashtable fNameAndTypeLookup = new Hashtable();
    private Hashtable fUTFLookup = new Hashtable();

    public DGConstantPool(DataInputStream in, DGClass cls) throws DGUnknownConstantTypeException, IOException {
        this.fDGClass = cls;
        this.fBuilding = true;
        int count = in.readUnsignedShort();
        this.fConstants = new Vector(count);
        this.fConstants.addElement(new Object());
        int i = 1;
        while (i < count) {
            DGConstant constant = DGConstant.createConstant(this, i, in);
            this.safeAddConstant(constant);
            if (constant.getTag() == 6 || constant.getTag() == 5) {
                this.safeAddConstant(new DGSecondSlotConstant(this, ++i));
            }
            ++i;
        }
        this.fBuilding = false;
    }

    public DGConstantPool() {
        this.fBuilding = true;
        this.fConstants = new Vector(100);
        this.fConstants.addElement(new Object());
        this.fBuilding = false;
    }

    private void addConstant(DGConstant constant) throws DGClassModificationException {
        if (this.fConstants.size() >= 65535) {
            throw new DGClassModificationException(kTooManyConstantPoolEntries, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Too_Many_Constant_Pool_Entries"));
        }
        this.safeAddConstant(constant);
    }

    private void safeAddConstant(DGConstant constant) {
        this.fConstants.addElement(constant);
    }

    private int getNumConstants() {
        return this.fConstants.size();
    }

    private DGConstant getConstantAt(int index) {
        return (DGConstant)this.fConstants.elementAt(index);
    }

    public void renameUtf(String oldName, String newName) throws DGClassLoadingException {
        int size = this.getNumConstants();
        int i = 1;
        while (i < size) {
            DGUtf8Constant utf;
            DGConstant constant = this.getConstantAt(i);
            if (constant instanceof DGUtf8Constant && (utf = (DGUtf8Constant)constant).getString().equals(oldName)) {
                try {
                    utf.validateAndSetStringValue(newName);
                }
                catch (DGUtfDataTooLongException dGUtfDataTooLongException) {}
            }
            constant.validate();
            ++i;
        }
    }

    public void validate() throws DGClassLoadingException {
        int size = this.getNumConstants();
        int i = 1;
        while (i < size) {
            DGConstant constant = this.getConstantAt(i);
            constant.validate();
            ++i;
        }
    }

    public void validateType(int index, int tag) throws DGClassLoadingException {
        if (index < 1 || index >= this.getNumConstants()) {
            throw new DGInvalidConstantPoolIndexException(index);
        }
        DGConstant constant = this.getConstantAt(index);
        if (constant.getTag() != tag) {
            throw new DGInvalidConstantPoolTypeException(index);
        }
    }

    public void validateType(int index, int[] tag) throws DGClassLoadingException {
        if (index < 1 || index >= this.getNumConstants()) {
            throw new DGInvalidConstantPoolIndexException(index);
        }
        DGConstant constant = this.getConstantAt(index);
        boolean matchedTag = false;
        int i = 0;
        while (i < tag.length) {
            if (constant.getTag() == tag[i]) {
                matchedTag = true;
            }
            ++i;
        }
        if (!matchedTag) {
            throw new DGInvalidConstantPoolTypeException(index);
        }
    }

    public void disassemble(PrintStream ps) {
        int size = this.getNumConstants();
        ps.println("Constant Pool Entries = " + size);
        ps.println();
        int i = 1;
        while (i < size) {
            DGConstant constant = this.getConstantAt(i);
            ps.println(constant);
            ++i;
        }
    }

    public void write(DataOutputStream out) throws IOException {
        int count = this.getNumConstants();
        out.writeShort(count);
        int i = 1;
        while (i < count) {
            DGConstant constant = this.getConstantAt(i);
            constant.write(out);
            ++i;
        }
    }

    void addToLookup(int tag, DGConstant constant) {
        switch (tag) {
            case 7: {
                DGClassConstant classConstant = (DGClassConstant)constant;
                this.fClassLookup.put(classConstant.getClassNameString(), constant);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                DGFieldMethodRefConstant methodConstant = (DGFieldMethodRefConstant)constant;
                this.fMethodLookup.put(new StringList(methodConstant.getClassName(), methodConstant.getName(), methodConstant.getType()), constant);
                break;
            }
            case 8: {
                DGStringConstant stringConstant = (DGStringConstant)constant;
                this.fStringLookup.put(stringConstant.getString(), constant);
                break;
            }
            case 12: {
                DGNameAndTypeConstant nameAndTypeConstant = (DGNameAndTypeConstant)constant;
                this.fNameAndTypeLookup.put(new StringList(nameAndTypeConstant.getName(), nameAndTypeConstant.getType()), constant);
                break;
            }
            case 1: {
                DGUtf8Constant utfConstant = (DGUtf8Constant)constant;
                this.fUTFLookup.put(utfConstant.getString(), constant);
            }
        }
    }

    public int addString(String s) throws DGClassModificationException {
        return this.addString(this.addUtf(s));
    }

    public int addString(int cpiUtf) throws DGClassModificationException {
        int index = this.getNumConstants();
        DGStringConstant c = new DGStringConstant(this, index, cpiUtf);
        this.addConstant(c);
        this.addToLookup(8, c);
        return index;
    }

    public int addStringIfNecessary(String str) throws DGClassModificationException {
        DGStringConstant stringConstant = (DGStringConstant)this.fStringLookup.get(str);
        if (stringConstant == null) {
            int strCPI = this.addUtfIfNecessary(str);
            return this.addString(strCPI);
        }
        return stringConstant.getIndex();
    }

    public int addUtfIfNecessary(String utfString) throws DGClassModificationException {
        DGUtf8Constant utfConstant = (DGUtf8Constant)this.fUTFLookup.get(utfString);
        if (utfConstant == null) {
            return this.addUtf(utfString);
        }
        return utfConstant.getIndex();
    }

    public int addUtf(String utfString) throws DGClassModificationException {
        int index = this.getNumConstants();
        DGUtf8Constant c = new DGUtf8Constant(this, index, utfString);
        this.addConstant(c);
        this.addToLookup(1, c);
        return index;
    }

    private String fixClassName(String orig) {
        boolean isObject;
        boolean isArray = orig.endsWith("[]");
        boolean bl = isObject = orig.indexOf(46) > 0;
        if (isArray && isObject) {
            int len = orig.length();
            return "[L" + orig.replace('.', '/').substring(0, len - 2) + ";";
        }
        if (isObject) {
            return orig.replace('.', '/');
        }
        return orig;
    }

    public int addClassReferenceIfNecessary(String className) throws DGClassModificationException {
        DGClassConstant classConstant = (DGClassConstant)this.fClassLookup.get(className = this.fixClassName(className));
        if (classConstant == null) {
            return this.addClassReference(className);
        }
        return classConstant.getIndex();
    }

    public int addClassReference(String className) throws DGClassModificationException {
        className = this.fixClassName(className);
        int cpiClassName = this.addUtf(className);
        int index = this.getNumConstants();
        DGClassConstant c = new DGClassConstant(this, index, cpiClassName);
        this.addConstant(c);
        this.addToLookup(7, c);
        return index;
    }

    public int addMethodReferenceIfNecessary(String className, String methodName, String methodType) throws DGClassModificationException {
        DGFieldMethodRefConstant methodConstant = (DGFieldMethodRefConstant)this.fMethodLookup.get(new StringList(className = this.fixClassName(className), methodName, methodType));
        if (methodConstant == null) {
            int cpiClass = this.addClassReferenceIfNecessary(className);
            int cpiNameAndType = this.addNameAndTypeIfNecessary(methodName, methodType);
            return this.addMethodReference(cpiClass, cpiNameAndType);
        }
        return methodConstant.getIndex();
    }

    public int addMethodReference(int cpiClass, int cpiNameAndType) throws DGClassModificationException {
        int index = this.getNumConstants();
        DGFieldMethodRefConstant c = new DGFieldMethodRefConstant(this, 10, index, cpiClass, cpiNameAndType);
        this.addConstant(c);
        this.addToLookup(10, c);
        return index;
    }

    public int addInterfaceMethodReferenceIfNecessary(String interfaceName, String methodName, String methodType) throws DGClassModificationException {
        DGFieldMethodRefConstant methodConstant = (DGFieldMethodRefConstant)this.fMethodLookup.get(new StringList(interfaceName = this.fixClassName(interfaceName), methodName, methodType));
        if (methodConstant == null) {
            int cpiClass = this.addClassReferenceIfNecessary(interfaceName);
            int cpiNameAndType = this.addNameAndTypeIfNecessary(methodName, methodType);
            return this.addInterfaceMethodReference(cpiClass, cpiNameAndType);
        }
        return methodConstant.getIndex();
    }

    public int addInterfaceMethodReference(int cpiClass, int cpiNameAndType) throws DGClassModificationException {
        int index = this.getNumConstants();
        DGFieldMethodRefConstant c = new DGFieldMethodRefConstant(this, 11, index, cpiClass, cpiNameAndType);
        this.addConstant(c);
        this.addToLookup(11, c);
        return index;
    }

    public int addMethodReference(String className, String methodName, String methodType) throws DGClassModificationException {
        className = this.fixClassName(className);
        int cpiClass = this.addClassReference(className);
        int cpiNameAndType = this.addNameAndType(methodName, methodType);
        return this.addMethodReference(cpiClass, cpiNameAndType);
    }

    public int addFieldReference(int cpiClass, int cpiNameAndType) throws DGClassModificationException {
        int index = this.getNumConstants();
        DGFieldMethodRefConstant c = new DGFieldMethodRefConstant(this, 9, index, cpiClass, cpiNameAndType);
        this.addConstant(c);
        return index;
    }

    public int addNameAndTypeIfNecessary(String name, String type) throws DGClassModificationException {
        DGNameAndTypeConstant nameAndTypeConstant = (DGNameAndTypeConstant)this.fNameAndTypeLookup.get(new StringList(name, type));
        if (nameAndTypeConstant == null) {
            int cpiName = this.addUtfIfNecessary(name);
            int cpiType = this.addUtfIfNecessary(type);
            return this.addNameAndType(cpiName, cpiType);
        }
        return nameAndTypeConstant.getIndex();
    }

    public int addNameAndType(String name, String type) throws DGClassModificationException {
        int cpiName = this.addUtf(name);
        int cpiType = this.addUtf(type);
        return this.addNameAndType(cpiName, cpiType);
    }

    public int addNameAndType(int cpiName, int cpiType) throws DGClassModificationException {
        int index = this.getNumConstants();
        DGNameAndTypeConstant c = new DGNameAndTypeConstant(this, index, cpiName, cpiType);
        this.addConstant(c);
        this.addToLookup(12, c);
        return index;
    }

    public int addInteger(int constantValue) throws DGClassModificationException {
        int index = this.getNumConstants();
        DGIntegerConstant c = new DGIntegerConstant(this, index, constantValue);
        this.addConstant(c);
        return index;
    }

    public int addLong(long constantValue) throws DGClassModificationException {
        int index = this.getNumConstants();
        DGLongConstant c = new DGLongConstant(this, index, constantValue);
        this.addConstant(c);
        this.addConstant(new DGSecondSlotConstant(this, this.getNumConstants()));
        return index;
    }

    public DGFieldMethodRefConstant[] findFieldMethodReferences(String className, String memberName, String memberType) {
        className = this.fixClassName(className);
        Vector<DGFieldMethodRefConstant> matches = new Vector<DGFieldMethodRefConstant>();
        int size = this.getNumConstants();
        int i = 1;
        while (i < size) {
            DGConstant constant = this.getConstantAt(i);
            if (constant.getTag() == 10 || constant.getTag() == 11 || constant.getTag() == 9) {
                DGFieldMethodRefConstant member = (DGFieldMethodRefConstant)constant;
                String cName = member.getClassName();
                String mName = member.getName();
                String mType = member.getType();
                if (cName.equals(className) && mName.equals(memberName) && mType.equals(memberType)) {
                    matches.addElement(member);
                }
            }
            ++i;
        }
        Object[] results = new DGFieldMethodRefConstant[matches.size()];
        matches.copyInto(results);
        return results;
    }

    public int findClassReference(String className) {
        className = this.fixClassName(className);
        int size = this.getNumConstants();
        int i = 1;
        while (i < size) {
            DGClassConstant c;
            String cName;
            DGConstant constant = this.getConstantAt(i);
            if (constant.getTag() == 7 && (cName = (c = (DGClassConstant)constant).getClassNameString()).equals(className)) {
                return c.getIndex();
            }
            ++i;
        }
        return 0;
    }

    public Integer[] findAllClassReferences(String className) {
        className = this.fixClassName(className);
        int size = this.getNumConstants();
        ArrayList<Integer> referenceList = new ArrayList<Integer>(1);
        int i = 1;
        while (i < size) {
            DGClassConstant c;
            String cName;
            DGConstant constant = this.getConstantAt(i);
            if (constant.getTag() == 7 && (cName = (c = (DGClassConstant)constant).getClassNameString()).equals(className)) {
                referenceList.add(c.getIndex());
            }
            ++i;
        }
        return referenceList.toArray(new Integer[referenceList.size()]);
    }

    public int findUTFIndex(String utfString) {
        int size = this.getNumConstants();
        int i = 1;
        while (i < size) {
            DGUtf8Constant c;
            DGConstant constant = this.getConstantAt(i);
            if (constant.getTag() == 1 && (c = (DGUtf8Constant)constant).getString().equals(utfString)) {
                return c.getIndex();
            }
            ++i;
        }
        return 0;
    }

    public DGClass getDGClass() {
        return this.fDGClass;
    }

    public String getFieldClass(int cpi) {
        return this.getFieldMethodRefClass(cpi);
    }

    public String getFieldName(int cpi) {
        return this.getFieldMethodRefName(cpi);
    }

    public String getFieldType(int cpi) {
        return this.getFieldMethodRefType(cpi);
    }

    public String getMethodClass(int cpi) {
        return this.getFieldMethodRefClass(cpi);
    }

    public String getMethodName(int cpi) {
        return this.getFieldMethodRefName(cpi);
    }

    public String getMethodType(int cpi) {
        return this.getFieldMethodRefType(cpi);
    }

    public String getInterfaceMethodClass(int cpi) {
        return this.getFieldMethodRefClass(cpi);
    }

    public String getInterfaceMethodName(int cpi) {
        return this.getFieldMethodRefName(cpi);
    }

    public String getInterfaceMethodType(int cpi) {
        return this.getFieldMethodRefType(cpi);
    }

    private String getFieldMethodRefClass(int cpi) {
        if (this.fBuilding) {
            return null;
        }
        DGFieldMethodRefConstant constant = (DGFieldMethodRefConstant)this.getConstantAt(cpi);
        return constant.getClassName();
    }

    private String getFieldMethodRefName(int cpi) {
        if (this.fBuilding) {
            return null;
        }
        DGFieldMethodRefConstant constant = (DGFieldMethodRefConstant)this.getConstantAt(cpi);
        return constant.getName();
    }

    private String getFieldMethodRefType(int cpi) {
        if (this.fBuilding) {
            return null;
        }
        DGFieldMethodRefConstant constant = (DGFieldMethodRefConstant)this.getConstantAt(cpi);
        return constant.getType();
    }

    public int getInteger(int constantPoolIndex) {
        if (this.fBuilding) {
            return 0;
        }
        DGIntegerConstant constant = (DGIntegerConstant)this.getConstantAt(constantPoolIndex);
        return constant.getInt();
    }

    public float getFloat(int constantPoolIndex) {
        if (this.fBuilding) {
            return 0.0f;
        }
        DGFloatConstant constant = (DGFloatConstant)this.getConstantAt(constantPoolIndex);
        return constant.getFloat();
    }

    public long getLong(int constantPoolIndex) {
        if (this.fBuilding) {
            return 0L;
        }
        DGLongConstant constant = (DGLongConstant)this.getConstantAt(constantPoolIndex);
        return constant.getLong();
    }

    public double getDouble(int constantPoolIndex) {
        if (this.fBuilding) {
            return 0.0;
        }
        DGDoubleConstant constant = (DGDoubleConstant)this.getConstantAt(constantPoolIndex);
        return constant.getDouble();
    }

    public String getString(int constantPoolIndex) {
        if (this.fBuilding) {
            return null;
        }
        DGStringConstant constant = (DGStringConstant)this.getConstantAt(constantPoolIndex);
        return constant.getString();
    }

    public String getUtf(int constantPoolIndex) {
        if (this.fBuilding) {
            return null;
        }
        DGUtf8Constant constant = (DGUtf8Constant)this.getConstantAt(constantPoolIndex);
        return constant.getString();
    }

    public String getName(int constantPoolIndex) {
        String result = null;
        if (this.fBuilding) {
            return null;
        }
        DGConstant dgConstant = this.getConstantAt(constantPoolIndex);
        if (dgConstant instanceof DGNameAndTypeConstant) {
            result = ((DGNameAndTypeConstant)dgConstant).getName();
        } else if (dgConstant instanceof DGStringConstant) {
            result = ((DGStringConstant)dgConstant).getString();
        }
        return result;
    }

    public DGConstant getConstant(int constantPoolIndex) {
        if (this.fBuilding) {
            return null;
        }
        DGConstant constant = this.getConstantAt(constantPoolIndex);
        return constant;
    }

    public String getType(int constantPoolIndex) {
        if (this.fBuilding) {
            return null;
        }
        DGNameAndTypeConstant constant = (DGNameAndTypeConstant)this.getConstantAt(constantPoolIndex);
        return constant.getType();
    }

    public String getClassName(int constantPoolIndex) {
        if (this.fBuilding) {
            return null;
        }
        DGClassConstant constant = (DGClassConstant)this.getConstantAt(constantPoolIndex);
        return constant.getClassNameString();
    }

    public boolean isConstructorCall(int cpiMethod, int cpiSuperClass) {
        DGFieldMethodRefConstant constant = (DGFieldMethodRefConstant)this.getConstantAt(cpiMethod);
        String superClassName = this.getClassName(cpiSuperClass);
        boolean isSuper = constant.getClassName().equals(superClassName);
        boolean isInit = constant.getName().equals("<init>");
        return isInit && !isSuper;
    }

    private static class StringList {
        private Vector fList = new Vector();

        public StringList() {
        }

        public StringList(String str1, String str2) {
            this();
            this.addString(str1);
            this.addString(str2);
        }

        public StringList(String str1, String str2, String str3) {
            this();
            this.addString(str1);
            this.addString(str2);
            this.addString(str3);
        }

        private void addString(String str) {
            this.fList.addElement(str);
        }

        public int size() {
            return this.fList.size();
        }

        public String stringAt(int index) {
            return (String)this.fList.elementAt(index);
        }

        public int hashCode() {
            int result = 0;
            int count = this.size();
            int i = 0;
            while (i < count) {
                result += this.stringAt(i).hashCode();
                ++i;
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StringList) {
                StringList list = (StringList)obj;
                int count = this.size();
                if (count == list.size()) {
                    int i = 0;
                    while (i < count) {
                        if (!this.stringAt(i).equals(list.stringAt(i))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

