/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.api;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.BeanConfigElement;
import com.ca.apm.agent.jmxclient.api.ConfigElements;
import com.wily.introscope.agent.trace.intelligent.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class ConfigurationReader {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private static final String JMX_MODULE_FILE_EXT = ".yaml";
    private static final String JMX_MODULES_DIR_PATH = "/com/ca/agent/jmx/modules/";

    public static Set<BeanConfigElement> readModuleConfig(String[] modulePaths) {
        HashSet<BeanConfigElement> elements = new HashSet<BeanConfigElement>();
        if (modulePaths != null) {
            String[] stringArray = modulePaths;
            int n = modulePaths.length;
            int n2 = 0;
            while (n2 < n) {
                String modulePath = stringArray[n2];
                try {
                    ModuleResourcePath path = ConfigurationReader.getConfigFilePath(modulePath);
                    Set<BeanConfigElement> moduleElements = ConfigurationReader.readConfigFile(path);
                    if (path.isFile()) {
                        ConfigurationReader.updateScriptPathIfNeeded(moduleElements, new File(path.getPath()).getParent());
                    }
                    elements.addAll(moduleElements);
                }
                catch (Exception e) {
                    LOGGER.logError("Could not load configuration for module: " + modulePath);
                    LOGGER.logDebugMessage(e.getMessage(), (Throwable)e);
                }
                ++n2;
            }
        }
        return elements;
    }

    static Set<BeanConfigElement> readConfigFile(String modulePath) {
        return ConfigurationReader.readConfigFile(new ModuleResourcePath(modulePath, false));
    }

    public static Set<BeanConfigElement> readConfigFile(ModuleResourcePath modulePath) {
        HashSet<BeanConfigElement> elements = new HashSet<BeanConfigElement>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = modulePath.isJarResource() ? ConfigurationReader.getResourceAsStream(modulePath.getPath()) : new FileInputStream(modulePath.getPath());){
                elements.addAll(ConfigurationReader.readConfig(is));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.logDebugMessage(e.getMessage(), (Throwable)e);
        }
        return elements;
    }

    public static List<BeanConfigElement> readConfig(InputStream stream) {
        ConfigElements config = ConfigurationReader.readConfigStream(stream);
        return config != null ? config.getConfigElements() : Collections.emptyList();
    }

    private static ConfigElements readConfigStream(InputStream stream) {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(ConfigElements.class));
        ConfigElements config = (ConfigElements)yaml.load(stream);
        return config;
    }

    private static ModuleResourcePath getConfigFilePath(String modulePath) throws FileNotFoundException {
        File module = new File(modulePath);
        if (module.exists()) {
            if (module.isDirectory()) {
                String[] exts;
                String[] stringArray = exts = new String[]{"jmx.yml", "jmx.yaml"};
                int n = exts.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    File f = new File(module, ext);
                    if (f.exists()) {
                        return new ModuleResourcePath(f.getAbsolutePath(), false);
                    }
                    ++n2;
                }
                throw new FileNotFoundException(String.valueOf(modulePath) + File.separator + "jmx.yaml");
            }
            return new ModuleResourcePath(module.getAbsolutePath(), false);
        }
        String path = modulePath;
        if (!path.endsWith(JMX_MODULE_FILE_EXT)) {
            path = String.valueOf(path) + JMX_MODULE_FILE_EXT;
        }
        path = JMX_MODULES_DIR_PATH + path;
        LOGGER.logDebugMessage("looking for module file inside jar at path: " + path);
        if (!ConfigurationReader.isResourceAvailable(path)) {
            throw new FileNotFoundException(modulePath);
        }
        return new ModuleResourcePath(path, true);
    }

    private static boolean isResourceAvailable(String path) {
        return ConfigurationReader.class.getResource(path) != null;
    }

    private static InputStream getResourceAsStream(String path) {
        return ConfigurationReader.class.getResourceAsStream(path);
    }

    private static void updateScriptPathIfNeeded(Set<BeanConfigElement> elements, String moduleDir) {
        for (BeanConfigElement el : elements) {
            String script = el.getValueTransformer();
            if (script == null || script.isEmpty() || !script.endsWith(".js") || new File(script).isAbsolute()) continue;
            el.setValueTransformer(String.valueOf(moduleDir) + File.separator + "scripts" + File.separator + script);
        }
    }

    private static class ModuleResourcePath {
        private final String path;
        private final boolean isJarResource;

        public ModuleResourcePath(String path, boolean isInternal) {
            this.path = path;
            this.isJarResource = isInternal;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isJarResource() {
            return this.isJarResource;
        }

        public boolean isFile() {
            return !this.isJarResource;
        }
    }
}

