/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.springboot.actuator;

import com.ca.apm.agent.jmxclient.Configuration;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.Glob;
import java.util.Arrays;

public class ActuatorProperties {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    public static final String SKIP_METRIC_PROP = "introscope.agent.remotejmx.springboot.metricEndpoint.skip.metricName";
    private static Glob[] skipMetrics = new Glob[0];
    public static final String SKIP_TAG_PROP = "introscope.agent.remotejmx.springboot.metricEndpoint.skip.tagName";
    private static Glob[] skipTags = new Glob[0];
    public static final String SKIP_STATISTIC_PROP = "introscope.agent.remotejmx.springboot.metricEndpoint.skip.statisticName";
    private static Glob[] skipStatistics = new Glob[0];
    private static volatile IAgent agent = null;

    static {
        try {
            agent = AgentShim.getAgent();
        }
        catch (AgentNotAvailableException e) {
            AgentShim.handleError((String)"Error while getting Agent instance for generic JMX", (Throwable)e);
        }
    }

    public static void initProperties() {
        skipMetrics = ActuatorProperties.transferProperty(agent.IAgent_getIndexedProperties().getProperty(SKIP_METRIC_PROP, ""));
        skipTags = ActuatorProperties.transferProperty(agent.IAgent_getIndexedProperties().getProperty(SKIP_TAG_PROP, ""));
        skipStatistics = ActuatorProperties.transferProperty(agent.IAgent_getIndexedProperties().getProperty(SKIP_STATISTIC_PROP, ""));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebugMessage("introscope.agent.remotejmx.springboot.metricEndpoint.skip.metricName is set to " + Arrays.deepToString(skipMetrics));
            LOGGER.logDebugMessage("introscope.agent.remotejmx.springboot.metricEndpoint.skip.tagName is set to " + Arrays.deepToString(skipTags));
            LOGGER.logDebugMessage("introscope.agent.remotejmx.springboot.metricEndpoint.skip.statisticName is set to " + Arrays.deepToString(skipStatistics));
        }
    }

    private static Glob[] transferProperty(String property) {
        String[] values = property.split(",");
        Glob[] results = new Glob[values.length];
        int i = 0;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            results[i] = new Glob(value);
            ++i;
            ++n2;
        }
        return results;
    }

    public static boolean shouldSkipMetrics(String input) {
        return ActuatorProperties.shouldSkip(input, skipMetrics);
    }

    public static boolean shouldSkipTags(String input) {
        return ActuatorProperties.shouldSkip(input, skipTags);
    }

    public static boolean shouldSkipStatistics(String input) {
        return ActuatorProperties.shouldSkip(input, skipStatistics);
    }

    private static boolean shouldSkip(String input, Glob[] skipGlobs) {
        int i = 0;
        while (i < skipGlobs.length) {
            if (skipGlobs[i].matches(input)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

