/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection;

import com.wily.introscope.agent.intelligent.detection.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.apis.AbstractRuleEngine;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.apis.RulesExecutionStatus;
import java.util.ArrayList;
import java.util.List;

public class BasicRuleEngine
extends AbstractRuleEngine {
    private int maxInitialCandidates;
    private int maxDepthToTraverse;

    public BasicRuleEngine(int maxInitialCandidates, int maxDepthToTraverse) {
        this.maxInitialCandidates = maxInitialCandidates;
        this.maxDepthToTraverse = maxDepthToTraverse;
    }

    @Override
    public List<IndexAwareTraceElement> execute(IndexAwareTraceElement[] trace) {
        Logger.logDebugMessage("Basic Rule Engine started executing rules for stack trace received.");
        List<IndexAwareTraceElement> traceElements = this.identifyCandidates(trace);
        return traceElements;
    }

    private List<IndexAwareTraceElement> identifyCandidates(IndexAwareTraceElement[] traceElements) {
        ArrayList<IndexAwareTraceElement> identifiedCandidates = new ArrayList<IndexAwareTraceElement>();
        int length = traceElements.length;
        IndexAwareTraceElement element = null;
        RulesExecutionStatus status = null;
        int numCandidatesDetected = 0;
        boolean maxDepthReached = false;
        if (length > 0) {
            int index = length - 1;
            while (index >= 0 && numCandidatesDetected < this.maxInitialCandidates && !maxDepthReached) {
                element = traceElements[index];
                status = new RulesExecutionStatus(this.maxInitialCandidates, numCandidatesDetected);
                try {
                    this.executeRules(index, traceElements, status);
                }
                catch (Exception e) {
                    Logger.logDebugMessage("Exception while executing rules on element:" + element, e);
                }
                if (status.isMarkedAsCandidate()) {
                    element = traceElements[index];
                    identifiedCandidates.add(element);
                    ++numCandidatesDetected;
                }
                maxDepthReached = length - index > this.maxDepthToTraverse;
                --index;
            }
        }
        return identifiedCandidates;
    }

    public void setMaxInitialCandidates(int maxInitialCandidates) {
        this.maxInitialCandidates = maxInitialCandidates;
    }

    public void setMaxDepthToTraverse(int maxDepthToTraverse) {
        this.maxDepthToTraverse = maxDepthToTraverse;
    }
}

