/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.introscope.agent.intelligent.detection.rules.AbstractRule;
import com.wily.introscope.agent.intelligent.detection.rules.CommonUtils;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class IsInterestingMethodNameRule
extends AbstractRule {
    private final Set<Pattern> methodNamePatterns = new HashSet<Pattern>();

    public IsInterestingMethodNameRule(Set<String> methodNameRegexps) {
        for (String regex : methodNameRegexps) {
            this.methodNamePatterns.add(Pattern.compile(regex, 2));
        }
    }

    public IsInterestingMethodNameRule(String methodNameRegex) {
        this.methodNamePatterns.add(Pattern.compile(methodNameRegex, 2));
    }

    @Override
    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        boolean passes = false;
        if (this.methodNamePatterns != null && this.methodNamePatterns.size() > 0) {
            IndexAwareTraceElement traceElement = trace[currentElementIndex];
            String methodName = traceElement.getMethodName();
            for (Pattern pattern : this.methodNamePatterns) {
                if (!pattern.matcher(methodName).matches()) continue;
                passes = true;
                break;
            }
        }
        return passes;
    }

    @Override
    public String toString() {
        return CommonUtils.formatStringRep(String.valueOf(this.getClass().getSimpleName()) + ", methodNamePatterns:" + this.methodNamePatterns);
    }
}

