/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.osgi.bootdelegation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class FelixOsgiBootdelegationHelper
extends ASingleInstanceTracerFactory {
    private final IModuleFeedbackChannel logger;
    private static String bootdelegationPropName = "org.osgi.framework.bootdelegation";
    private static String wilybootdelegationPropValue = "com.wily.*";

    public FelixOsgiBootdelegationHelper(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (data.getInvocationParameterCount() == 1 && data.getInvocationParameterAsObject(0) instanceof Map) {
            Map felixConfig = (Map)data.getInvocationParameterAsObject(0);
            if (felixConfig.get(bootdelegationPropName) instanceof String) {
                String bootdelegationProp = (String)felixConfig.get(bootdelegationPropName);
                if (!bootdelegationProp.contains(wilybootdelegationPropValue)) {
                    if (bootdelegationProp.trim().length() > 0) {
                        wilybootdelegationPropValue = String.valueOf(wilybootdelegationPropValue) + "," + bootdelegationProp;
                    }
                } else {
                    return;
                }
            }
            this.logger.info("Set org.osgi.framework.bootdelegation property to " + wilybootdelegationPropValue);
            Object configObject = data.getInvocationParameterAsObject(0);
            Class<?> mapClass = data.getInvocationParameterAsObject(0).getClass();
            Object[] argArray = new Object[2];
            Class[] classArray = new Class[2];
            argArray[0] = bootdelegationPropName;
            argArray[1] = wilybootdelegationPropValue;
            classArray[0] = Object.class;
            classArray[1] = Object.class;
            try {
                Method privateStringMethod = mapClass.getMethod("put", classArray);
                privateStringMethod.setAccessible(true);
                privateStringMethod.invoke(configObject, argArray);
            }
            catch (SecurityException e) {
                this.logger.error("SecurityException: ", e);
            }
            catch (NoSuchMethodException e) {
                this.logger.error("NoSuchMethodException: ", e);
            }
            catch (IllegalArgumentException e) {
                this.logger.error("IllegalArgumentException: ", e);
            }
            catch (IllegalAccessException e) {
                this.logger.error("IllegalAccessException: ", e);
            }
            catch (InvocationTargetException e) {
                this.logger.error("InvocationTargetException: ", e);
            }
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

