/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.intelligent.AutoTracingController;
import com.wily.introscope.agent.trace.intelligent.DeepTraceConfigurations;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.properties.AttributeListing;

public class ComponentTimeAutoTraceTriggerTracer
extends ASingleMetricTracerFactory {
    private static final String kUnformattedAutoTraceTriggerReason = "Response time of Component '%s' exceeded threshold %d s";
    private volatile String fComponentName;
    private static final String kResponseTimeThresholdKey = "responsethreshold";
    private final long fResponseTimeThresholdInSecs;
    private final long fResponseTimeThresholdInMillis;

    public ComponentTimeAutoTraceTriggerTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        int paramValue = this.getIntegerParameter(kResponseTimeThresholdKey, -1);
        this.fResponseTimeThresholdInSecs = paramValue >= 0 ? (long)paramValue : DeepTraceConfigurations.fComponentTimeThresholdForAutoTraceTrigger;
        this.fResponseTimeThresholdInMillis = this.fResponseTimeThresholdInSecs * 1000L;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        data.storeWallClockStartTime();
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        InvocationData invocationData = data;
        long elapsed = invocationData.getWallClockElapsedTime();
        if (elapsed > this.fResponseTimeThresholdInMillis) {
            if (this.fComponentName == null) {
                this.fComponentName = this.getComponentName(data);
            }
            if (Logger.isTraceEnabled()) {
                String message = String.format("Response time: %d ms of Component: '%s' is more than configured threshold: %d ms. Requesting AutoTracingController to mark this transaction for tracing.", elapsed, this.fComponentName, this.fResponseTimeThresholdInMillis);
                Logger.logTraceMessage(message);
            }
            AutoTracingController.markForAutoTracing(invocationData, String.format(kUnformattedAutoTraceTriggerReason, this.fComponentName, this.fResponseTimeThresholdInSecs), this.fComponentName);
        }
    }

    @Override
    protected IRepository getRepository(InvocationData data, ISharedMetricHolder holder) {
        return null;
    }

    @Override
    protected void doOnStartTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    @Override
    protected void doOnEndTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    @Override
    public String getComponentName(InvocationData data) {
        String name = this.getComponentNameOfLastBlamePoint(data);
        if (name == null) {
            name = this.getProbeIdentification().getIdentification();
        }
        return name;
    }

    public String getComponentNameOfLastBlamePoint(InvocationData data) {
        String componentName = null;
        ITracer[] tracers = data.getTracersByType(null);
        int i = tracers.length - 1;
        while (i >= 0) {
            if (tracers[i] != null && (tracers[i] instanceof BlamePointTracer || tracers[i] instanceof com.wily.introscope.agent.trace.BlamePointTracer) && (componentName = data.getComponentNameAt(i)) != null) break;
            --i;
        }
        return componentName;
    }
}

