/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.trace.intelligent.ITcdMap;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import java.util.HashMap;
import java.util.Map;

final class TcdMap {
    public static final ITcdMap kEmptyMap = new ITcdMap(){

        @Override
        public void put(int id, TransactionComponentData tcd) {
        }

        @Override
        public TransactionComponentData get(int id) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }
    };

    TcdMap() {
    }

    static final ITcdMap createArrayBased(int expectedSize) {
        return new ArrayBased(expectedSize);
    }

    static final ITcdMap createHashBased() {
        return new HashBased();
    }

    static final ITcdMap createSmall(int fixedCapacity) {
        if (fixedCapacity == 1) {
            return new SingleElement();
        }
        return new SmallNumber(fixedCapacity);
    }

    static final ITcdMap create(int capacity) {
        if (capacity < 3) {
            return TcdMap.createSmall(capacity);
        }
        if (capacity < 64) {
            return TcdMap.createArrayBased(capacity);
        }
        return TcdMap.createHashBased();
    }

    private static final class ArrayBased
    implements ITcdMap {
        private final TransactionComponentData[] arr;
        private Map<Integer, TransactionComponentData> extra;
        private int baseIndex = -1;
        private int size;

        ArrayBased(int expectedSize) {
            this.arr = new TransactionComponentData[expectedSize << 4];
            this.size = 0;
        }

        @Override
        public void put(int id, TransactionComponentData tcd) {
            if (this.baseIndex < 0) {
                this.baseIndex = id;
                this.arr[0] = tcd;
                this.size = 1;
                return;
            }
            int index = id - this.baseIndex;
            if (index >= 0 && index < this.arr.length) {
                if (this.arr[index] == null) {
                    ++this.size;
                }
                this.arr[index] = tcd;
                return;
            }
            if (this.extra == null) {
                this.extra = new HashMap<Integer, TransactionComponentData>();
            }
            this.extra.put(id, tcd);
        }

        @Override
        public TransactionComponentData get(int id) {
            if (this.baseIndex < 0) {
                return null;
            }
            int index = id - this.baseIndex;
            if (index >= 0 && index < this.arr.length) {
                return this.arr[index];
            }
            if (this.extra == null) {
                return null;
            }
            return this.extra.get(id);
        }

        @Override
        public int size() {
            return this.size + (this.extra != null ? this.extra.size() : 0);
        }
    }

    private static final class HashBased
    extends HashMap<Integer, TransactionComponentData>
    implements ITcdMap {
        private static final long serialVersionUID = 8393595541528184101L;

        private HashBased() {
        }

        @Override
        public void put(int id, TransactionComponentData tcd) {
            super.put(id, tcd);
        }

        @Override
        public TransactionComponentData get(int id) {
            return (TransactionComponentData)super.get(id);
        }
    }

    private static final class SingleElement
    implements ITcdMap {
        private int id;
        private TransactionComponentData tcd;

        private SingleElement() {
        }

        @Override
        public void put(int id, TransactionComponentData tcd) {
            if (this.tcd != null) {
                return;
            }
            this.id = id;
            this.tcd = tcd;
        }

        @Override
        public TransactionComponentData get(int id) {
            if (this.id == id) {
                return this.tcd;
            }
            return null;
        }

        @Override
        public int size() {
            return this.tcd != null ? 1 : 0;
        }
    }

    private static final class SmallNumber
    implements ITcdMap {
        private final int[] ids;
        private final TransactionComponentData[] tcds;
        private int size;

        SmallNumber(int capactiy) {
            this.ids = new int[capactiy];
            this.tcds = new TransactionComponentData[capactiy];
        }

        @Override
        public void put(int id, TransactionComponentData tcd) {
            int i = 0;
            while (i < this.size) {
                int currentId = this.ids[i];
                if (currentId == id) {
                    this.tcds[i] = tcd;
                    return;
                }
                ++i;
            }
            this.ids[this.size] = id;
            this.tcds[this.size] = tcd;
            ++this.size;
        }

        @Override
        public TransactionComponentData get(int id) {
            int i = 0;
            while (i < this.size) {
                int currentId = this.ids[i];
                if (currentId == id) {
                    return this.tcds[i];
                }
                ++i;
            }
            return null;
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

