/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.nio.ChannelPerIntervalCounter;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import com.wily.introscope.agent.trace.nio.SocketAcceptMappingTracer;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public final class DatagramReceiveMethodPerIntervalCounter
extends ChannelPerIntervalCounter
implements ITracer {
    public DatagramReceiveMethodPerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof DatagramChannel && data.hasInvocationParametersAvailable() && data.getInvocationParameterAsObject(0) instanceof ByteBuffer) {
            return this;
        }
        Assertion.wilyAssert("Instrumentation error: instrumented object is not a DatagramChannel or does not have parameter of type ByteBuffer");
        return null;
    }

    @Override
    protected final ILongIntervalCounterDataAccumulator createDataAccumulator(InvocationData data) {
        Object result;
        DatagramChannel channel = (DatagramChannel)data.getInvocationObject();
        if (data.hasMethodResultAvailable() && (result = data.getInvocationReturnValueAsObject()) != null) {
            if (result instanceof InetSocketAddress) {
                String formattedName;
                InetSocketAddress remoteAddress = (InetSocketAddress)result;
                if (DatagramChannelMap.isRequired(channel, remoteAddress, this.getAgent()) && (formattedName = this.formatParameterizedName(data)) != null) {
                    return this.createDataAccumulator(formattedName);
                }
            } else {
                Assertion.wilyAssert("Instrumentation error: instrumented method return value is not an InetSocketAddress");
            }
        }
        return null;
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (SocketAcceptMappingTracer.checkWithOverheadMgr()) {
            return;
        }
        if (data.isSocketClamped()) {
            return;
        }
        super.ITracer_finishTrace(tracerIndex, data);
    }
}

