/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.introscope.agent.util.ReflectionLookupException;
import com.wily.introscope.agent.util.ReflectionLookupStore;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static final char[] kIllegalResourceChars = new char[]{':'};

    private ReflectionUtils() {
    }

    public static Object invokeMethodOnObject(Object object, String methodName, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = object.getClass();
        Method method = clazz.getMethod(methodName, parameterTypes);
        method.setAccessible(true);
        return method.invoke(object, args);
    }

    public static Object getFieldValueOfObject(Class clazz, Object obj, String fieldName) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field privateField = clazz.getDeclaredField(fieldName);
        privateField.setAccessible(true);
        return privateField.get(obj);
    }

    public static Object invokeMethodOnObject(Object object, String methodName, boolean publicModifier, IModuleFeedbackChannel feedback) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ReflectionLookupException {
        Method method = ReflectionLookupStore.lookupMethod(object, methodName, publicModifier, feedback);
        return method.invoke(object, new Object[0]);
    }

    public static Object invokeMethodOnObject(Object object, String methodName, String[] strings, Object[] args, boolean publicModifier, IModuleFeedbackChannel feedback) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ReflectionLookupException {
        Method method = ReflectionLookupStore.lookupMethod(object, methodName, strings, publicModifier, feedback);
        return method.invoke(object, args);
    }

    public static Object invokeMethodOnObject(Class classToInvoke, Object object, String methodName, String[] strings, Object[] args, boolean publicModifier, IModuleFeedbackChannel feedback) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ReflectionLookupException {
        Method method = ReflectionLookupStore.lookupMethodOnClass(classToInvoke, methodName, strings, publicModifier, feedback);
        return method.invoke(object, args);
    }

    public static Object invokeMethodOnClass(ClassLoader classLoader, String className, String methodName, String[] strings, Object[] objects, boolean publicModifier, IModuleFeedbackChannel feedback) throws ReflectionLookupException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class bxAttributes = ReflectionLookupStore.lookupClass(className, classLoader);
        Method method = ReflectionLookupStore.lookupMethodOnClass(bxAttributes, methodName, strings, publicModifier, feedback);
        return method.invoke(null, objects);
    }

    public static String formatToBeResourceSafe(String value) {
        return StringUtils.replaceIllegalChars(value, kIllegalResourceChars, '_');
    }

    public static boolean checkMethodExists(Object object, String methodName, boolean publicModifier, IModuleFeedbackChannel feedback) {
        try {
            ReflectionLookupStore.lookupMethod(object, methodName, publicModifier, feedback);
            return true;
        }
        catch (ReflectionLookupException reflectionLookupException) {
            return false;
        }
    }

    public static Object getFieldValueFromClass(ClassLoader classLoader, Object callableObject, String className, String fieldName, boolean publicModifier) throws ReflectionLookupException, IllegalArgumentException, IllegalAccessException {
        Field field = ReflectionLookupStore.lookupField(classLoader, className, fieldName, publicModifier);
        if (field != null) {
            return field.get(callableObject);
        }
        return null;
    }

    public static Object getFieldValueFromClass(Object object, Class classInstance, String fieldName, boolean publicModifier) throws NoSuchFieldException, SecurityException, ReflectionLookupException, IllegalArgumentException, IllegalAccessException {
        Field field = ReflectionLookupStore.lookupField(classInstance, fieldName, publicModifier);
        if (field != null) {
            return field.get(object);
        }
        return null;
    }
}

