/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.ACombiningGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class RateGatherer
extends ACombiningGatherer {
    public RateGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        Assertion.wilyAssert(false);
    }

    @Override
    protected void doResetCombiningGatherer(long when) {
    }

    @Override
    protected void doReinitializeCombiningGatherer() {
    }

    @Override
    protected ATimeslicedValue doCombiningHarvest(long when, BlameStackSnapshot blameStack) {
        if (this.isDataAbsent()) {
            return new IntegerTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, true);
        }
        long startTime = this.getStartTimestampInMillis();
        long elapsedMS = when - startTime;
        int ratePerSecond = elapsedMS == 0L ? 0 : (int)(this.getDataPointCount() * 1000L / elapsedMS);
        IntegerTimeslicedValue result = new IntegerTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, this.getDataPointCount(), false, ratePerSecond, ratePerSecond, ratePerSecond);
        return result;
    }

    @Override
    protected void doAcceptAggregateTimeslicedValue(IMetricDataValue value) throws IncompatibleTypesException {
        this.addToDataPointCount(value.getDataPointCount());
    }

    public synchronized void addSingleIncident() {
        this.incrementDataPointCountNonSync();
        this.noteDataIsPresent();
    }

    public synchronized void addBatchIncidents(int incidentCount) {
        this.addToDataPointCount(incidentCount);
        this.newDataPointsReceived();
        this.noteDataIsPresent();
    }

    public static IMetricDataValue aggregateByTime(IMetricDataValue pvalue1, IMetricDataValue pvalue2) {
        IntegerTimeslicedValue value1 = (IntegerTimeslicedValue)pvalue1;
        IntegerTimeslicedValue value2 = (IntegerTimeslicedValue)pvalue2;
        if (value1.dataIsAbsent() || value2.dataIsAbsent()) {
            return RateGatherer.absentInt(value1, value2);
        }
        long count = value1.getDataPointCount() + value2.getDataPointCount();
        int min = Math.min(value1.getMinimum(), value2.getMinimum());
        int max = Math.max(value1.getMaximum(), value2.getMaximum());
        long elapsedMS = value2.getStopTimestampInMillis() - value1.getStartTimestampInMillis();
        int value = elapsedMS == 0L ? 0 : (int)(count * 1000L / elapsedMS);
        return new IntegerTimeslicedValue(value1.getType(), value1.getStartTimestampInMillis(), value2.getStopTimestampInMillis(), null, count, false, value, min, max);
    }
}

