/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.threaddump.common;

import com.wily.introscope.threaddump.common.TDAgentException;
import com.wily.introscope.threaddump.common.ThreadDumpError;
import com.wily.introscope.threaddump.common.WilyThreadDump;
import com.wily.introscope.threaddump.common.WilyThreadInfo;
import com.wily.introscope.threaddump.common.WrapperWilyThreaddump;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ThreadDumpHelper {
    protected volatile long Maxsize;
    protected IModuleFeedbackChannel fFeedback;
    private static boolean isDeadlockReadable = true;
    protected ThreadMXBean bean = ManagementFactory.getThreadMXBean();

    public static void setDeadlockReadable(boolean isDeadlockReadable) {
        ThreadDumpHelper.isDeadlockReadable = isDeadlockReadable;
    }

    public ThreadDumpHelper(IModuleFeedbackChannel feedback, long noOfStackElement) {
        this.fFeedback = feedback;
        this.Maxsize = noOfStackElement;
    }

    public ThreadDumpHelper(IModuleFeedbackChannel feedback) {
        this.fFeedback = feedback;
    }

    public ThreadDumpHelper(long noOfStackElement) {
        this.Maxsize = noOfStackElement;
    }

    public static String getThreadState(Thread.State threadState) {
        String state = "UNKNOWN";
        switch (threadState) {
            case BLOCKED: {
                state = "BLOCKED";
                break;
            }
            case NEW: {
                state = "NEW";
                break;
            }
            case RUNNABLE: {
                state = "RUNNABLE";
                break;
            }
            case TERMINATED: {
                state = "TERMINATED";
                break;
            }
            case TIMED_WAITING: {
                state = "TIMED_WAITING";
                break;
            }
            case WAITING: {
                state = "WAITING";
            }
        }
        return state;
    }

    protected long getThreadInfo(Map<Long, WilyThreadInfo> map, long[] ids, boolean isDeadlocked) {
        Thread.currentThread().getId();
        long totalStacksize = 0L;
        if (ids.length == 0) {
            return 0L;
        }
        WilyThreadInfo[] result = new WilyThreadInfo[ids.length];
        ThreadInfo[] realInfo = this.bean.getThreadInfo(ids, Integer.MAX_VALUE);
        int i = 0;
        while (i < realInfo.length) {
            if (realInfo[i] != null) {
                String state = ThreadDumpHelper.getThreadState(realInfo[i].getThreadState());
                result[i] = new WilyThreadInfo(realInfo[i].getThreadId(), realInfo[i].getThreadName(), realInfo[i].getBlockedTime(), realInfo[i].getBlockedCount(), realInfo[i].getWaitedTime(), realInfo[i].getWaitedCount(), realInfo[i].getLockName(), realInfo[i].getLockOwnerName(), realInfo[i].getLockOwnerId(), realInfo[i].isInNative(), realInfo[i].isSuspended(), state, realInfo[i].getStackTrace(), isDeadlocked);
                totalStacksize = (long)result[i].getStackLen() + totalStacksize;
                if (!map.containsKey(ids[i])) {
                    map.put(ids[i], result[i]);
                }
            }
            ++i;
        }
        return totalStacksize;
    }

    public WilyThreadInfo getThreadInfo(long threadId) throws TDAgentException {
        long totalStackSize = 0L;
        HashMap<Long, WilyThreadInfo> threadMap = new HashMap<Long, WilyThreadInfo>(1);
        long[] theadIdArray = new long[]{threadId};
        if (!this.shouldsend(totalStackSize += this.getThreadInfo(threadMap, theadIdArray, false))) {
            throw new TDAgentException(ThreadDumpError.Status.SizeoFTDExceedMax, new Object[]{totalStackSize, this.Maxsize});
        }
        return (WilyThreadInfo)threadMap.get(threadId);
    }

    public WrapperWilyThreaddump getThreadDump(String creationNote, boolean runnableOnly, String agentName) throws TDAgentException {
        WrapperWilyThreaddump cached = null;
        long totalStackSize = 0L;
        if (this.bean.isThreadContentionMonitoringSupported() && !this.bean.isThreadContentionMonitoringEnabled()) {
            this.bean.setThreadContentionMonitoringEnabled(true);
        }
        HashMap<Long, WilyThreadInfo> threadMap = new HashMap<Long, WilyThreadInfo>();
        if (!runnableOnly) {
            long[] deadlockedThreads = null;
            if (isDeadlockReadable) {
                deadlockedThreads = this.bean.findMonitorDeadlockedThreads();
                if (deadlockedThreads == null) {
                    deadlockedThreads = new long[]{};
                }
                totalStackSize += this.getThreadInfo(threadMap, deadlockedThreads, true);
            }
        }
        long[] liveThreads = this.bean.getAllThreadIds();
        if (runnableOnly) {
            liveThreads = this.filterForRunnables(liveThreads);
        }
        if (!this.shouldsend(totalStackSize += this.getThreadInfo(threadMap, liveThreads, false))) {
            throw new TDAgentException(ThreadDumpError.Status.SizeoFTDExceedMax, new Object[]{totalStackSize, this.Maxsize});
        }
        WilyThreadInfo[] threads = threadMap.values().toArray(new WilyThreadInfo[threadMap.size()]);
        cached = new WrapperWilyThreaddump(false, agentName, creationNote, new WilyThreadDump(threads));
        return cached;
    }

    private boolean shouldsend(long stacksize) {
        return stacksize <= this.Maxsize;
    }

    private long[] filterForRunnables(long[] liveThreads) {
        ArrayList<Long> result = new ArrayList<Long>(liveThreads.length);
        ThreadInfo[] realInfo = this.bean.getThreadInfo(liveThreads);
        int i = 0;
        while (i < realInfo.length) {
            if (realInfo[i] != null && (realInfo[i].getThreadState() == Thread.State.RUNNABLE || realInfo[i].getThreadState() == Thread.State.BLOCKED)) {
                result.add(liveThreads[i]);
            }
            ++i;
        }
        long[] longResult = new long[result.size()];
        int i2 = 0;
        while (i2 < longResult.length) {
            longResult[i2] = (Long)result.get(i2);
            ++i2;
        }
        return longResult;
    }

    public int getDeadlockedThreadCount() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] deadlockedThreads = null;
        if (isDeadlockReadable) {
            try {
                deadlockedThreads = bean.findMonitorDeadlockedThreads();
            }
            catch (SecurityException securityException) {
                this.fFeedback.warn("Deadlocks Metric will not be reported as ManagementPermission is not set to Monitor");
                isDeadlockReadable = false;
            }
        }
        if (deadlockedThreads == null) {
            return 0;
        }
        return deadlockedThreads.length;
    }
}

