/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback;

import com.wily.util.ConfigurationWatcher;
import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.ABufferedApplicationFeedbackChannel;
import com.wily.util.feedback.IAsynchFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.feedback.WilyLog4JConfigureAndWatchHelper;
import com.wily.util.feedback.backend.NativeFeedbackBackend;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.resource.IResource;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;

public class AsynchFeedbackChannel
extends ABufferedApplicationFeedbackChannel
implements IAsynchFeedbackChannel {
    private IRegisteredBehavior fAsyncLoggingBehavior;
    private IntervalHeartbeat fAsyncLoggingHeartbeat;
    public static final String kDisableAsyncLoggingKey = "com.wily.introscope.disableAsyncLogging";
    public static final String kDelayLoggingKey = "com.wily.introscope.delayLoggingInMillis";
    private static final int kLoggingIntervalInMillis = 1000;
    private static long floggingClamp = 50000L;
    private static AsyncLoggingBehavior sAsyncLoggingBehavior = null;
    private static boolean sShouldLogAsync = true;
    private IConfigurationListener listener;

    public AsynchFeedbackChannel(String applicationName) {
        super(applicationName);
    }

    public AsynchFeedbackChannel(String applicationName, String defaultOutputTarget) {
        super(applicationName, null, defaultOutputTarget);
        this.fAsyncLoggingBehavior = null;
    }

    @Override
    public final void setConfiguration(ConfigurationWatcher watcher, IResource configurationResource) {
        this.listener = new WilyLog4JConfigureAndWatchHelper(configurationResource);
        watcher.addConfigurationListener(this.listener);
    }

    @Override
    public final void setConfiguration(ConfigurationWatcher watcher, IResource configurationResource, IConfigurationListener listener) {
        watcher.addConfigurationListener(listener);
    }

    public void flush() {
        sAsyncLoggingBehavior.ITimestampedRunnable_execute(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAsyncLoggingToHeartbeat(IntervalHeartbeat heartbeat) {
        Assertion.wilyAssert(false);
        long loggingDelayInMillis = 0L;
        try {
            String delayString = System.getProperty(kDelayLoggingKey);
            if (delayString != null) {
                loggingDelayInMillis = Long.parseLong(delayString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.warn("Invalid numeric value for property com.wily.introscope.delayLoggingInMillis, ignoring");
        }
        catch (Exception e) {
            this.error("setLoggingHeartbeat", e);
        }
        String disableAsyncLoggingStr = null;
        try {
            disableAsyncLoggingStr = System.getProperty(kDisableAsyncLoggingKey);
        }
        catch (RuntimeException re) {
            this.error("setLoggingHeartbeat", re);
        }
        boolean shouldLogAsync = Boolean.valueOf(disableAsyncLoggingStr) == false;
        AsyncLoggingBehavior loggingBehavior = new AsyncLoggingBehavior();
        Object object = this.getFeedbackChannelLock();
        synchronized (object) {
            if (sAsyncLoggingBehavior != null) {
                this.warn("Async Logging Behavior already set.");
                return;
            }
            sShouldLogAsync = shouldLogAsync;
            if (!sShouldLogAsync) {
                this.debug("Async Logging Disabled");
                return;
            }
            sAsyncLoggingBehavior = loggingBehavior;
        }
        this.fAsyncLoggingHeartbeat = heartbeat;
        if (loggingDelayInMillis <= 0L) {
            this.doAddAsyncLoggingToHeartbeat(heartbeat);
            this.setShouldBuffer(false);
        } else {
            SimpleDelayBehavior behavior = new SimpleDelayBehavior(this, heartbeat);
            heartbeat.addBehavior(behavior, "Async Logging Delay", true, loggingDelayInMillis, false, 1);
        }
    }

    private void doAddAsyncLoggingToHeartbeat(IntervalHeartbeat heartbeat) {
        this.fAsyncLoggingBehavior = this.fAsyncLoggingHeartbeat.addBehavior((ITimestampedRunnable)sAsyncLoggingBehavior, "Async Logging", true, 1000L, false);
    }

    public void removeAsyncLoggingFromHeartbeat() {
        try {
            if (this.fAsyncLoggingHeartbeat != null) {
                this.fAsyncLoggingHeartbeat.removeBehavior(this.fAsyncLoggingBehavior);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    @Override
    protected void doLog(SeverityLevel severity, Module module, String message, Throwable t, boolean forceImmediate) {
        if (message == null) {
            message = "\n";
        }
        Object actualLogger = this.getActualLogger(module);
        if (!forceImmediate && sAsyncLoggingBehavior != null && sShouldLogAsync) {
            sAsyncLoggingBehavior.log(actualLogger, severity, message, t);
        } else {
            NativeFeedbackBackend.getNativeFeedbackBackend().log(actualLogger, severity, message, t);
        }
    }

    private static class AsyncLoggingBehavior
    implements ITimestampedRunnable {
        ArrayList fLogs = new ArrayList();
        static int loggingCount = 0;

        static {
            try {
                long asyncLoggingClamp;
                String loggingClamp = System.getProperty("wily.AsyncLoggingClamp");
                if (loggingClamp != null && (asyncLoggingClamp = Long.parseLong(loggingClamp)) > 0L) {
                    floggingClamp = asyncLoggingClamp;
                }
            }
            catch (Exception exception) {}
        }

        private AsyncLoggingBehavior() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            LogInfo[] logs = null;
            ArrayList arrayList = this.fLogs;
            synchronized (arrayList) {
                logs = this.fLogs.toArray(LogInfo.kZeroLengthArray);
                this.fLogs.clear();
                loggingCount = 0;
            }
            if (logs == null) {
                return;
            }
            int i = 0;
            while (i < logs.length) {
                NativeFeedbackBackend.getNativeFeedbackBackend().log(logs[i].getLogger(), logs[i].getSeverity(), logs[i].getMessage(), logs[i].getThrowable());
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void log(Object logger, SeverityLevel severity, String message, Throwable t) {
            Assertion.wilyAssert(false, "null logger in AsyncLoggingBehavior.log");
            LogInfo logInfo = new LogInfo(logger, severity, message, t);
            ArrayList arrayList = this.fLogs;
            synchronized (arrayList) {
                if ((long)loggingCount < floggingClamp) {
                    this.fLogs.add(logInfo);
                    ++loggingCount;
                }
                if ((long)loggingCount == floggingClamp) {
                    SeverityLevel sevLevel = SeverityLevel.getLevelByName("WARN");
                    String clampMessage = "Clamp value of " + floggingClamp + " has been reached. No more logging will occur";
                    Throwable throwable = new Throwable("Clamp limit reached");
                    LogInfo clampLogInfo = new LogInfo(logger, sevLevel, clampMessage, throwable);
                    this.fLogs.add(clampLogInfo);
                    ++loggingCount;
                }
            }
        }
    }

    private static class LogInfo {
        public static final LogInfo[] kZeroLengthArray = new LogInfo[0];
        private Object fLogger;
        private SeverityLevel fSeverity;
        private String fMessage;
        private Throwable fThrowable;

        public LogInfo(Object logger, SeverityLevel severity, String message, Throwable t) {
            this.fLogger = logger;
            this.fSeverity = severity;
            this.fMessage = message;
            this.fThrowable = t;
        }

        public Object getLogger() {
            return this.fLogger;
        }

        public SeverityLevel getSeverity() {
            return this.fSeverity;
        }

        public String getMessage() {
            return this.fMessage;
        }

        public Throwable getThrowable() {
            return this.fThrowable;
        }
    }

    private static class SimpleDelayBehavior
    implements ITimestampedRunnable {
        private IntervalHeartbeat fHeartbeat;
        private AsynchFeedbackChannel fParent;

        public SimpleDelayBehavior(AsynchFeedbackChannel parent, IntervalHeartbeat heartbeat) {
            this.fParent = parent;
            this.fHeartbeat = heartbeat;
        }

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            this.fParent.doAddAsyncLoggingToHeartbeat(this.fHeartbeat);
            this.fParent.setShouldBuffer(false);
        }
    }
}

