/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.ext.agent.threaddump;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.api.DataRecorderFactory;
import com.wily.introscope.agent.api.IllegalMetricNameException;
import com.wily.introscope.agent.api.IntCounterDataRecorder;
import com.wily.introscope.agent.beans.AAgentBean;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.IThreadStackSnapshotHelper;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.ext.agent.threaddump.AgentThreadDumpHelper;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.introscope.thread.management.ThreadTracking;
import com.wily.introscope.threaddump.common.IAgentThreadDumpService;
import com.wily.introscope.threaddump.common.IThreadDumpServiceCommon;
import com.wily.introscope.threaddump.common.TDAgentException;
import com.wily.introscope.threaddump.common.ThreadDumpError;
import com.wily.introscope.threaddump.common.WilyThreadInfo;
import com.wily.introscope.threaddump.common.WilyThreadInfoExtended;
import com.wily.introscope.threaddump.common.WrapperWilyThreaddump;
import com.wily.isengard.IsengardError;
import com.wily.isengard.container.IMessageServiceReference;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.service.ServiceException;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import java.util.Map;
import java.util.regex.Pattern;

public class ThreadDumpBean
extends AAgentBean
implements IAgentThreadDumpService {
    private static final String kThreadMetricPrefix = "Threads|";
    private AgentThreadDumpHelper fThreadDumpHelper;
    private ThreadStackSnapshotHelper fThreadStackSnapshotHelper;
    private ThreadTracking fThreadStats;
    private static long kDeadlockPollerInterval = 15000L;
    private static final int kThreadMetricPollerInterval = 15000;
    private IMessageServiceReference fServiceReference;
    private static final Module sModule = new Module("ThreadDump");
    private static long maxStackelemnt = 0L;
    private static boolean enable = true;
    private static boolean deadLockPollerenable = true;
    private static boolean useLegacyTraceType = true;
    private static String MaxStackElementsKey = "introscope.agent.threaddump.MaxStackElementsClamp";
    private static String threadDumpEnableKey = "introscope.agent.threaddump.enable";
    private static String deadLockEnableKey = "introscope.agent.threaddump.deadlockpoller.enable";
    private static String deadLockPollerKey = "introscope.agent.threaddump.deadlockpollerinterval";
    private static String sendThreadSnapshotOnEventKey = "introscope.agent.threaddump.auto.stacktrace.enable";
    private static String useLegacyThreadSnapshotKey = "introscope.agent.threaddump.auto.stacktrace.legacy";
    private static int kMaxStackElementsDefault = 100000;
    private IAgent fAgent;
    private IRegisteredBehavior pollBehaviour;
    private IRegisteredBehavior collectorSessionBehavior;
    private IConfigurationListener fListener;
    private IModuleFeedbackChannel fFeedback;
    private IStringLocalizer fLocalizer;
    public static final String kThreadDumpGenEnabledMessage = "ThreadDumpGenerator_Settings_Enabled";
    public static final String kThreadDumpGenDisabledMessage = "ThreadDumpGenerator_Settings_Disabled";
    public static final String KMaxStackLimitMessage = "ThreadDumpGenerator_Settings_MaxStackLimit";
    public static final String kDeadlockEnabledMessage = "Deadlockpoller_Settings_Enabled";
    public static final String kDeadlockDisabledMessage = "Deadlockpoller_Settings_Disabled";

    public void activate() throws Exception {
        super.activate();
        this.fAgent = this.getAgent();
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
        this.fLocalizer = this.fAgent.IAgent_getStringLocalizer();
        enable = this.getAgent().IAgent_getIndexedProperties().getBooleanProperty(threadDumpEnableKey, true);
        deadLockPollerenable = this.getAgent().IAgent_getIndexedProperties().getBooleanProperty(deadLockEnableKey, true);
        maxStackelemnt = this.getAgent().IAgent_getIndexedProperties().getLongProperty(MaxStackElementsKey, (long)kMaxStackElementsDefault);
        this.fThreadDumpHelper = new AgentThreadDumpHelper(this.fFeedback, maxStackelemnt);
        if (this.fThreadDumpHelper != null) {
            if (deadLockPollerenable) {
                kDeadlockPollerInterval = this.getAgent().IAgent_getIndexedProperties().getLongProperty(deadLockPollerKey, 15000L);
                this.pollBehaviour = this.getAgent().IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new DeadlockPoller(), "Deadlock Poller", true, kDeadlockPollerInterval, false);
            }
            if (enable) {
                this.fFeedback.info(this.fLocalizer.IStringLocalizer_getLocalizedString(kThreadDumpGenEnabledMessage));
            } else {
                this.fFeedback.info(this.fLocalizer.IStringLocalizer_getLocalizedString(kThreadDumpGenDisabledMessage));
            }
            this.fListener = new ThreadDumpConfigurationListener(this);
            this.fAgent.addConfigurationListener(this.fListener);
            useLegacyTraceType = this.getAgent().IAgent_getIndexedProperties().getBooleanProperty(useLegacyThreadSnapshotKey, true);
            boolean enableThreadSnapshot = this.getAgent().IAgent_getIndexedProperties().getBooleanProperty(sendThreadSnapshotOnEventKey, false);
            if (enableThreadSnapshot) {
                this.fThreadStackSnapshotHelper = new ThreadStackSnapshotHelper();
                ErrorFeature.setThreadStackHelper((IThreadStackSnapshotHelper)this.fThreadStackSnapshotHelper);
            }
        } else {
            this.passivate();
        }
    }

    protected synchronized void createMessageService(String qualifiedAgentName) {
        try {
            if (this.fServiceReference != null) {
                this.getFeedbackChannel().verbose(sModule, "The ThreadDump Extension has already registered its service with the EM");
                return;
            }
            this.getFeedbackChannel().verbose(sModule, "The ThreadDump Extension is attempting to register its service with the EM");
            this.fServiceReference = this.createMessageService2(IAgentThreadDumpService.class, qualifiedAgentName, new String[]{"Server"});
        }
        catch (EntryAlreadyExistsException eae) {
            this.getFeedbackChannel().verbose((Throwable)eae);
        }
        catch (Exception e) {
            this.getFeedbackChannel().warn(sModule, "The ThreadDump Extension failed to register its service with the EM");
            this.getFeedbackChannel().verbose((Throwable)e);
        }
    }

    protected synchronized void destroyMessageService(String qualifiedAgentName) {
        try {
            if (this.fServiceReference != null) {
                this.fServiceReference.unregister();
                this.fServiceReference = null;
            }
        }
        catch (Exception e) {
            this.getFeedbackChannel().debug(sModule, "The ThreadDump Extension failed to unregister its service with the EM");
            this.getFeedbackChannel().verbose((Throwable)e);
        }
    }

    private void generateThreadMetrics() {
        if (this.fThreadStats == null) {
            return;
        }
        this.getAgent().IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new ThreadMetricPoller(), "Thread Metric Poller", true, 15000L, false);
    }

    public void passivate() {
        super.passivate();
    }

    public boolean isThreadDumpSupported() {
        return enable;
    }

    public boolean startThreadStackCollectionSession(String namePattern, String state, long interval, long duration, int minStack, int maxStack, boolean isInstrumented, boolean isNotInstrumented) throws ConnectionException {
        IntervalHeartbeat heartbeat = this.getAgent().IAgent_getCommonHeartbeat();
        if (this.collectorSessionBehavior != null) {
            this.collectorSessionBehavior.close();
            this.collectorSessionBehavior = null;
        }
        this.collectorSessionBehavior = heartbeat.addBehavior((ITimestampedRunnable)new StackSnapShotCollector(namePattern, System.currentTimeMillis() + duration, state, minStack, maxStack, isInstrumented, isNotInstrumented), "Thread Dump Collector", true, interval, false);
        return true;
    }

    public boolean stopThreadStackCollectionSession() throws ConnectionException {
        if (this.collectorSessionBehavior != null) {
            this.collectorSessionBehavior.close();
            this.collectorSessionBehavior = null;
        }
        return true;
    }

    protected IThreadDumpServiceCommon getServerThreadDumpService() throws ConnectionException, ServiceException {
        return (IThreadDumpServiceCommon)this.getMessageService(IThreadDumpServiceCommon.class);
    }

    public WrapperWilyThreaddump getThreadDump(String agentName, String creationInfo) throws TDAgentException {
        if (!enable) {
            throw new TDAgentException(ThreadDumpError.Status.ThreadDumpNotActive, new Object[0]);
        }
        if (this.fThreadDumpHelper == null) {
            ThreadDumpError e = new ThreadDumpError((Throwable)new IsengardError("fThreadDumpHelper == null"));
            return WrapperWilyThreaddump.createAnErrorTD((ThreadDumpError)e);
        }
        WrapperWilyThreaddump td = this.fThreadDumpHelper.getThreadDump(creationInfo, false, agentName);
        return td;
    }

    public WilyThreadInfo getThreadStack(Thread t) {
        WilyThreadInfoExtended info = null;
        if (enable && this.fThreadDumpHelper == null) {
            try {
                info = this.fThreadDumpHelper.getThreadInfo(t.getId());
            }
            catch (TDAgentException e) {
                this.fFeedback.debug(sModule, "getThreadInfo failed.", (Throwable)e);
            }
        }
        return info;
    }

    private class DeadlockPoller
    implements ITimestampedRunnable {
        private IntCounterDataRecorder fDeadlockCountMetric;
        private int fLastDeadlockCount;

        public DeadlockPoller() {
            try {
                this.fDeadlockCountMetric = DataRecorderFactory.createIntCounterDataRecorder((String)"Threads:Deadlock Count");
            }
            catch (IllegalMetricNameException e) {
                ThreadDumpBean.this.getFeedbackChannel().error((Throwable)e);
            }
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            int deadlockCount;
            this.fLastDeadlockCount = deadlockCount = ThreadDumpBean.this.fThreadDumpHelper.getDeadlockedThreadCount();
            this.fDeadlockCountMetric.recordCurrentValue(deadlockCount);
        }
    }

    private class StackSnapShotCollector
    implements ITimestampedRunnable {
        private final Pattern pattern;
        private final long stopTime;
        private final String state;
        private final int minStack;
        private final int maxStack;
        private final boolean isIntrumented;
        private final boolean isNotInstrumented;

        public StackSnapShotCollector(String threadNameRegex, long stopTime, String state, int minStack, int maxStack, boolean isInstrumented, boolean isNotInstrumented) {
            this.stopTime = stopTime;
            this.pattern = Pattern.compile(threadNameRegex);
            this.state = state;
            this.minStack = minStack;
            this.maxStack = maxStack;
            this.isIntrumented = isInstrumented;
            this.isNotInstrumented = isNotInstrumented;
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            if (nowInMillis > this.stopTime || ThreadDumpBean.this.fThreadStackSnapshotHelper == null) {
                ThreadDumpBean.this.collectorSessionBehavior.close();
                ThreadDumpBean.this.collectorSessionBehavior = null;
                return;
            }
            ThreadDumpBean.this.fFeedback.debug(sModule, "Scheduled stack collection. Thread pattern: " + this.pattern.toString());
            Map<Long, WilyThreadInfo> dump = ThreadDumpBean.this.fThreadDumpHelper.getThreadDump(this.pattern, this.state, this.minStack, this.maxStack, this.isIntrumented, this.isNotInstrumented);
            ThreadDumpBean.this.fFeedback.debug(sModule, "Collected " + dump.size() + " snapshots.");
            for (WilyThreadInfo info : dump.values()) {
                ThreadDumpBean.this.fThreadStackSnapshotHelper.sendThreadStackSnapshot((WilyThreadInfoExtended)info, info.getThreadName(), null);
            }
        }
    }

    private static class ThreadDumpConfigurationListener
    implements IConfigurationListener {
        ThreadDumpBean parent;

        public ThreadDumpConfigurationListener(ThreadDumpBean parent) {
            this.parent = parent;
        }

        public void onChange(IndexedProperties props) {
            boolean isenable = props.getBooleanProperty(threadDumpEnableKey, true);
            boolean isDpollerenabled = props.getBooleanProperty(deadLockEnableKey, true);
            if (isenable != enable) {
                enable = isenable;
                if (enable) {
                    this.parent.fFeedback.info(this.parent.fLocalizer.IStringLocalizer_getLocalizedString(ThreadDumpBean.kThreadDumpGenEnabledMessage));
                } else {
                    this.parent.fFeedback.info(this.parent.fLocalizer.IStringLocalizer_getLocalizedString(ThreadDumpBean.kThreadDumpGenDisabledMessage));
                }
            }
            if (isDpollerenabled != deadLockPollerenable) {
                deadLockPollerenable = isDpollerenabled;
                if (deadLockPollerenable) {
                    this.parent.pollBehaviour = this.parent.fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this.parent.new DeadlockPoller(), "Deadlock Poller", true, kDeadlockPollerInterval, false);
                    this.parent.fFeedback.info(this.parent.fLocalizer.IStringLocalizer_getLocalizedString(ThreadDumpBean.kDeadlockEnabledMessage));
                } else {
                    this.parent.fAgent.IAgent_getCommonHeartbeat().removeBehavior(this.parent.pollBehaviour);
                    this.parent.fFeedback.info(this.parent.fLocalizer.IStringLocalizer_getLocalizedString(ThreadDumpBean.kDeadlockDisabledMessage));
                }
            }
        }
    }

    private class ThreadMetricPoller
    implements ITimestampedRunnable {
        private ThreadMetricPoller() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            long time = System.currentTimeMillis();
            try {
                AgentMetricData[] metrics = ThreadDumpBean.this.fThreadStats.harvestThreadMetrics(time, time, ThreadDumpBean.kThreadMetricPrefix);
                int i = 0;
                while (i < metrics.length) {
                    IntCounterDataRecorder recorder = DataRecorderFactory.createIntCounterDataRecorder((String)metrics[i].getAgentMetric().getAttributeURL());
                    recorder.recordCurrentValue((int)metrics[i].getDataValue().getValueAsDouble(0.0));
                    ++i;
                }
            }
            catch (BadlyFormedNameException e) {
                e.printStackTrace();
            }
            catch (IllegalMetricNameException e) {
                e.printStackTrace();
            }
        }
    }

    private class ThreadStackSnapshotHelper
    implements IThreadStackSnapshotHelper {
        private ThreadStackSnapshotHelper() {
        }

        public boolean startThreadDumpSession(String namePattern, String state, long interval, long duration, int minStack, int maxStack, boolean isInstrumented, boolean isNotInstrumented) {
            try {
                return ThreadDumpBean.this.startThreadStackCollectionSession(namePattern, state, interval, duration, minStack, maxStack, isInstrumented, isNotInstrumented);
            }
            catch (ConnectionException connectionException) {
                return false;
            }
        }

        public boolean stopThreadDumpSession() {
            try {
                return ThreadDumpBean.this.stopThreadStackCollectionSession();
            }
            catch (ConnectionException connectionException) {
                return false;
            }
        }

        public void sendThreadStackSnapshot(String component, String event, String message, String corid, String txid, IStackElement data) {
            this.sendThreadStackSnapshot(component, event, message, null, corid, txid, data);
        }

        public void sendThreadStackSnapshot(String component, String event, String message, String corid, String txid, Thread t) {
            this.sendThreadStackSnapshot(event, message, null, corid, txid, t);
        }

        public void sendThreadStackSnapshot(String component, String event, String message, Throwable error, String corid, String txid, IStackElement data) {
            Runnable r = data.getMyThread();
            if (r instanceof Thread) {
                Thread t = (Thread)r;
                this.sendThreadStackSnapshot(component, event, message, error, corid, txid, t);
            }
        }

        public void sendThreadStackSnapshot(String component, String event, String message, Throwable error, String corid, String txid, Thread t) {
            this.sendThreadStackSnapshot(component, event, message, error, null, corid, txid, t);
        }

        public void sendThreadStackSnapshot(String component, String event, String message, Throwable error, StackTraceElement[] stack, String corid, String txid, Thread t) {
            long tid = 0L;
            tid = t.getId();
            try {
                if (stack == null && error != null) {
                    stack = error.getStackTrace();
                }
                WilyThreadInfoExtended info = stack == null ? ThreadDumpBean.this.fThreadDumpHelper.getThreadInfo(tid) : new WilyThreadInfoExtended(t, stack);
                info.setTrxTraceId(txid);
                info.setCorrelationId(corid);
                this.sendThreadStackSnapshot(info, event, message);
            }
            catch (TDAgentException e) {
                ThreadDumpBean.this.fFeedback.error(sModule, "Thread dump error " + e.getMessage());
                ThreadDumpBean.this.fFeedback.debug(sModule, "Caught exception: ", (Throwable)e);
            }
        }

        public void sendThreadStackSnapshot(WilyThreadInfoExtended info, String event, String message) {
            String component = info.getComponent();
            StringBuilder rootname = new StringBuilder();
            String txid = info.getTrxTraceId();
            String corid = info.getCorrelationId();
            if (component != null) {
                rootname.append(component);
                rootname.append(" ");
            }
            rootname.append(event);
            rootname.append(" Thread Snapshot (");
            rootname.append(info.getStackLen());
            rootname.append(" frames)");
            long timestamp = info.getTimestamp();
            if (timestamp == 0L) {
                timestamp = System.currentTimeMillis();
                info.setTimestamp(timestamp);
            }
            TransactionComponentData tcdata = TransactionComponentData.createMilliSecTransactionComponentData((String)rootname.toString(), (long)timestamp, (long)0L);
            if (!useLegacyTraceType) {
                tcdata.setParameterValue("Trace Type", "X");
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String jsonString = gson.toJson(info);
                tcdata.setParameterValue("Thread Info", jsonString);
                if (ThreadDumpBean.this.fFeedback.isTraceEnabled(sModule)) {
                    ThreadDumpBean.this.fFeedback.trace(sModule, jsonString);
                }
            } else {
                tcdata.setParameterValue("Trace Type", "ErrorSnapshot");
                StackTraceElement[] stacktrace = info.getStackTrace();
                StringBuilder sb = new StringBuilder();
                StackTraceElement[] stackTraceElementArray = stacktrace;
                int n = stacktrace.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement e = stackTraceElementArray[n2];
                    sb.append(e.toString());
                    sb.append("<br>");
                    sb.append("\n");
                    ++n2;
                }
                tcdata.setParameterValue("Thread Name", info.getThreadName());
                tcdata.setParameterValue("Thread Id", Long.toString(info.getThreadID()));
                tcdata.setParameterValue("Thread Stack", sb.toString());
                tcdata.setParameterValue("Thread Stack Length", Integer.toString(info.getStackLen()));
                tcdata.setParameterValue("Thread State", info.getThreadState());
            }
            if (txid != null) {
                tcdata.setParameterValue("TxnTraceId", txid);
                info.setTrxTraceId(txid);
            }
            if (corid != null) {
                tcdata.setParameterValue("CorGUID", corid);
            }
            ThreadDumpBean.this.fAgent.IAgent_queueEvent(tcdata);
        }
    }
}

