/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.introscope.agent.intelligent.detection.rules.AbstractFailFastRule;
import com.wily.introscope.agent.intelligent.detection.rules.CommonUtils;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;

public class SkipTopNPercentRule
extends AbstractFailFastRule {
    private final float percentageValue;
    private final float percentageFactor;

    public SkipTopNPercentRule(float percentage) {
        this.percentageValue = percentage;
        this.percentageFactor = percentage / 100.0f;
    }

    @Override
    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        IndexAwareTraceElement traceElement = trace[currentElementIndex];
        int index = traceElement.getIndex();
        int size = traceElement.getSizeOfMyStackTrace();
        int cutoff = Math.round(this.percentageFactor * (float)size);
        return index < 0 || index >= cutoff;
    }

    @Override
    public String toString() {
        return CommonUtils.formatStringRep(String.valueOf(this.getClass().getSimpleName()) + ", percentage:" + this.percentageValue);
    }

    public float getPercentageValue() {
        return this.percentageValue;
    }
}

