/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.cas.ITransactionCache;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TransactionCollectStatus {
    public SharedCrossProcessData cache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
    public Map<String, Object> filterParameters = new HashMap<String, Object>();
    public boolean stopTracingFlag;
    public boolean stopCheckingFlag;
    public boolean doTraceFlag;
    private String traceCollectionReason = null;
    public int headComponentCount;
    private ISamplingResult sampled = ISamplingResult.NO;
    private boolean isSamplingEvaluated;
    public boolean startedTrackingOnStartTransaction;
    public boolean fTriggerHeadFilterPass;
    private Map.Entry<ITransactionTraceFilter, Long>[] pendingFilters = null;
    private Object[] pendingFilterStatus = null;
    private static final Map.Entry<ITransactionTraceFilter, Long>[] kEmptyEntryArray = new Map.Entry[0];
    private int pendingFilterCount = 0;
    private ITransactionTraceFilter[] pendingTailFilters = null;
    private int pendingTailFilterCount = 0;
    ITransactionCache transactionCache = null;
    public int fComponentCountInTT;
    public boolean fComponentClampAlreadyHitForTT;
    public int fComponentClampAfterCount;
    public boolean isTrivialAsynchFragment = false;

    public boolean getStopTracingFlag() {
        return this.stopTracingFlag;
    }

    public boolean getStopCheckingFlag() {
        return this.stopCheckingFlag;
    }

    public boolean getStartedTrackingOnStartTransaction() {
        return this.startedTrackingOnStartTransaction;
    }

    public boolean getDoTraceFlag() {
        return this.doTraceFlag;
    }

    public void setDoTraceFlag(boolean doTraceFlag) {
        this.doTraceFlag = doTraceFlag;
    }

    public String getTraceCollectionReason() {
        return this.traceCollectionReason;
    }

    public void setTraceCollectionReason(String reason) {
        this.traceCollectionReason = reason;
    }

    public int getHeadComponentCount() {
        return this.headComponentCount;
    }

    public void incrementHeadComponentCount() {
        ++this.headComponentCount;
    }

    public void setStopTracingFlag(boolean state) {
        this.stopTracingFlag = state;
    }

    public void setStopCheckingFlag(boolean state) {
        this.stopCheckingFlag = state;
    }

    public void setStartedTrakingOnStartTransaction() {
        this.startedTrackingOnStartTransaction = true;
    }

    public Map<String, Object> getFilterParameters() {
        return this.filterParameters;
    }

    public void setSampled(ISamplingResult sampled) {
        if (sampled == null) {
            sampled = ISamplingResult.NO;
        }
        this.sampled = sampled;
    }

    public ISamplingResult getSampled() {
        return this.sampled;
    }

    public boolean isSamplingEvaluated() {
        return this.isSamplingEvaluated;
    }

    public void setSamplingEvaluated(boolean flag) {
        this.isSamplingEvaluated = flag;
    }

    public Map<String, Object> getParameters(IStackElement data) {
        Map<String, Object> parameters = this.getFilterParameters();
        Map<String, Object> newParameters = data.getParameterCallbacks(parameters);
        if (newParameters != parameters) {
            this.filterParameters = newParameters;
        }
        return newParameters;
    }

    public void addFilterForTailCheck(ITransactionTraceFilter filter) {
        this.pendingTailFilters[this.pendingTailFilterCount++] = filter;
    }

    public void addFilterForTailCheckIfMissing(ITransactionTraceFilter filter) {
        int i = 0;
        while (i < this.pendingTailFilterCount) {
            if (this.pendingTailFilters[i] == filter) {
                return;
            }
            ++i;
        }
        this.pendingTailFilters[this.pendingTailFilterCount++] = filter;
    }

    public ITransactionTraceFilter[] getFiltersForTailCheck() {
        return this.pendingTailFilters;
    }

    public boolean anyPendingTailFilters() {
        return this.pendingTailFilterCount != 0;
    }

    public void addPendingFilters(Collection filterEntries) {
        this.pendingFilterCount = filterEntries.size();
        if (this.pendingFilterCount == 0) {
            return;
        }
        Object[] oldPendingFilterArray = null;
        Object[] oldPendingFilterStatusArray = null;
        Object[] oldTailFilterArray = null;
        if (this.transactionCache != null) {
            oldPendingFilterArray = this.transactionCache.getPendingFilterArray();
            oldPendingFilterStatusArray = this.transactionCache.getPendingFilterStatusArray();
            oldTailFilterArray = this.transactionCache.getfTailFilterArray();
        }
        if (oldPendingFilterArray != null) {
            Arrays.fill(oldPendingFilterArray, null);
            this.pendingFilters = (Map.Entry[])filterEntries.toArray(oldPendingFilterArray);
        } else {
            this.pendingFilters = filterEntries.toArray(kEmptyEntryArray);
        }
        this.pendingFilterStatus = oldPendingFilterStatusArray != null && oldPendingFilterStatusArray.length == this.pendingFilterCount ? oldPendingFilterStatusArray : new Object[this.pendingFilterCount];
        if (this.pendingFilters != oldPendingFilterArray || this.pendingFilterStatus != oldPendingFilterStatusArray) {
            this.transactionCache.setPendingFilterArray(this.pendingFilters, this.pendingFilterStatus);
        }
        if (oldTailFilterArray == null || oldTailFilterArray.length < this.pendingFilterCount) {
            this.pendingTailFilters = new ITransactionTraceFilter[this.pendingFilterCount];
            this.transactionCache.setfTailFilterArray(this.pendingTailFilters);
        } else {
            Arrays.fill(oldTailFilterArray, null);
            this.pendingTailFilters = oldTailFilterArray;
        }
        this.pendingTailFilterCount = 0;
    }

    public Map.Entry<ITransactionTraceFilter, Long>[] getPendingFilters() {
        return this.pendingFilters;
    }

    public Object[] getPendingFilterStatus() {
        return this.pendingFilterStatus;
    }

    public void clearPendingFilters() {
        this.pendingFilterCount = 0;
        this.pendingFilters = null;
        this.pendingFilterStatus = null;
    }

    public boolean anyPendingHeadFilters() {
        return this.pendingFilterCount != 0;
    }

    public void removePendingHeadFilter(int index) {
        --this.pendingFilterCount;
        this.pendingFilters[index] = null;
    }

    public void removePendingTailFilter(int index) {
        --this.pendingTailFilterCount;
        this.pendingTailFilters[index] = null;
    }

    public int incrementAndGetTxnTraceComponentCount() {
        return ++this.fComponentCountInTT;
    }

    public int getTxnTraceComponentCount() {
        return this.fComponentCountInTT;
    }

    public void decrementTxnTraceComponentCount() {
        if (this.fComponentCountInTT > 0) {
            --this.fComponentCountInTT;
        }
    }

    public void markComponentClampAlreadyHitForTxn() {
        this.fComponentClampAlreadyHitForTT = true;
    }

    public boolean isComponentClampAlreadyHitForTxn() {
        return this.fComponentClampAlreadyHitForTT;
    }

    public void incrementComponentClampAfterCount() {
        ++this.fComponentClampAfterCount;
    }

    public int getComponentClampAfterCount() {
        return this.fComponentClampAfterCount;
    }

    public void setTransactionCache(ITransactionCache cache) {
        this.transactionCache = cache;
    }

    public HashSet<Object> getErrorsSeenInThisTxn() {
        return this.transactionCache.getErrorsSeenInThisTxn();
    }
}

