/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.jms.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.hc2.MethodThrewErrorReportingTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class JMSListenerErrorTracer
extends MethodThrewErrorReportingTracer {
    private static final Module moduleName = new Module("JMSListenerErrorTracer");
    protected final IModuleFeedbackChannel feedback;

    public JMSListenerErrorTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        Object message = data.getInvocationParameterAsObject(0);
        if (message == null) {
            return;
        }
        super.ITracer_startTrace(tracerIndex, data);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Object message = data.getInvocationParameterAsObject(0);
        if (message == null) {
            return;
        }
        if (!JMSHelper.isMessageRedeliverySet(message, this.feedback, data)) {
            super.ITracer_finishTrace(tracerIndex, data);
        } else {
            JMSHelper.debug(moduleName, "Failed to run JMSListenerErrorTracer.ITracer_finishTrace because the MessageRedelivery property was found in the message object");
        }
    }
}

