/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.instrumentation.util;

import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.introscope.probebuilder.intelligent.instrumentation.FilePersistenceService;
import com.wily.introscope.probebuilder.intelligent.instrumentation.util.MethodInfo;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.IModeledMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class ClassMethodInfo {
    public String className;
    public Class clazz;
    public HashMap<String, MethodInfo> methodsWithGap = new HashMap();

    public ClassMethodInfo(String className) {
        this.className = className;
    }

    public ClassMethodInfo(String className, String methodName, String methodDescriptor, FilePersistenceService.TracingType type) {
        this.className = className;
        MethodInfo methodInfo = new MethodInfo(methodName, methodDescriptor, type);
        this.put(methodName, methodDescriptor, methodInfo);
    }

    private String createKey(String method, String desc) {
        return String.valueOf(method) + desc;
    }

    private MethodInfo put(String method, String desc, MethodInfo methodInfo) {
        return this.methodsWithGap.put(this.createKey(method, desc), methodInfo);
    }

    public MethodInfo getMethodInfo(String methodSignature) {
        return this.methodsWithGap.get(methodSignature);
    }

    public MethodInfo getMethodInfo(String method, String desc) {
        return desc != null ? this.getMethodInfo(this.createKey(method, desc)) : this.getMethodInfo(method);
    }

    public MethodInfo getMethodInfo(IModeledMethod iModeledMethod) {
        IMethodName methodName = iModeledMethod.getMethodName();
        IMethodSignature sign = methodName.getSignature();
        return this.getMethodInfo(methodName.getNameString(), sign == null ? "" : sign.toString());
    }

    public MethodInfo getMethodInfoWithSameName(IModeledMethod iModeledMethod) {
        MethodInfo methodInfo = this.getMethodInfo(iModeledMethod);
        if (methodInfo != null) {
            return methodInfo;
        }
        IMethodName methodName = iModeledMethod.getMethodName();
        String searchKey = methodName.getNameString();
        return this.getMethodInfo(searchKey);
    }

    public Collection<MethodInfo> getMethods() {
        return this.methodsWithGap.values();
    }

    public boolean contains(String method, String desc) {
        return this.getMethodInfo(method, desc) != null;
    }

    public boolean contains(String methodDesc) {
        return this.getMethodInfo(methodDesc) != null;
    }

    public boolean contains(DGMethod dgMethod) {
        return this.getMethodInfo((IModeledMethod)dgMethod) != null;
    }

    public boolean containsMethodWithSameName(IModeledMethod iModeledMethod) {
        return this.getMethodInfoWithSameName(iModeledMethod) != null;
    }

    public Collection<FilePersistenceService.TracingType> getTracingType(String methodDesc) {
        MethodInfo mg = this.methodsWithGap.get(methodDesc);
        if (mg != null) {
            return mg.getTracingTypes();
        }
        return null;
    }

    public void removeMethod(DGMethod dgMethod) {
        IMethodName methodName = dgMethod.getMethodName();
        String searchKey = methodName.getNameAndSignatureString();
        this.methodsWithGap.remove(searchKey);
    }

    public MethodInfo removeMethod(String method, String desc) {
        return this.methodsWithGap.remove(this.createKey(method, desc));
    }

    public MethodInfo addMethod(String method, String desc) {
        MethodInfo mg = new MethodInfo(method, desc);
        return this.put(method, desc, mg);
    }

    public MethodInfo addMethod(MethodInfo methodInfo) {
        return this.addMethod(methodInfo.getMethodName(), methodInfo.getMethodDesciptor(), methodInfo.getTracingTypes());
    }

    public MethodInfo addMethod(String method, String desc, Collection<FilePersistenceService.TracingType> types) {
        MethodInfo existingMethodInfo = this.getMethodInfo(method, desc);
        if (existingMethodInfo != null) {
            existingMethodInfo.addTraceTypes(types);
            return existingMethodInfo;
        }
        return this.put(method, desc, new MethodInfo(method, desc, types));
    }

    public MethodInfo addMethod(String method, String desc, FilePersistenceService.TracingType type) {
        MethodInfo existingMethodInfo = this.getMethodInfo(method, desc);
        if (existingMethodInfo != null) {
            existingMethodInfo.addTraceType(type);
            return existingMethodInfo;
        }
        return this.put(method, desc, new MethodInfo(method, desc, type));
    }

    public void setMethodsToInstrument(ArrayList<IModeledMethod> methodsToInstrument) {
        HashMap<String, MethodInfo> newMethodsMap = new HashMap<String, MethodInfo>();
        for (IModeledMethod iModeledMethod : methodsToInstrument) {
            MethodInfo existingMethodInfo = this.getMethodInfoWithSameName(iModeledMethod);
            if (existingMethodInfo == null) continue;
            String name = iModeledMethod.getMethodName().getNameString();
            IMethodSignature sign = iModeledMethod.getMethodName().getSignature();
            String desc = sign == null ? "" : sign.toString();
            MethodInfo newMethodInfo = new MethodInfo(name, desc, existingMethodInfo.getTracingTypes());
            newMethodsMap.put(this.createKey(name, desc), newMethodInfo);
        }
        this.methodsWithGap = newMethodsMap;
    }

    public boolean equals(Object info) {
        if (this == info) {
            return true;
        }
        if (!(info instanceof ClassMethodInfo)) {
            return false;
        }
        ClassMethodInfo classInfo = (ClassMethodInfo)info;
        return this.className.equals(classInfo.className) && this.methodsWithGap.equals(classInfo.methodsWithGap);
    }

    public int hashCode() {
        int h = this.className.hashCode();
        return h += this.methodsWithGap.hashCode();
    }

    public String toString() {
        return String.format("[className: %s,  methods: %s]", this.className, this.methodsWithGap);
    }
}

