/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IFactoryLevelParameterCallback;
import com.wily.introscope.agent.blame.ThreadLocals;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.filter.FilterController;
import com.wily.introscope.agent.filter.sampling.ISampler;
import com.wily.introscope.agent.filter.sampling.SamplingInput;
import com.wily.introscope.agent.filter.sampling.SamplingResult;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionInstance;
import com.wily.introscope.agent.trace.cas.ITransactionInstanceListProvider;
import com.wily.introscope.agent.trace.hc2.SocketTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.intelligent.AutoTracingHelper;
import com.wily.introscope.agent.trace.intelligent.CrossProcessAutoTracingConfiguration;
import com.wily.introscope.agent.trace.intelligent.DeepTraceConfigurations;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceTransactionCache;
import com.wily.introscope.agent.trace.intelligent.ITcdMap;
import com.wily.introscope.agent.trace.intelligent.IntelligentTransactionHarvesterHelper;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.transactiontrace.ISamplingInput;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.agent.transactiontrace.TransactionTraceController;
import com.wily.introscope.spec.server.beans.event.IEventDataNode;
import com.wily.introscope.spec.server.transactiontrace.SequenceId;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.IConfigurationListener;
import com.wily.util.adt.ConcurrentHighPerformanceLRUHashMap;
import com.wily.util.adt.ICappedMap;
import com.wily.util.adt.ObjectInternLRUCache;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.thread.IThreadFactory;
import com.wily.wilyassert.Assertion;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class TransactionHarvestHelper {
    public static final int kTempChildrenDefaultSize = 4;
    private static IAgent sAgent;
    public static boolean fIntelligentInstrumentationEnabled;
    public static final String kIntelligentInstrumentationEnablingProperty = "introscope.agent.deep.instrumentation.enabled";
    public static final boolean kIntelligentInstrumentationEnablingPropertyDefaultValue = true;
    public static final String kLanguageDefaultValue = "java";
    public static volatile String fLanguage;
    private static int sAsyncSimpleFragmentTcdClamp;
    private static volatile boolean initialized;
    private static final int kMaxNumberTcdElementsFromNormalTracer = -1;

    static {
        fLanguage = kLanguageDefaultValue;
        sAsyncSimpleFragmentTcdClamp = 12;
        initialized = false;
        try {
            sAgent = AgentShim.getAgent();
            fIntelligentInstrumentationEnabled = sAgent.IAgent_getIndexedProperties().getBooleanProperty(kIntelligentInstrumentationEnablingProperty, true);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public static void init() {
        if (!initialized && fIntelligentInstrumentationEnabled) {
            sAgent.addConfigurationListener(new IConfigurationListener(){

                @Override
                public void onChange(IndexedProperties newProps) {
                    sAsyncSimpleFragmentTcdClamp = newProps.getIntProperty("introscope.agent.transactiontracer.sampling.async.fragment.desperate.clamp", 12);
                }
            });
            IThreadFactory factory = sAgent.IAgent_getAgentThreadFactory();
            if (factory != null) {
                Thread t = factory.IThreadFactory_createNewThread("Agent Deep Stack Release Processor", HarvestCallbackForFragments.sDeepStackReleaser);
                t.start();
            }
            initialized = true;
        }
    }

    public static void doHarvest(ITransactionInstanceListProvider structure, IStackElement stckElement) {
        boolean synchronous;
        boolean currentTxnMarkedForCollection;
        TransactionCollectStatus tcs = stckElement.getTransactionCollectionStatus();
        IModuleFeedbackChannel feedback = sAgent.IAgent_getModuleFeedback();
        if (tcs == null) {
            feedback.warn("TransactionHarvestHelper.doHarvest fails with null tcs. need to configure a tracer that creates tcs");
            return;
        }
        ISamplingResult samplingResult = tcs.getSampled();
        ISamplingResult.Answer sampleAnswer = samplingResult.shouldStartSampling();
        List<ITransactionInstance> trace0 = stckElement.getTransactionInstanceList();
        if (trace0.isEmpty()) {
            samplingResult.determineSampling(ISamplingInput.INVALID, ISamplingResult.Callback.NO_OP_CALLBACK);
            return;
        }
        if (FilterController.isTraceSupressed(trace0, tcs)) {
            samplingResult.determineSampling(ISamplingInput.INVALID, ISamplingResult.Callback.NO_OP_CALLBACK);
            return;
        }
        ITransactionInstance tFirstEnd = trace0.get(trace0.size() - 1);
        if (!structure.validateTransaction(tFirstEnd)) {
            samplingResult.determineSampling(ISamplingInput.INVALID, ISamplingResult.Callback.NO_OP_CALLBACK);
            return;
        }
        ISamplingInput samplingInput = SamplingInput.wrap(stckElement);
        if (TransactionTraceController.getHasBeenClamped()) {
            switch (sampleAnswer.choice) {
                case YES: {
                    samplingResult.determineSampling(samplingInput, ISamplingResult.Callback.NO_OP_CALLBACK);
                    TransactionHarvestHelper.doHarvestSynchronously(stckElement, true, 0);
                    return;
                }
                case LEAD_IS_NOT_READY: 
                case MAYBE: {
                    TransactionHarvestHelper.doHarvestAsynchronously(stckElement, samplingInput);
                    return;
                }
                case NO: {
                    samplingResult.determineSampling(samplingInput, ISamplingResult.Callback.NO_OP_CALLBACK);
                    if (fIntelligentInstrumentationEnabled && DeepTraceConfigurations.fDeepTracingEnabled) {
                        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.cleanupOnWhenTraceIsClamped();
                    }
                    return;
                }
            }
        }
        if (fIntelligentInstrumentationEnabled && DeepTraceConfigurations.fDeepTracingEnabled && TransactionHarvestHelper.processAutoTracing(stckElement)) {
            samplingResult.determineSampling(samplingInput, ISamplingResult.Callback.NO_OP_CALLBACK);
            return;
        }
        switch (sampleAnswer.choice) {
            case YES: {
                currentTxnMarkedForCollection = true;
                synchronous = true;
                break;
            }
            case MAYBE: {
                currentTxnMarkedForCollection = false;
                synchronous = false;
                break;
            }
            default: {
                currentTxnMarkedForCollection = false;
                synchronous = true;
            }
        }
        boolean bl = currentTxnMarkedForCollection = currentTxnMarkedForCollection || synchronous && FilterController.canCurrentTransactionBeMarkedForCollection(stckElement);
        if (!currentTxnMarkedForCollection) {
            Map<String, Object> filterParams = tcs.getFilterParameters();
            filterParams.put("introscope.transactiontrace.threshold.key", tFirstEnd.getDuration());
            if (tcs.getErrorsSeenInThisTxn().size() > 0) {
                filterParams.put("introscope.transactiontrace.errorfilter.key", tcs.getErrorsSeenInThisTxn());
            }
            currentTxnMarkedForCollection = FilterController.finalFiltersExecute(tcs) || FilterController.pessimisticFiltersExecute(tcs);
            currentTxnMarkedForCollection = currentTxnMarkedForCollection || tcs.anyPendingTailFilters();
        }
        boolean bl2 = synchronous = synchronous || currentTxnMarkedForCollection;
        if (synchronous) {
            samplingResult.determineSampling(samplingInput, ISamplingResult.Callback.NO_OP_CALLBACK);
            TransactionHarvestHelper.doHarvestSynchronously(stckElement, currentTxnMarkedForCollection, 0);
        } else {
            TransactionHarvestHelper.doHarvestAsynchronously(stckElement, samplingInput);
        }
    }

    private static void doHarvestAsynchronously(IStackElement stckElement, ISamplingInput samplingInput) {
        ISamplingResult.Callback callback;
        TransactionCollectStatus tcs = stckElement.getTransactionCollectionStatus();
        ISamplingResult samplingResult = tcs.getSampled();
        IModuleFeedbackChannel feedback = sAgent.IAgent_getModuleFeedback();
        if (!fIntelligentInstrumentationEnabled || !DeepTraceConfigurations.fDeepTracingEnabled) {
            if (feedback.isWarningEnabled(ISampler.kSamplingModule)) {
                feedback.warn(ISampler.kSamplingModule, "Either Intelligent Instrumentation or Deep Tracing are disabled, however one of selected sampling strategy requires them. Trace is discarded");
            }
            samplingResult.determineSampling(samplingInput, ISamplingResult.Callback.NO_OP_CALLBACK);
            return;
        }
        if (samplingResult.isDerivative()) {
            String downstreamTransactionID;
            boolean downstreamTransaction;
            boolean bl = downstreamTransaction = CrossProcessAutoTracingConfiguration.isCrossProcessAutoTracingEnabled() && IntelligentTransactionHarvesterHelper.isDownStreamAgentForTx(stckElement);
            if (downstreamTransaction) {
                HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
                downstreamTransactionID = deepStack.getTransactionGUIDInThread();
            } else {
                downstreamTransactionID = null;
            }
            callback = downstreamTransactionID != null ? new HarvestCallbackForDownstreamFragments(stckElement, downstreamTransactionID) : new HarvestCallbackForUpstreamFragments(stckElement);
        } else {
            callback = new HarvestCallbackWithFullBackup(stckElement);
        }
        samplingResult.determineSampling(samplingInput, callback);
    }

    private static void doHarvestSynchronously(IStackElement stckElement, boolean currentTxnMarkedForCollection, int maxNumberTcdFromNormalTracer) {
        if (fIntelligentInstrumentationEnabled && DeepTraceConfigurations.fDeepTracingEnabled) {
            if (currentTxnMarkedForCollection) {
                HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
                IntelligentTransactionHarvesterHelper.harvestTransaction(stckElement, deepStack, false, maxNumberTcdFromNormalTracer);
            } else {
                TransactionHarvestHelper.submitTransactionToCache(stckElement);
            }
            return;
        }
        if (!currentTxnMarkedForCollection) {
            return;
        }
        TransactionCollectStatus tcs = stckElement.getTransactionCollectionStatus();
        List<ITransactionInstance> trace = stckElement.getTransactionInstanceList();
        TransactionComponentData root = null;
        Stack<TransactionComponentData> traversingStack = new Stack<TransactionComponentData>();
        HashSet<SocketTransactionElement> socketTxnElementsWhichHaveMaskingBackends = new HashSet<SocketTransactionElement>();
        ArrayList<SocketRedundancyCheckPostProcessingTask> socketRedundancyCheckPostProcessingTasks = new ArrayList<SocketRedundancyCheckPostProcessingTask>();
        int position = trace.size() - 1;
        while (position >= 0) {
            ITransactionInstance tend = trace.get(position);
            if (tend == null) {
                return;
            }
            ITransactionElement te = tend.getTransactionElement();
            if (te == null) {
                return;
            }
            if (te instanceof BlameTransactionElement) {
                BlameTransactionElement last = (BlameTransactionElement)te;
                if (!last.isStartTrace()) {
                    TransactionComponentData bizDefComponent;
                    ITransactionInstance tStart = tend.getStartInstance();
                    if (tStart == null) {
                        return;
                    }
                    long startTrace = tStart.getData().getWallClockStartTime();
                    long duration = tend.getDuration();
                    if (duration < 0L) {
                        Assertion.wilyAssert(duration >= 0L, "The duration should be bigger than zero");
                        duration = 0L;
                    }
                    TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(last.getResourceName(), startTrace, duration);
                    BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-tt-starttime", startTrace);
                    if (traversingStack.isEmpty()) {
                        root = component;
                    } else {
                        TransactionComponentData peekedItem = (TransactionComponentData)traversingStack.peek();
                        peekedItem.addSubNode(component);
                    }
                    Map<String, String> parameters = component.getParameters();
                    IStackElement dataElement = tend.getData();
                    if (dataElement != null) {
                        ProbeInformation fInfo;
                        if (last instanceof WilyTransactionElement && dataElement instanceof InvocationData && (fInfo = ((InvocationData)dataElement).getProbeInformation()) != null) {
                            ProbeIdentification probeIdentification = fInfo.getProbeIdentification();
                            parameters.put("Method", probeIdentification.getProbeMethodName());
                            parameters.put("Method Descriptor", probeIdentification.getProbeMethodDescriptor());
                            parameters.put("Class", probeIdentification.getRuntimeFullClassName());
                            String lineInfo = probeIdentification.getSourceFileLine();
                            if (lineInfo != null) {
                                parameters.put("Source Line", lineInfo);
                            }
                            parameters.put("Resource Name", component.getResource());
                            IFactoryLevelParameterCallback[] staticCallbacks = fInfo.getCallbacks();
                            int i = 0;
                            while (i < staticCallbacks.length) {
                                if (staticCallbacks[i] != null) {
                                    staticCallbacks[i].IFactoryLevelParameterCallback_addParameters(parameters);
                                }
                                ++i;
                            }
                        }
                        VirtualStack.addParameterCallbacks(parameters, dataElement);
                        dataElement.addParameterCallbacks(parameters);
                        String error = (String)dataElement.get("Exception");
                        String errMsg = (String)dataElement.get("Error Message");
                        if (error != null) {
                            parameters.put("Exception", error);
                        }
                        if (errMsg != null) {
                            parameters.put("Error Message", errMsg);
                        }
                        if (last.isBackend()) {
                            TransactionHarvestHelper.includeSocketParams(parameters, dataElement, socketTxnElementsWhichHaveMaskingBackends, null);
                        } else if (dataElement.getAppMapSocketCursors() != null) {
                            socketRedundancyCheckPostProcessingTasks.add(new SocketRedundancyCheckPostProcessingTask(dataElement, parameters));
                        }
                    }
                    if (root == component && !component.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(component)) != null) {
                        root = bizDefComponent;
                        traversingStack.push(bizDefComponent);
                    }
                    traversingStack.push(component);
                } else if (!traversingStack.isEmpty()) {
                    traversingStack.pop();
                }
            }
            --position;
        }
        TransactionHarvestHelper.includeRootParams(root.getParameters(), stckElement);
        TransactionHarvestHelper.removeRedundantSocketDecorationByPostProcessing(socketTxnElementsWhichHaveMaskingBackends, socketRedundancyCheckPostProcessingTasks);
        ISamplingResult.Answer samplingAnswer = tcs.getSampled().shouldStartSampling();
        if (samplingAnswer.choice == ISamplingResult.Choice.YES) {
            root.setParameterValue("Trace Type", "Sampled");
            if (samplingAnswer.byWho != null) {
                root.setParameterValue("Trace Reason", samplingAnswer.byWho);
            }
        } else {
            root.setParameterValue("Trace Type", "Normal");
        }
        if (tcs.isComponentClampAlreadyHitForTxn()) {
            root.setParameterValue("Components Not Shown", Integer.toString(tcs.getComponentClampAfterCount()));
        }
        if (tcs.getTraceCollectionReason() != null) {
            root.setParameterValue("Trace Reason", tcs.getTraceCollectionReason());
        }
        sAgent.IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(root);
    }

    public static void removeRedundantSocketDecorationByPostProcessing(HashSet<SocketTransactionElement> socketTransactionElementsMaskedByBackends, ArrayList<SocketRedundancyCheckPostProcessingTask> socketRedundancyCheckPostProcessingTasks) {
        for (SocketRedundancyCheckPostProcessingTask task : socketRedundancyCheckPostProcessingTasks) {
            TransactionHarvestHelper.includeSocketParams(task.parameters, task.data, null, socketTransactionElementsMaskedByBackends);
        }
    }

    private static boolean processAutoTracing(IStackElement stckElement) {
        if (!fIntelligentInstrumentationEnabled || !DeepTraceConfigurations.fDeepTracingEnabled) {
            return false;
        }
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
        if (!AutoTracingHelper.checkForAutoTracingWithClamp()) {
            return false;
        }
        stckElement.getTransactionCollectionStatus().setSampled(ISamplingResult.NO);
        boolean result = IntelligentTransactionHarvesterHelper.harvestTransaction(stckElement, deepStack, true, 0);
        if (result) {
            SustainabilityMetricsHelper.reportAutoTracingSustainibilityMetricsSent(1);
        }
        return result;
    }

    public static void submitTransactionToCache(IStackElement stckElement) {
        if (!fIntelligentInstrumentationEnabled || !DeepTraceConfigurations.fDeepTracingEnabled) {
            return;
        }
        IntelligentTransactionHarvesterHelper.submitTransactionToCache(stckElement);
    }

    private static IEventDataNode findFrontendNode(IEventDataNode root) {
        LinkedList<IEventDataNode> queue = new LinkedList<IEventDataNode>();
        queue.offer(root);
        int level = 0;
        queue.offer(null);
        while (!queue.isEmpty()) {
            IEventDataNode node = (IEventDataNode)queue.poll();
            if (node.getParameterValue("Business Definition") != null) {
                return node;
            }
            int i = 0;
            while (i < node.getSubNodeCount()) {
                queue.offer(node.getSubNode(i));
                ++i;
            }
            if (queue.peek() != null) continue;
            if (level >= 15) {
                return null;
            }
            queue.poll();
            if (queue.isEmpty()) continue;
            ++level;
            queue.offer(null);
        }
        return null;
    }

    public static TransactionComponentData buildBusinessTransactionComponent(TransactionComponentData component) {
        String EBTFeature;
        IEventDataNode frontendComponent = component;
        String bizDefStr = frontendComponent.getParameterValue("Business Definition");
        if (bizDefStr == null && (frontendComponent = TransactionHarvestHelper.findFrontendNode(component)) != null) {
            bizDefStr = frontendComponent.getParameterValue("Business Definition");
        }
        if (bizDefStr == null) {
            return null;
        }
        String isDownstreamBt = frontendComponent.getParameterValue("Passthrough External BT");
        if (isDownstreamBt != null) {
            return null;
        }
        TransactionComponentData bizDefComponent = TransactionComponentData.createMilliSecTransactionComponentData(bizDefStr, component.getStartTimeInMillisecs(), component.getDurationInMillisecs());
        Map<String, String> bizDefParameters = bizDefComponent.getParameters();
        Map<String, String> params = frontendComponent.getParameters();
        bizDefParameters.put("Business Definition", bizDefStr);
        params.remove("Business Definition");
        bizDefParameters.put("Language", fLanguage);
        String experienceSource = frontendComponent.getParameterValue("ATTR_ExperienceSource");
        if (experienceSource != null) {
            bizDefParameters.put("ATTR_ExperienceSource", experienceSource);
            params.remove("ATTR_ExperienceSource");
        }
        String ttParamName = frontendComponent.getParameterValue("EUM Business Transaction");
        String corGuid = frontendComponent.getParameterValue("CorGUID");
        String url = frontendComponent.getParameterValue("URL");
        String traceId = frontendComponent.getParameterValue("TxnTraceId");
        String corId = frontendComponent.getParameterValue("CorCrossProcessData");
        String traceType = frontendComponent.getParameterValue("Trace Type");
        String appName = frontendComponent.getParameterValue("Application Name");
        if (ttParamName != null) {
            bizDefParameters.put("EUM Business Transaction", ttParamName);
            params.remove("EUM Business Transaction");
        }
        if (corGuid != null) {
            bizDefParameters.put("CorGUID", corGuid);
            params.remove("CorGUID");
        }
        if (url != null) {
            bizDefParameters.put("URL", url);
        }
        if (traceId != null) {
            bizDefParameters.put("TxnTraceId", traceId);
        }
        if (traceType != null) {
            bizDefParameters.put("Trace Type", traceType);
            params.remove("Trace Type");
        }
        if (appName != null) {
            bizDefParameters.put("Application Name", appName);
        }
        if (corId != null) {
            bizDefParameters.put("CorCrossProcessData", corId);
        }
        String error = frontendComponent.getParameterValue("Error Message");
        String exception = frontendComponent.getParameterValue("Exception");
        if (error != null) {
            bizDefParameters.put("Error Message", error);
        }
        if (exception != null) {
            bizDefParameters.put("Exception", exception);
        }
        String userId = component.getParameterValue("User ID");
        if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
            sAgent.IAgent_getModuleFeedback().trace("BS/BT User Id Problem: UserId got is: " + userId);
        }
        if (userId != null) {
            bizDefParameters.put("User ID", userId);
        }
        if ((EBTFeature = sAgent.IAgent_getConfigurationManager().getProperty("introscope.agent.external.biz.enabled")) != null && "true".equalsIgnoreCase(EBTFeature)) {
            String appname;
            String tenant;
            String sdk;
            String connection;
            String os;
            String device;
            String location;
            String carrier = component.getParameterValue("x-apm-bt.Carrier");
            if (carrier != null) {
                bizDefParameters.put("x-apm-bt.Carrier", carrier);
                params.remove("x-apm-bt.Carrier");
            }
            if ((location = component.getParameterValue("x-apm-bt.Location")) != null) {
                bizDefParameters.put("x-apm-bt.Location", location);
                params.remove("x-apm-bt.Location");
            }
            if ((device = component.getParameterValue("x-apm-bt.Device")) != null) {
                bizDefParameters.put("x-apm-bt.Device", device);
                params.remove("x-apm-bt.Device");
            }
            if ((os = component.getParameterValue("x-apm-bt.OS Version")) != null) {
                bizDefParameters.put("x-apm-bt.OS Version", os);
                params.remove("x-apm-bt.OS Version");
            }
            if ((connection = component.getParameterValue("x-apm-bt.Connection")) != null) {
                bizDefParameters.put("x-apm-bt.Connection", connection);
                params.remove("x-apm-bt.Connection");
            }
            if ((sdk = component.getParameterValue("x-apm-bt.Identifier Version")) != null) {
                bizDefParameters.put("x-apm-bt.Identifier Version", sdk);
                params.remove("x-apm-bt.Identifier Version");
            }
            if ((tenant = component.getParameterValue("x-apm-bt.Tenant")) != null) {
                bizDefParameters.put("x-apm-bt.Tenant", tenant);
                params.remove("x-apm-bt.Tenant");
            }
            if ((appname = component.getParameterValue("x-apm-bt.Application Name")) != null) {
                bizDefParameters.put("x-apm-bt.Application Name", appname);
                params.remove("x-apm-bt.Application Name");
            }
        }
        bizDefComponent.addSubNode(component);
        return bizDefComponent;
    }

    private static void includeCorParams(Map<String, String> parameters) {
        String openTracingDownStream;
        String seqid;
        SharedCrossProcessData cache = sAgent.IAgent_getComponentTracer().getCrossProcessDataCache();
        if (cache == null) {
            return;
        }
        String corid = cache.getCorrelationID();
        if (corid == null) {
            return;
        }
        parameters.put("CorCrossProcessData", corid);
        SequenceId id = cache.getSeqID();
        if (id != null && (seqid = id.getSequenceId()) != null) {
            parameters.put("SeqNoCrossProcessData", seqid);
        }
        String txnTraceId = cache.getStringParamIn("TxnTraceId");
        if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
            sAgent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack my Caller GUID " + txnTraceId);
        }
        if (txnTraceId != null) {
            parameters.put("CallerTxnTraceId", txnTraceId);
        }
        String callerTxnTime = cache.getStringParamIn("CallerTimestamp");
        if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
            sAgent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack my Caller's timestamp " + callerTxnTime);
        }
        if (callerTxnTime != null) {
            parameters.put("CallerTimestamp", callerTxnTime);
        }
        String nonBlockTxn = cache.getStringParamIn("NBThreadTxn");
        if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
            sAgent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack current Txn Non Blocking = " + nonBlockTxn);
        }
        if (nonBlockTxn != null) {
            parameters.put("NBThreadTxn", nonBlockTxn);
        }
        String callerComponentID = cache.getStringParamIn("Caller Component ID");
        if (sAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
            sAgent.IAgent_getModuleFeedback().trace("TransactionRecordingBlameStack current caller component ID = " + callerComponentID);
        }
        if (callerComponentID != null) {
            parameters.put("Caller Component ID", callerComponentID);
        }
        if ((openTracingDownStream = cache.getStringParamIn("isOpenTracingDownstreamTrace")) != null) {
            parameters.put("isOpenTracingDownstreamTrace", openTracingDownStream);
        }
    }

    public static void includeRootParams(Map<String, String> parameters, IStackElement data) {
        String threadGroupName;
        String threadName;
        parameters.put("Trace Type", "Normal");
        Runnable thread = null;
        if (data != null) {
            thread = data.getMyThread();
        }
        if (thread == null) {
            thread = Thread.currentThread();
        }
        if (thread instanceof Thread) {
            Thread t = (Thread)thread;
            threadName = InvocationData.limitSize(t.getName());
            ThreadGroup threadGroup = t.getThreadGroup();
            threadGroupName = threadGroup != null ? InvocationData.limitSize(threadGroup.getName()) : null;
        } else {
            threadName = thread.toString();
            threadGroupName = "NA";
        }
        if (threadName != null) {
            parameters.put("Thread Name", threadName);
        }
        if (threadGroupName != null) {
            parameters.put("Thread Group Name", threadGroupName);
        }
        parameters.put("Language", fLanguage);
        TransactionHarvestHelper.includeCorParams(parameters);
    }

    static String formatSocketConnectionString(String localAddress, String remoteAddress, int port) {
        StringBuilder sb = new StringBuilder();
        if (localAddress.contains(":")) {
            sb.append("[");
            sb.append(localAddress);
            sb.append("]");
        } else {
            sb.append(localAddress);
        }
        sb.append("->");
        if (remoteAddress.contains(":")) {
            sb.append("[");
            sb.append(remoteAddress);
            sb.append("]");
        } else {
            sb.append(remoteAddress);
        }
        sb.append(":");
        sb.append(port);
        return sb.toString();
    }

    public static void includeSocketParams(Map<String, String> parameters, IStackElement data) {
        TransactionHarvestHelper.includeSocketParams(parameters, data, null, null);
    }

    public static void includeSocketParams(Map<String, String> parameters, IStackElement data, HashSet<SocketTransactionElement> elements, HashSet<SocketTransactionElement> filterElements) {
        Iterator i;
        if (data != null && (i = data.getAppMapSocketCursors()) != null) {
            int index = 1;
            while (i.hasNext()) {
                SocketTransactionElement element = (SocketTransactionElement)i.next();
                if (elements != null) {
                    elements.add(element);
                }
                if (filterElements != null && filterElements.contains(element)) continue;
                int currentIndex = index++;
                TransactionHarvestHelper.includeSocketParams(currentIndex, element, parameters);
            }
        }
    }

    public static void includeSocketParams(int socketIndex, SocketTransactionElement element, Map<String, String> parameters) {
        if (element.hasMetrics()) {
            parameters.put("Socket" + socketIndex, element.getSocketDescription());
        }
        String remoteServerHost = element.getHostName();
        String remoteServerAddress = element.getHostAddress();
        String localServerAddress = element.getLocalAddress();
        int port = element.getPort();
        if (remoteServerHost != null) {
            parameters.put("Remote Server Name" + socketIndex, remoteServerHost);
        }
        if (remoteServerAddress != null) {
            parameters.put("Remote Server Address" + socketIndex, remoteServerAddress);
        }
        if (port > 0) {
            parameters.put("Remote Port" + socketIndex, Integer.toString(port));
        }
        if (localServerAddress != null) {
            parameters.put("Local Address" + socketIndex, localServerAddress);
        }
    }

    private static final class HarvestCallbackForDownstreamFragments
    extends HarvestCallbackForFragments
    implements HighPerformanceTransactionCache.IDeepStackProvider {
        private final String downstreamTransactionGuid;

        HarvestCallbackForDownstreamFragments(IStackElement stckElement, String downstreamTransactionGuid) {
            super(stckElement);
            this.downstreamTransactionGuid = downstreamTransactionGuid;
        }

        @Override
        public String getTransactionGuid() {
            return this.downstreamTransactionGuid;
        }

        @Override
        public synchronized HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack prepareDeepStackForHarvest() {
            HighPerformanceTransactionCache cache = HighPerformanceTransactionCache.getInstance();
            cache.deregisterTransientProvider(this);
            if (this.invalid) {
                return null;
            }
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = this.retainedDeepStack;
            this.invalidate();
            return deepStack;
        }

        @Override
        void onSynchronousMaybe() {
            super.onSynchronousMaybe();
            HighPerformanceTransactionCache cache = HighPerformanceTransactionCache.getInstance();
            cache.registerTransientProvider(this);
        }

        @Override
        void submitToCache(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack) {
            TransactionHarvestHelper.submitTransactionToCache(this.stckElement);
        }

        @Override
        boolean removeFromCache(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack) {
            return false;
        }

        @Override
        void release(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack) {
            HighPerformanceTransactionCache cache = HighPerformanceTransactionCache.getInstance();
            cache.deregisterTransientProvider(this);
        }
    }

    static abstract class HarvestCallbackForFragments
    implements ISamplingResult.Callback,
    HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.OnSentCallback {
        IStackElement stckElement;
        boolean invalid;
        TransactionComponentData rootTcd;
        WeakReference<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack> deepStackWeakRef;
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack retainedDeepStack;
        static final BlockingQueue<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack> sAvailableDeepStacks = new ArrayBlockingQueue<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack>(64);
        static final BlockingQueue<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack> sReleasedDeepStacks = new ArrayBlockingQueue<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack>(64);
        static final Runnable sDeepStackReleaser = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack;
                            if ((stack = sReleasedDeepStacks.poll(60L, TimeUnit.SECONDS)) == null) {
                                continue;
                            }
                            stack.reinit();
                            sAvailableDeepStacks.offer(stack);
                        }
                    }
                    catch (Exception e) {
                        sAgent.IAgent_getModuleFeedback().error("Deep Stack Releae Failure. Exception: " + e.getMessage());
                        continue;
                    }
                    break;
                }
            }
        };
        static final ObjectInternLRUCache<String> sStringInternCache = new ObjectInternLRUCache(32, 8192);
        private static final ObjectInternLRUCache<Map<String, String>> sParamsInternCache = new ObjectInternLRUCache(16, 2048);
        private static final String X_INTERNED = "xxx-interned";
        private static final String[] NO_CACHE = new String[]{"Thread Name", "Thread Group Name", "TxnTraceId", "CallerTxnTraceId", "FrontendTxnTraceId", "CorCrossProcessData"};

        HarvestCallbackForFragments(IStackElement stckElement) {
            this.stckElement = stckElement;
        }

        @Override
        public synchronized void onSamplingDetermined(ISamplingResult.Answer answer) {
            if (this.invalid) {
                return;
            }
            switch (answer.choice) {
                case LEAD_IS_NOT_READY: {
                    this.onLeadIsNotReady();
                    return;
                }
                case MAYBE: {
                    this.onMaybe();
                    return;
                }
                case YES: {
                    this.onYes(answer);
                    return;
                }
                case NO: {
                    this.onNo();
                    return;
                }
            }
        }

        void onLeadIsNotReady() {
            if (this.deepStackWeakRef != null) {
                return;
            }
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = this.harvestTcdFromNormalTracer();
            if (deepStack == null) {
                return;
            }
            this.deepStackWeakRef = new WeakReference<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack>(deepStack);
            deepStack.addOnTraceSentCallback(this);
            this.submitToCache(deepStack);
            this.stckElement = null;
        }

        @Override
        public synchronized void onStackSentToEM(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, boolean sent) {
            if (this.deepStackWeakRef != null) {
                this.deepStackWeakRef.clear();
            }
            if (this.invalid) {
                return;
            }
            if (sent) {
                this.invalidate();
                return;
            }
            ITcdMap normalTcdMap = deepStack.sIntelligentThreadLocalObject.fTopTCDElements;
            if (normalTcdMap == null) {
                this.invalidate();
                return;
            }
            this.rootTcd = IntelligentTransactionHarvesterHelper.harvestFromHpTracerIntoTcds(deepStack, normalTcdMap, sAsyncSimpleFragmentTcdClamp, sStringInternCache, null);
            if (this.rootTcd == null) {
                this.invalidate();
                return;
            }
            if (deepStack.getStackElementCount() > sAsyncSimpleFragmentTcdClamp) {
                this.rootTcd.setParameterValue("Trace Clamp Reason", "Too many pending fragments");
            }
            HarvestCallbackForFragments.internParams(this.rootTcd);
        }

        final void invalidate() {
            this.invalid = true;
            this.stckElement = null;
            this.retainedDeepStack = null;
            this.rootTcd = null;
            if (this.deepStackWeakRef != null) {
                this.deepStackWeakRef.clear();
            }
        }

        private static final void internParamsForSingleTcd(TransactionComponentData tcd) {
            Map<String, String> params = tcd.getParameters();
            String[] stringArray = NO_CACHE;
            int n = NO_CACHE.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                if (params.containsKey(param)) {
                    return;
                }
                ++n2;
            }
            params.put(X_INTERNED, X_INTERNED);
            tcd.setParameters(sParamsInternCache.intern(params));
        }

        private static final void internParams(TransactionComponentData root) {
            ArrayList<TransactionComponentData> stack = new ArrayList<TransactionComponentData>(sAsyncSimpleFragmentTcdClamp);
            stack.add(root);
            while (!stack.isEmpty()) {
                TransactionComponentData tcd = (TransactionComponentData)stack.remove(stack.size() - 1);
                HarvestCallbackForFragments.internParamsForSingleTcd(tcd);
                int i = tcd.getSubNodeCount() - 1;
                while (i >= 0) {
                    stack.add((TransactionComponentData)tcd.getSubNode(i));
                    --i;
                }
            }
        }

        private static final void deinternParamsForSingleTcd(TransactionComponentData tcd) {
            Map<String, String> params = tcd.getParameters();
            if (!params.containsKey(X_INTERNED)) {
                return;
            }
            HashMap<String, String> copy = new HashMap<String, String>(params);
            copy.remove(X_INTERNED);
            tcd.setParameters(copy);
        }

        private static final void deinternParams(TransactionComponentData root) {
            ArrayList<TransactionComponentData> stack = new ArrayList<TransactionComponentData>(sAsyncSimpleFragmentTcdClamp);
            stack.add(root);
            while (!stack.isEmpty()) {
                TransactionComponentData tcd = (TransactionComponentData)stack.remove(stack.size() - 1);
                HarvestCallbackForFragments.deinternParamsForSingleTcd(tcd);
                int i = tcd.getSubNodeCount() - 1;
                while (i >= 0) {
                    stack.add((TransactionComponentData)tcd.getSubNode(i));
                    --i;
                }
            }
        }

        void onMaybe() {
            if (this.rootTcd != null) {
                return;
            }
            if (this.retainedDeepStack != null) {
                return;
            }
            if (this.deepStackWeakRef == null) {
                this.onSynchronousMaybe();
                return;
            }
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack)this.deepStackWeakRef.get();
            if (deepStack == null) {
                return;
            }
            if (!this.removeFromCache(deepStack)) {
                return;
            }
            deepStack.removeOnTraceSentCallback(this);
            this.retainedDeepStack = deepStack;
        }

        void onSynchronousMaybe() {
            this.retainedDeepStack = this.harvestTcdFromNormalTracer();
            if (this.retainedDeepStack == null) {
                return;
            }
            this.stckElement = null;
            this.deepStackWeakRef = new WeakReference<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack>(this.retainedDeepStack);
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack replacement = (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack)sAvailableDeepStacks.poll();
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.replaceStack(replacement);
        }

        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack getSavedDeepStack() {
            if (this.retainedDeepStack != null) {
                return this.retainedDeepStack;
            }
            if (this.deepStackWeakRef == null) {
                return null;
            }
            return (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack)this.deepStackWeakRef.get();
        }

        void onNo() {
            this.stckElement = null;
            this.invalid = true;
            if (this.deepStackWeakRef == null) {
                return;
            }
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = this.getSavedDeepStack();
            if (deepStack != null) {
                deepStack.removeOnTraceSentCallback(this);
                this.release(deepStack);
            }
            this.deepStackWeakRef.clear();
            this.retainedDeepStack = null;
        }

        void onYes(final ISamplingResult.Answer answer) {
            if (this.stckElement != null) {
                TransactionCollectStatus tcs = this.stckElement.getTransactionCollectionStatus();
                tcs.setSampled(SamplingResult.YES(answer.byWho));
                TransactionHarvestHelper.doHarvestSynchronously(this.stckElement, true, -1);
                this.stckElement = null;
                return;
            }
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = this.getSavedDeepStack();
            if (deepStack != null) {
                deepStack.removeOnTraceSentCallback(this);
            }
            IAgent agent = HighPerformanceIntelligenceStackElement.getAgent();
            if (this.rootTcd != null) {
                HarvestCallbackForFragments.deinternParams(this.rootTcd);
                this.decorateRoot(this.rootTcd, answer);
                agent.IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(this.rootTcd);
                this.invalidate();
                return;
            }
            if (deepStack == null) {
                IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
                feedback.warn(SamplingResult.kSamplingModule, "Cannot locate deepStack for harvested transaction, will ignore it");
                return;
            }
            IntelligentTransactionHarvesterHelper.harvestFromHpTracerWithNormalTcdMap(deepStack, deepStack.sIntelligentThreadLocalObject.fTopTCDElements, new IntelligentTransactionHarvesterHelper.TCDPreSendCallback(){

                @Override
                public TransactionComponentData beforeSending(TransactionComponentData root) {
                    HarvestCallbackForFragments.this.decorateRoot(root, answer);
                    return root;
                }
            });
            this.release(deepStack);
            this.retainedDeepStack = null;
            if (this.deepStackWeakRef != null) {
                this.deepStackWeakRef.clear();
            }
        }

        void decorateRoot(TransactionComponentData root, ISamplingResult.Answer answer) {
            root.setParameterValue("Trace Type", "Sampled");
            if (answer.byWho != null) {
                root.setParameterValue("Trace Reason", answer.byWho);
            }
            root.setParameterValue("Instrumentation Level", IntelligentTransactionHarvesterHelper.getInstrumentationLevelChangeStatusManager().getCurrentStatus());
        }

        private HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack harvestTcdFromNormalTracer() {
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            deepStack.prepareOnStartHarvestTransaction();
            ITcdMap tcdMap = IntelligentTransactionHarvesterHelper.harvestTcdFromNormalTracer(this.stckElement, deepStack, sStringInternCache, 1);
            if (tcdMap == null) {
                deepStack.tearMeDown();
                this.invalidate();
                return null;
            }
            deepStack.sIntelligentThreadLocalObject.fTopTCDElements = tcdMap;
            return deepStack;
        }

        abstract void submitToCache(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack var1);

        abstract boolean removeFromCache(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack var1);

        abstract void release(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack var1);
    }

    private static final class HarvestCallbackForUpstreamFragments
    extends HarvestCallbackForFragments {
        private static final ConcurrentHighPerformanceLRUHashMap<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack, Boolean> sCachedLeafNotReadyFragments = new ConcurrentHighPerformanceLRUHashMap(8, 64);

        static {
            sCachedLeafNotReadyFragments.setCallback(new ICappedMap.IOnEntryRemovedListener<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack, Boolean>(){

                @Override
                public void onEntryRemoved(Map.Entry<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack, Boolean> entry) {
                    HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack removed = entry.getKey();
                    sReleasedDeepStacks.offer(removed);
                }
            });
        }

        HarvestCallbackForUpstreamFragments(IStackElement stckElement) {
            super(stckElement);
        }

        @Override
        void submitToCache(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack) {
            sCachedLeafNotReadyFragments.put(deepStack, Boolean.TRUE);
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack replacement = (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack)sAvailableDeepStacks.poll();
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.replaceStack(replacement);
        }

        @Override
        boolean removeFromCache(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack) {
            sCachedLeafNotReadyFragments.remove(deepStack);
            return true;
        }

        @Override
        void release(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack) {
            this.removeFromCache(deepStack);
            deepStack.reinit();
            sAvailableDeepStacks.offer(deepStack);
        }
    }

    private static final class HarvestCallbackWithDeepStackBackup
    implements ISamplingResult.Callback,
    HighPerformanceTransactionCache.IDeepStackProvider {
        private IStackElement stckElement;
        private HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack;
        private String downstreamTransactionGuid;
        private boolean invalid;
        private static final BlockingQueue<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack> sBuffer = new ArrayBlockingQueue<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack>(25);

        HarvestCallbackWithDeepStackBackup(IStackElement stckElement) {
            this.stckElement = stckElement;
        }

        @Override
        public synchronized void onSamplingDetermined(ISamplingResult.Answer answer) {
            if (this.invalid) {
                return;
            }
            switch (answer.choice) {
                case LEAD_IS_NOT_READY: 
                case MAYBE: {
                    this.onMaybe();
                    return;
                }
                case YES: {
                    this.onYes(answer);
                    return;
                }
                case NO: {
                    this.onNo();
                    return;
                }
            }
        }

        private void onMaybe() {
            if (this.deepStack != null) {
                return;
            }
            this.deepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            this.deepStack.prepareOnStartHarvestTransaction();
            this.deepStack.processCrossProcessBeforeTearDown();
            if (CrossProcessAutoTracingConfiguration.isCrossProcessAutoTracingEnabled() && IntelligentTransactionHarvesterHelper.isDownStreamAgentForTx(this.stckElement)) {
                this.downstreamTransactionGuid = this.deepStack.getTransactionGUID();
            }
            ITcdMap normalTcdHash = IntelligentTransactionHarvesterHelper.harvestTcdFromNormalTracer(this.stckElement, this.deepStack, null, 1);
            this.stckElement = null;
            if (normalTcdHash == null) {
                this.invalid = true;
                this.deepStack = null;
                return;
            }
            this.deepStack.sIntelligentThreadLocalObject.fTopTCDElements = normalTcdHash;
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack replacement = (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack)sBuffer.poll();
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.replaceStack(replacement);
            if (this.downstreamTransactionGuid != null) {
                HighPerformanceTransactionCache cache = HighPerformanceTransactionCache.getInstance();
                cache.registerTransientProvider(this);
            }
        }

        private void onNo() {
            if (this.deepStack == null) {
                TransactionHarvestHelper.submitTransactionToCache(this.stckElement);
                this.stckElement = null;
                return;
            }
            if (this.downstreamTransactionGuid == null) {
                this.stckElement = null;
                this.deepStack.reinit();
                sBuffer.offer(this.deepStack);
                this.deepStack = null;
                return;
            }
            HighPerformanceTransactionCache cache = HighPerformanceTransactionCache.getInstance();
            if (this.deepStack.wasSentToEM()) {
                cache.deregisterTransientProvider(this);
                this.stckElement = null;
                this.deepStack = null;
                return;
            }
            cache.checkin(this.downstreamTransactionGuid, this.deepStack);
            cache.deregisterTransientProvider(this);
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack replacement = cache.checkout(true);
            sBuffer.offer(replacement);
        }

        private void onYes(final ISamplingResult.Answer answer) {
            if (this.deepStack == null) {
                TransactionCollectStatus tcs = this.stckElement.getTransactionCollectionStatus();
                tcs.setSampled(SamplingResult.YES(answer.byWho));
                TransactionHarvestHelper.doHarvestSynchronously(this.stckElement, true, -1);
                this.stckElement = null;
                return;
            }
            if (this.downstreamTransactionGuid != null) {
                HighPerformanceTransactionCache cache = HighPerformanceTransactionCache.getInstance();
                cache.deregisterTransientProvider(this);
                cache.addUpstreamGUID(this.downstreamTransactionGuid);
            }
            IntelligentTransactionHarvesterHelper.harvestFromHpTracerWithNormalTcdMap(this.deepStack, this.deepStack.sIntelligentThreadLocalObject.fTopTCDElements, new IntelligentTransactionHarvesterHelper.TCDPreSendCallback(){

                @Override
                public TransactionComponentData beforeSending(TransactionComponentData root) {
                    root.setParameterValue("Trace Type", "Sampled");
                    if (answer.byWho != null) {
                        root.setParameterValue("Trace Reason", answer.byWho);
                    }
                    root.setParameterValue("Instrumentation Level", IntelligentTransactionHarvesterHelper.getInstrumentationLevelChangeStatusManager().getCurrentStatus());
                    return root;
                }
            });
            this.deepStack.reinit();
            sBuffer.offer(this.deepStack);
            this.deepStack = null;
        }

        @Override
        public String getTransactionGuid() {
            return this.downstreamTransactionGuid;
        }

        @Override
        public HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack prepareDeepStackForHarvest() {
            HighPerformanceTransactionCache cache = HighPerformanceTransactionCache.getInstance();
            cache.deregisterTransientProvider(this);
            if (this.invalid || this.deepStack == null) {
                return null;
            }
            return this.deepStack;
        }
    }

    private static final class HarvestCallbackWithFullBackup
    implements ISamplingResult.Callback,
    HighPerformanceTransactionCache.IDeepStackProvider,
    IInvocationDataParameterCallback {
        private IStackElement stckElement;
        private ThreadLocals.Backup threadLocalsBackup;
        private Map<String, String> savedRootParameters;
        private String downstreamTransactionGuid;
        private boolean invalid;

        HarvestCallbackWithFullBackup(IStackElement stckElement) {
            this.stckElement = stckElement;
        }

        private void release() {
            this.stckElement = null;
            this.threadLocalsBackup = null;
            this.savedRootParameters = null;
            this.invalid = true;
        }

        @Override
        public synchronized void onSamplingDetermined(ISamplingResult.Answer answer) {
            if (this.invalid) {
                return;
            }
            switch (answer.choice) {
                case LEAD_IS_NOT_READY: 
                case MAYBE: {
                    this.onMaybe();
                    return;
                }
                case YES: {
                    this.onYes(answer);
                    return;
                }
                case NO: {
                    this.onNo();
                    return;
                }
            }
        }

        private void onMaybe() {
            if (this.threadLocalsBackup != null) {
                return;
            }
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            deepStack.processCrossProcessBeforeTearDown();
            if (CrossProcessAutoTracingConfiguration.isCrossProcessAutoTracingEnabled() && IntelligentTransactionHarvesterHelper.isDownStreamAgentForTx(this.stckElement)) {
                this.downstreamTransactionGuid = deepStack.getTransactionGUID();
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            VirtualStack.addParameterCallbacks(parameters, this.stckElement);
            this.stckElement.addParameterCallbacks(parameters);
            if (!parameters.isEmpty()) {
                this.savedRootParameters = parameters;
                this.stckElement.setParameterCallback(this);
            }
            this.threadLocalsBackup = ThreadLocals.saveAside();
            if (this.downstreamTransactionGuid != null) {
                HighPerformanceTransactionCache cache = HighPerformanceTransactionCache.getInstance();
                cache.registerTransientProvider(this);
            }
        }

        @Override
        public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
            if (this.savedRootParameters == null) {
                return;
            }
            parameters.putAll(this.savedRootParameters);
        }

        private void onYes(final ISamplingResult.Answer answer) {
            if (this.threadLocalsBackup == null) {
                this.finishProcessingYes(answer);
                return;
            }
            if (this.downstreamTransactionGuid != null) {
                HighPerformanceTransactionCache cache = HighPerformanceTransactionCache.getInstance();
                cache.deregisterTransientProvider(this);
                cache.addUpstreamGUID(this.downstreamTransactionGuid);
            }
            this.threadLocalsBackup.finishProcessing(new Runnable(){

                @Override
                public void run() {
                    HarvestCallbackWithFullBackup.this.finishProcessingYes(answer);
                }
            });
        }

        private void finishProcessingYes(ISamplingResult.Answer answer) {
            TransactionCollectStatus tcs = this.stckElement.getTransactionCollectionStatus();
            tcs.setSampled(SamplingResult.YES(answer.byWho));
            TransactionHarvestHelper.doHarvestSynchronously(this.stckElement, true, -1);
            this.release();
        }

        private void onNo() {
            if (this.threadLocalsBackup == null) {
                TransactionHarvestHelper.submitTransactionToCache(this.stckElement);
                this.release();
                return;
            }
            if (this.downstreamTransactionGuid == null) {
                this.release();
                return;
            }
            this.threadLocalsBackup.finishProcessing(new Runnable(){

                @Override
                public void run() {
                    HighPerformanceTransactionCache cache = HighPerformanceTransactionCache.getInstance();
                    HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
                    if (deepStack.wasSentToEM()) {
                        cache.deregisterTransientProvider(HarvestCallbackWithFullBackup.this);
                        HarvestCallbackWithFullBackup.this.release();
                        return;
                    }
                    TransactionHarvestHelper.submitTransactionToCache(HarvestCallbackWithFullBackup.this.stckElement);
                    cache.deregisterTransientProvider(HarvestCallbackWithFullBackup.this);
                    HarvestCallbackWithFullBackup.this.release();
                }
            });
        }

        @Override
        public String getTransactionGuid() {
            return this.downstreamTransactionGuid;
        }

        @Override
        public synchronized HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack prepareDeepStackForHarvest() {
            HighPerformanceTransactionCache cache = HighPerformanceTransactionCache.getInstance();
            cache.deregisterTransientProvider(this);
            if (this.invalid || this.threadLocalsBackup == null) {
                return null;
            }
            final HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] ret = new HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[1];
            this.threadLocalsBackup.finishProcessing(new Runnable(){

                @Override
                public void run() {
                    ITcdMap normalTcdMap;
                    HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
                    deepStack.sIntelligentThreadLocalObject.fTopTCDElements = normalTcdMap = IntelligentTransactionHarvesterHelper.harvestTcdFromNormalTracer(HarvestCallbackWithFullBackup.this.stckElement, deepStack, null, -1);
                    ret[0] = deepStack;
                }
            });
            this.release();
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = ret[0];
            if (deepStack.sIntelligentThreadLocalObject.fTopTCDElements == null) {
                HighPerformanceIntelligenceStackElement.getAgent().IAgent_getModuleFeedback().warn("Transaction trace is corruped, will not harvest it");
                return null;
            }
            return deepStack;
        }
    }

    public static class SocketRedundancyCheckPostProcessingTask {
        final IStackElement data;
        final Map<String, String> parameters;

        public SocketRedundancyCheckPostProcessingTask(IStackElement data, Map<String, String> parameters) {
            this.data = data;
            this.parameters = parameters;
        }
    }
}

