/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.http;

import com.wily.isengard.api.ServerInstanceLocator;
import com.wily.isengard.util.io.FullDuplexPipe;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.properties.IndexedProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.net.ssl.SSLContext;

public final class HttpTransportAdapter {
    private final FullDuplexPipe fPipe;
    private final String fRemoteHostName;
    private final int fRemotePort;
    private int fSocketSendBufferSize;
    private int fSocketReceiveBufferSize;
    private IndexedProperties fSocketProperties;
    private SSLContext fSSLContext;
    private boolean fValidateHostname;
    private String[] fCipherSuites;
    private String[] fProtocols;
    private boolean fTryIPAddress;

    public HttpTransportAdapter(String hostName, int port) throws IOException {
        CheckParameter.notNull("Host Name", hostName);
        this.checkPortRange(port);
        this.fRemoteHostName = hostName;
        this.fPipe = new FullDuplexPipe();
        this.fRemotePort = port;
        this.setSocketSendBufferSize(32768);
        this.setSocketReceiveBufferSize(32768);
    }

    public HttpTransportAdapter(ServerInstanceLocator locator) throws IOException {
        this(locator.getHostName(), locator.getPort());
        this.setSocketSendBufferSize(locator.getSocketSendBufferSize());
        this.setSocketReceiveBufferSize(locator.getSocketReceiveBufferSize());
        this.setSocketProperties(locator.getSocketCreationProperties());
        this.fSSLContext = locator.getSSLContext();
        this.fValidateHostname = locator.shouldValidateHostname();
        this.fCipherSuites = locator.getCipherSuites();
        this.fProtocols = locator.getProtocols();
        this.fTryIPAddress = locator.getTryIPAddressFlag();
    }

    public IndexedProperties getSocketProperties() {
        if (this.fSocketProperties == null) {
            return new IndexedProperties();
        }
        return this.getDefensiveCopy(this.fSocketProperties);
    }

    public void setSocketProperties(IndexedProperties properties) {
        if (properties == null) {
            throw new NullPointerException("Socket properties is null.");
        }
        this.fSocketProperties = this.getDefensiveCopy(properties);
    }

    public int getSocketReceiveBufferSize() {
        return this.fSocketReceiveBufferSize;
    }

    public void setSocketReceiveBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("illegal buffer size: " + bufferSize);
        }
        this.fSocketReceiveBufferSize = bufferSize;
    }

    public int getSocketSendBufferSize() {
        return this.fSocketSendBufferSize;
    }

    public void setSocketSendBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("illegal buffer size: " + bufferSize);
        }
        this.fSocketSendBufferSize = bufferSize;
    }

    public void postHttpPayloadToTransport(byte[] payload) throws IOException {
        this.fPipe.writeToInputStream(payload);
    }

    public byte[] retrieveOutgoingHttpPayloadFromTransport() throws IOException {
        return this.fPipe.readFromOutputStream();
    }

    public InputStream getIncomingHttpTrafficStream() {
        return this.fPipe.getInputStream();
    }

    public OutputStream getOutgoingHttpTrafficStream() {
        return this.fPipe.getOutputStream();
    }

    public String getRemoteHostName() {
        return this.fRemoteHostName;
    }

    public int getRemotePort() {
        return this.fRemotePort;
    }

    public void close() {
        try {
            this.fPipe.close();
        }
        catch (IOException iOException) {}
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HttpTransportAdapter[addr=");
        buffer.append(this.getRemoteHostName());
        buffer.append(", port=");
        buffer.append(this.getRemotePort());
        buffer.append(", socket send buffer size [bytes]: ");
        buffer.append(this.getSocketSendBufferSize());
        buffer.append(", socket receive buffer size [bytes]: ");
        buffer.append(this.getSocketReceiveBufferSize());
        buffer.append("]");
        return buffer.toString();
    }

    private void checkPortRange(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
    }

    private IndexedProperties getDefensiveCopy(IndexedProperties properties) {
        return IndexedProperties.newInstance(properties);
    }

    public SSLContext getSSLContext() {
        return this.fSSLContext;
    }

    public boolean shouldValidateHostname() {
        return this.fValidateHostname;
    }

    public String[] getCipherSuites() {
        return this.fCipherSuites;
    }

    public String[] getProtocols() {
        return this.fProtocols;
    }

    public boolean getTryIPAddrFlag() {
        return this.fTryIPAddress;
    }
}

