/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class ConnectionNoticer
extends ASingleInstanceTracerFactory {
    private static ThreadLocal reentrancyMonitor = new ThreadLocal(){

        protected Object initialValue() {
            return new int[1];
        }
    };
    private static ConnectionCountingBehavior sConnectionCountingBehavior;

    private static synchronized void addBehaviorIfNecessary(IAgent agent) {
        if (sConnectionCountingBehavior == null) {
            sConnectionCountingBehavior = new ConnectionCountingBehavior(agent);
            agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)sConnectionCountingBehavior, "SQL Agent connection count metric", true, 7500L, true);
        }
    }

    public ConnectionNoticer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        ConnectionNoticer.addBehaviorIfNecessary(agent);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        int[] depth = (int[])reentrancyMonitor.get();
        depth[0] = depth[0] + 1;
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Object o;
        int[] depth = (int[])reentrancyMonitor.get();
        depth[0] = depth[0] - 1;
        if (depth[0] == 0 && (o = data.getInvocationObject()) != null) {
            this.noticeConnection(data, o);
        }
    }

    private void noticeConnection(InvocationData data, Object o) {
        if (o == null) {
            return;
        }
        if (!(o instanceof Connection)) {
            Assertion.wilyAssert((String)"expected a Connection");
            return;
        }
        this.doNoticeConnection(data, (Connection)o);
    }

    private void doNoticeConnection(InvocationData data, Connection c) {
        String metricName = this.formatParameterizedName(data);
        if (metricName.indexOf("Unknown Database") == -1) {
            sConnectionCountingBehavior.noticeNewConnection(metricName, c);
        }
    }

    private static final class ConnectionCountingBehavior
    implements ITimestampedRunnable {
        private static final Map sConnections = new HashMap();
        private final IAgent fAgent;

        public ConnectionCountingBehavior(IAgent agent) {
            this.fAgent = agent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noticeNewConnection(String metricName, Connection connection) {
            ConnectionHolder holder;
            Map map = sConnections;
            synchronized (map) {
                holder = (ConnectionHolder)sConnections.get(metricName);
                if (holder == null) {
                    holder = new ConnectionHolder(this.fAgent, metricName);
                    sConnections.put(metricName, holder);
                }
            }
            holder.addConnection(connection);
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            this.updateConnectionCounts();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConnectionCounts() {
            ConnectionHolder[] holders = null;
            Map map = sConnections;
            synchronized (map) {
                holders = sConnections.values().toArray(new ConnectionHolder[sConnections.size()]);
            }
            int i = 0;
            while (i < holders.length) {
                holders[i].updateValue();
                ++i;
            }
        }
    }

    private static final class ConnectionHolder {
        private final IIntegerFluctuatingCounterDataAccumulator fConnectionCount;
        private final Map fConnectionsSet;

        public ConnectionHolder(IAgent agent, String metricName) {
            this.fConnectionCount = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(metricName);
            this.fConnectionsSet = Collections.synchronizedMap(new WeakHashMap());
        }

        public void addConnection(Connection c) {
            this.fConnectionsSet.put(c, Boolean.TRUE);
        }

        public void updateValue() {
            this.fConnectionCount.IIntegerCounterDataAccumulator_setValue(this.fConnectionsSet.size());
        }
    }
}

