/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlparamagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.ResultSetToSQLMappingTracer;
import com.wily.introscope.agent.sqlparamagent.BucketHolder;
import com.wily.introscope.agent.sqlparamagent.SQLAgentConfiguration;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.util.properties.AttributeListing;
import java.sql.ResultSet;
import java.util.concurrent.atomic.AtomicInteger;

public class ResultSetRowTracer
extends ASingleMetricTracerFactory {
    private static final String kResultSetCreationRecord = "SQLResultSetCreationRecord";
    private static final IUpdater kUpdater = UpdaterFactory.getCombiningUpdater();
    private final SQLAgentConfiguration fConfiguration;
    private final BucketHolder bucketHolder;
    private final boolean isShutOff;
    public static final int kDefaultStringBufferSize = 200;

    public ResultSetRowTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fConfiguration = SQLAgentConfiguration.getInstance(agent);
        this.bucketHolder = BucketHolder.getInstance(this.fConfiguration);
        this.isShutOff = !this.fConfiguration.shouldCountRows();
    }

    public boolean ITracerFactory_isShutoff() {
        return this.isShutOff;
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kInstance;
    }

    protected IRepository getRepository(InvocationData data, ISharedMetricHolder metricHolder) {
        RepositoryFactory rf = new RepositoryFactory(this.getAgent().IAgent_getDataAccumulatorFactory(), this.fHighConcurrency);
        IRepository rep = rf.safeGetIntegerAverageDataAccumulator(this.getComponentName(data), metricHolder);
        return rep;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        ResultSet tracedObject = (ResultSet)data.getInvocationObject();
        ResultSetToSQLMappingTracer.ResultSetCreationRecord recordBean = ResultSetToSQLMappingTracer.getRecord(tracedObject);
        if (recordBean != null) {
            data.put(kResultSetCreationRecord, (Object)recordBean);
            super.ITracer_startTrace(tracerIndex, data);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        ResultSetToSQLMappingTracer.ResultSetCreationRecord recordBean = (ResultSetToSQLMappingTracer.ResultSetCreationRecord)data.get(kResultSetCreationRecord);
        if (recordBean != null) {
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }

    protected void doOnStartTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    protected void doOnEndTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
        ResultSet tracedObject = (ResultSet)((InvocationData)data).getInvocationObject();
        AtomicInteger rowCountObj = this.bucketHolder.getAndRemoveFromResultSetBucket(tracedObject);
        if (rowCountObj != null) {
            int rowCount = rowCountObj.get();
            mh.getRepository().update(kUpdater, (long)rowCount, data.getWallClockStartTime(), data.hashCode());
        }
    }
}

