/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class JmxMetricInfo {
    private final String metricRoot;
    private final String whiteListPatterns;
    private final String blackListPatterns;
    private final String forceDiscovery;
    private long configSyncInterval = 0L;
    private boolean autoConfigEnabled = true;
    private final Set<String> configModulePaths;
    private String configDumpDirPath;
    private long pollingInterval = 0L;
    private List<String> configThreadsList = new ArrayList<String>();
    private static Set<String> internalJmxModules = new LinkedHashSet<String>(Arrays.asList("jvm", "memory"));

    public JmxMetricInfo(String metricRoot, String whiteList, String blackList) {
        this(metricRoot, whiteList, blackList, Boolean.FALSE.toString());
    }

    public JmxMetricInfo(String metricRoot, String whiteList, String blackList, String forceDiscovery) {
        this(metricRoot, whiteList, blackList, forceDiscovery, internalJmxModules);
    }

    public JmxMetricInfo(String metricRoot, String whiteList, String blackList, String forceDiscovery, Set<String> modules) {
        this.metricRoot = metricRoot;
        this.whiteListPatterns = whiteList;
        this.blackListPatterns = blackList;
        this.forceDiscovery = forceDiscovery;
        this.configModulePaths = new LinkedHashSet<String>(modules);
    }

    public String getMetricRoot() {
        return this.metricRoot;
    }

    public String getWhiteListPatterns() {
        return this.whiteListPatterns;
    }

    public String getForceDiscoveryEnabled() {
        return this.forceDiscovery;
    }

    public String getBlackListPatterns() {
        return this.blackListPatterns;
    }

    public long getConfigSyncInterval() {
        return this.configSyncInterval;
    }

    public void setConfigSyncInterval(long configSyncInterval) {
        this.configSyncInterval = configSyncInterval;
    }

    public String[] getConfigModulePaths() {
        return this.configModulePaths.toArray(new String[0]);
    }

    public Set<String> getConfigModulePathsAsSet() {
        return new HashSet<String>(this.configModulePaths);
    }

    public void setConfigModulePaths(Set<String> modulePaths) {
        this.configModulePaths.clear();
        this.configModulePaths.addAll(modulePaths);
    }

    public void setConfigModulePaths(String[] modulePaths) {
        this.configModulePaths.clear();
        this.addConfigModulePaths(modulePaths);
    }

    public void addConfigModulePaths(String[] modulePaths) {
        String[] stringArray = modulePaths;
        int n = modulePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (p != null && !p.isEmpty()) {
                this.configModulePaths.add(p);
            }
            ++n2;
        }
    }

    public String getConfigDumpDirPath() {
        return this.configDumpDirPath;
    }

    public void setConfigDumpDirPath(String configDumpDirPath) {
        this.configDumpDirPath = configDumpDirPath;
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(long pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public void setConfigThreads(List<String> configThreadsList) {
        this.configThreadsList = configThreadsList;
    }

    public List<String> getConfigThreads() {
        return this.configThreadsList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JmxMetricInfo other = (JmxMetricInfo)o;
        return Objects.equals(this.getMetricRoot(), other.getMetricRoot()) && Objects.equals(this.getWhiteListPatterns(), other.getWhiteListPatterns()) && Objects.equals(this.getBlackListPatterns(), other.getBlackListPatterns()) && Objects.equals(this.isAutoConfigEnabled(), other.isAutoConfigEnabled()) && Objects.equals(this.getConfigSyncInterval(), other.getConfigSyncInterval()) && Objects.equals(this.getPollingInterval(), other.getPollingInterval());
    }

    public int hashCode() {
        return Objects.hash(this.metricRoot, this.whiteListPatterns, this.blackListPatterns, this.autoConfigEnabled, this.configSyncInterval, this.pollingInterval);
    }

    public String toString() {
        return "{metricRoot: " + this.metricRoot + ", whiteListPatterns: " + this.whiteListPatterns + ", blackListPatterns: " + this.blackListPatterns + ", configFilePaths: " + this.configModulePaths + "}";
    }

    public boolean isAutoConfigEnabled() {
        return this.autoConfigEnabled;
    }

    public void setAutoConfigEnabled(boolean autoConfigEnabled) {
        this.autoConfigEnabled = autoConfigEnabled;
    }

    private boolean isInternalModule(String module) {
        return internalJmxModules.contains(module);
    }
}

