/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.servlet;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class WilyJakartaServletInputStream
extends ServletInputStream {
    InputStream delegate;

    public WilyJakartaServletInputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    public static ServletInputStream getWilyServletInputStream(ServletInputStream delegate, byte[] content) {
        return new WilyJakartaServletInputStream(new BufferedInputStream(new ByteArrayInputStream(content)));
    }

    public static Object substituteResult(Object in, Object out) {
        return new WilyJakartaServletInputStream((InputStream)((ServletInputStream)in));
    }

    public int read() throws IOException {
        return this.delegate.read();
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        int c;
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while ((c = this.read()) != -1) {
            b[off++] = (byte)c;
            if (c == 10 || ++count == len) break;
        }
        return count > 0 ? count : -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    public int available() throws IOException {
        return this.delegate.available();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public synchronized void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.delegate.reset();
    }

    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    public boolean isFinished() {
        if (this.delegate instanceof ServletInputStream) {
            return ((ServletInputStream)this.delegate).isFinished();
        }
        try {
            return ((BufferedInputStream)this.delegate).available() == 0;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public boolean isReady() {
        if (this.delegate instanceof ServletInputStream) {
            return ((ServletInputStream)this.delegate).isFinished();
        }
        try {
            return ((BufferedInputStream)this.delegate).available() > 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setReadListener(ReadListener readListener) {
        if (this.delegate instanceof ServletInputStream) {
            ((ServletInputStream)this.delegate).setReadListener(readListener);
        }
    }
}

