/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.net;

import com.sun.istack.internal.NotNull;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.BlameStackAnnotationHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IBlameStackAnnotator;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.ITracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.introscope.agent.trace.io.clamp.TracedSockets;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.introscope.agent.util.SocketUtils;
import com.wily.util.WilyStringBuilder;
import com.wily.util.adt.ConcurrentMapFactory;
import com.wily.util.adt.ConcurrentWeakIdentityHighPerformanceLRUHashMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.SocketImpl;

public class AgentSocketIOCustomTracer {
    private static final String kServerSocketTracerMetric = "Sockets|Server|Port {port}";
    private static final String kClientSocketTracerMetric = "Sockets|Client|{hostname}|Port {port}";
    private static final String kOutputBandwidthMetric = ":Output Bandwidth (Bytes Per Second)";
    private static final String kInputBandwithMetric = ":Input Bandwidth (Bytes Per Second)";
    private static final String kConcurrentWritersMetric = ":Concurrent Writers";
    private static final String kConcurrentReadersMetric = ":Concurrent Readers";
    private static final String kBackendTracerMetric = "Backends|System {hostname} on port {port}";
    private static final String kAppMapComponent = "System {hostname} on port {port}";
    private static final String kIOContextCacheMapName = "SocketIOContextCacheMap";
    private static final String kSocketImplCacheMapName = "SocketImplCacheMap";
    private static Module module = new Module("AgentSocketIOCustomTracer");
    private static IModuleFeedbackChannel feedback;
    private static IAgent agent;
    private static boolean initAgent;
    public static ConcurrentWeakIdentityHighPerformanceLRUHashMap<Object, CacheItem> ioContextCache;
    public static ConcurrentWeakIdentityHighPerformanceLRUHashMap<Object, Boolean> socketScreen;

    static {
        initAgent = false;
        ioContextCache = AgentSocketIOCustomTracer.createMap();
        socketScreen = AgentSocketIOCustomTracer.createSocketImplCacheMap();
    }

    private static void init() {
        try {
            if (!initAgent) {
                agent = AgentShim.getAgent();
                feedback = agent.IAgent_getModuleFeedback();
                initAgent = true;
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    private static ConcurrentWeakIdentityHighPerformanceLRUHashMap<Object, CacheItem> createMap() {
        AgentSocketIOCustomTracer.init();
        ConcurrentMapFactory factory = (ConcurrentMapFactory)agent.IAgent_getConcurrentMapFactory();
        ConcurrentMapFactory.ConcurrentMapPolicy p = new ConcurrentMapFactory.ConcurrentMapPolicy(kIOContextCacheMapName, ConcurrentMapFactory.ConcurrentMapType.CappedWeakIdentity, true, ConcurrentMapFactory.ThreadLocalOption.NoThreadLocal, 16, 1000, 0, 0.75f, 1000, 0);
        IntervalHeartbeat beat = agent.IAgent_getCommonHeartbeat();
        factory.addMapPolicy(kIOContextCacheMapName, p, agent.IAgent_getModuleFeedback(), beat);
        return factory.getConcurrentCappedWeakIdentityHashMap(kIOContextCacheMapName);
    }

    private static ConcurrentWeakIdentityHighPerformanceLRUHashMap<Object, Boolean> createSocketImplCacheMap() {
        AgentSocketIOCustomTracer.init();
        ConcurrentMapFactory factory = (ConcurrentMapFactory)agent.IAgent_getConcurrentMapFactory();
        ConcurrentMapFactory.ConcurrentMapPolicy p = new ConcurrentMapFactory.ConcurrentMapPolicy(kSocketImplCacheMapName, ConcurrentMapFactory.ConcurrentMapType.CappedWeakIdentity, true, ConcurrentMapFactory.ThreadLocalOption.NoThreadLocal, 16, 1000, 0, 0.75f, 1000, 0);
        IntervalHeartbeat beat = agent.IAgent_getCommonHeartbeat();
        factory.addMapPolicy(kSocketImplCacheMapName, p, agent.IAgent_getModuleFeedback(), beat);
        return factory.getConcurrentCappedWeakIdentityHashMap(kSocketImplCacheMapName);
    }

    public static void readStart(Object data) {
        AgentSocketIOCustomTracer.read(data, false, 0);
    }

    private static void read(Object impl, boolean isWrite, int bytes) {
        try {
            boolean record = AgentSocketIOCustomTracer.routeIOCall(impl, isWrite, bytes);
            if (record) {
                SocketUtils.suggestStackTraceRecording();
            }
        }
        catch (Exception exception) {}
    }

    public static int readEnd(int readBytes, Object data) {
        try {
            if (ioContextCache.containsWeakKey(data) && !AgentSocketIOCustomTracer.checkWithOverheadMgr()) {
                ioContextCache.getWeak(data).process(new Object[]{false, readBytes, true, data.toString()});
            }
        }
        catch (Exception exception) {}
        return readBytes;
    }

    public static void write(Object data, int writeBytes) {
        AgentSocketIOCustomTracer.write(data, true, writeBytes);
    }

    public static void write(Object data, byte[] input) {
        if (input != null) {
            AgentSocketIOCustomTracer.write(data, true, input.length);
        }
    }

    public static void write(Object data) {
        AgentSocketIOCustomTracer.write(data, true, 1);
    }

    private static void write(Object impl, boolean isWrite, int bytes) {
        try {
            boolean record = AgentSocketIOCustomTracer.routeIOCall(impl, isWrite, bytes);
            if (record) {
                SocketUtils.suggestStackTraceRecording();
            }
        }
        catch (Exception exception) {}
    }

    private static boolean routeIOCall(Object context, boolean isWrite, int bytes) {
        block4: {
            try {
                if (!AgentSocketIOCustomTracer.checkWithOverheadMgr()) break block4;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (!ioContextCache.containsWeakKey(context)) {
            CacheItem id = AgentSocketIOCustomTracer.createInvocationData(context);
            ioContextCache.putWeak(context, id);
        }
        return ioContextCache.getWeak(context).process(new Object[]{isWrite, bytes, false, context.toString()});
    }

    private static CacheItem createInvocationData(Object impl) {
        String[] lClassBlacklist = "com.wily.isengard".split(",");
        try {
            SocketImpl socketImpl = null;
            Object socket = null;
            if (impl instanceof SocketImpl) {
                socketImpl = (SocketImpl)impl;
            } else if (impl instanceof OutputStream || impl instanceof InputStream) {
                socketImpl = AgentSocketIOCustomTracer.getImplementationFromStream(impl);
                socket = AgentSocketIOCustomTracer.getSocketFromStream(impl);
            }
            if (socketImpl != null) {
                SocketUtils.SocketPojo socketInfo = new SocketUtils.SocketPojo(socketImpl);
                Boolean compareSocket = socketScreen.getWeak(socketImpl);
                if (compareSocket == null && socket != null) {
                    compareSocket = socketScreen.getWeak(socket);
                }
                boolean isTraced = true;
                isTraced = compareSocket != null ? TracedSockets.isTraced(socketInfo.getLocalPort()) : TracedSockets.isTraced(socketInfo.getInetAddress(), socketInfo.getPort());
                if (!isTraced) {
                    return new NoOpCacheItem("Socket has been clamped. " + socketInfo.toString());
                }
                ProbeInformation probeInfo = new ProbeInformation(agent, new ProbeIdentification("", "", "", ""), new ITracerFactory[0]);
                InvocationData returnInvD = probeInfo.getExternalTracer(agent, socketInfo, true);
                String currentThreadStackTrace = SocketUtils.getStackString();
                String[] stringArray = lClassBlacklist;
                int n = lClassBlacklist.length;
                int n2 = 0;
                while (n2 < n) {
                    String ignoreItem = stringArray[n2];
                    if (currentThreadStackTrace.contains(ignoreItem)) {
                        return new NoOpCacheItem("Connection is from a blacklist: " + ignoreItem);
                    }
                    ++n2;
                }
                SocketFormatMetricsCache cachedResource = new SocketFormatMetricsCache(socketInfo.getLocalAddress().getHostAddress() == null ? null : socketInfo.getLocalAddress().getHostAddress(), socketInfo.getInetAddress().getHostName().toLowerCase(), socketInfo.getInetAddress().getHostAddress(), compareSocket != null ? socketInfo.getLocalPort() : socketInfo.getPort());
                if (compareSocket != null) {
                    cachedResource.setResourceName(AgentSocketIOCustomTracer.getFormattedString(kServerSocketTracerMetric, socketInfo.getInetAddress().getHostName(), socketInfo.getLocalPort()));
                    cachedResource.setClientConnection(false);
                } else {
                    cachedResource.setResourceName(AgentSocketIOCustomTracer.getFormattedString(kClientSocketTracerMetric, socketInfo.getInetAddress().getHostName(), socketInfo.getPort()));
                    cachedResource.setClientConnection(true);
                }
                AgentSocketIOCustomTracer.completeMetricsAndAccumulators(cachedResource);
                returnInvD.setPartialSocketFormattedName(cachedResource);
                return new InvocationDataCacheItem(returnInvD).setItemDescription(impl.toString());
            }
            return new NoOpCacheItem("Cant retrieve info from Context object");
        }
        catch (Exception e) {
            return new NoOpCacheItem("Cant create Invocation Data: " + e);
        }
        catch (Error error) {
            return new NoOpCacheItem("Cant create Invocation Data: " + error);
        }
    }

    private static SocketImpl getImplementationFromStream(Object stream) {
        try {
            Field _AbstractPlainSocketImpl = stream.getClass().getDeclaredField("impl");
            _AbstractPlainSocketImpl.setAccessible(true);
            return (SocketImpl)_AbstractPlainSocketImpl.get(stream);
        }
        catch (Exception exception) {
            if (feedback.isTraceEnabled(module)) {
                feedback.trace(module, "Error in getting backing implementation object from " + stream);
            }
            return null;
        }
    }

    private static Object getSocketFromStream(Object stream) {
        try {
            Field _AbstractPlainSocket = stream.getClass().getDeclaredField("socket");
            _AbstractPlainSocket.setAccessible(true);
            return _AbstractPlainSocket.get(stream);
        }
        catch (Exception exception) {
            if (feedback.isTraceEnabled(module)) {
                feedback.trace(module, "Error in getting backing socket object from " + stream);
            }
            return null;
        }
    }

    private static void completeMetricsAndAccumulators(SocketFormatMetricsCache cache) {
        try {
            String resourceName = cache.getResourceName();
            String hostName = cache.getHostName();
            int port = cache.getPort();
            int metricPosition = 5;
            String formattedMetricName = String.valueOf(resourceName) + kConcurrentReadersMetric;
            formattedMetricName = AgentSocketIOCustomTracer.getFormattedString(formattedMetricName, hostName, port);
            cache.setAccumulators(agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName), metricPosition);
            cache.setFormattedMetrics(formattedMetricName, metricPosition);
            metricPosition = 6;
            formattedMetricName = String.valueOf(resourceName) + kConcurrentWritersMetric;
            formattedMetricName = AgentSocketIOCustomTracer.getFormattedString(formattedMetricName, hostName, port);
            cache.setAccumulators(agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName), metricPosition);
            cache.setFormattedMetrics(formattedMetricName, metricPosition);
            metricPosition = 8;
            formattedMetricName = String.valueOf(resourceName) + kInputBandwithMetric;
            formattedMetricName = AgentSocketIOCustomTracer.getFormattedString(formattedMetricName, hostName, port);
            cache.setAccumulators(agent.IAgent_getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(formattedMetricName), metricPosition);
            cache.setFormattedMetrics(formattedMetricName, metricPosition);
            metricPosition = 7;
            formattedMetricName = String.valueOf(resourceName) + kOutputBandwidthMetric;
            formattedMetricName = AgentSocketIOCustomTracer.getFormattedString(formattedMetricName, hostName, port);
            cache.setAccumulators(agent.IAgent_getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(formattedMetricName), metricPosition);
            cache.setFormattedMetrics(formattedMetricName, metricPosition);
            metricPosition = 9;
            formattedMetricName = AgentSocketIOCustomTracer.getFormattedString(kBackendTracerMetric, hostName, port);
            cache.setFormattedMetrics(formattedMetricName, metricPosition);
            metricPosition = 10;
            formattedMetricName = AgentSocketIOCustomTracer.getFormattedString(kAppMapComponent, hostName, port);
            cache.setFormattedMetrics(formattedMetricName, metricPosition);
        }
        catch (Exception exception) {}
    }

    private static String getFormattedString(String resourceName, String hostName, int port) {
        char[] kHostNamePlaceHolder = "{hostname}".toCharArray();
        char[] kPortPlaceHolder = "{port}".toCharArray();
        WilyStringBuilder bldr = new WilyStringBuilder();
        bldr.setString(resourceName);
        int i = bldr.indexOf(kHostNamePlaceHolder);
        if (i >= 0) {
            bldr = bldr.replace(i, i + kHostNamePlaceHolder.length, hostName);
        }
        if ((i = bldr.indexOf(kPortPlaceHolder)) >= 0) {
            bldr = bldr.replace(i, i + kPortPlaceHolder.length, Integer.toString(port));
        }
        return bldr.toString();
    }

    private static boolean checkWithOverheadMgr() {
        return OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND == OverheadAdministrator.getOverheadMode() || OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode();
    }

    private static abstract class CacheItem {
        static int INVOCATION_DATA_ITEM = 0;
        static int NO_OP_ITEM = 1;
        int type = INVOCATION_DATA_ITEM;

        private CacheItem() {
        }

        abstract Object getRawItem();

        public String getItemDescription() {
            return "CacheItem";
        }

        abstract boolean process(Object[] var1);
    }

    private static class InvocationDataCacheItem
    extends CacheItem {
        String itemDescription = "InvocationData";
        InvocationData data;

        public InvocationDataCacheItem(InvocationData invocationData) {
            this.type = INVOCATION_DATA_ITEM;
            this.data = invocationData;
        }

        @Override
        InvocationData getRawItem() {
            return this.data;
        }

        public CacheItem setItemDescription(String des) {
            this.itemDescription = des;
            return this;
        }

        @Override
        public String getItemDescription() {
            return this.itemDescription;
        }

        @Override
        boolean process(Object[] input) {
            int bytes;
            boolean isWrite;
            boolean record;
            block9: {
                boolean processOnlyBandwidth;
                block8: {
                    block7: {
                        record = false;
                        try {
                            if (this.data != null && input != null) break block7;
                            return false;
                        }
                        catch (Exception exception) {}
                    }
                    isWrite = (Boolean)input[0];
                    bytes = (Integer)input[1];
                    processOnlyBandwidth = (Boolean)input[2];
                    String contextDescription = (String)input[3];
                    if (contextDescription.equals(this.getItemDescription())) break block8;
                    feedback.debug(module, "Error!! " + contextDescription + ", itemdesc: " + this.getItemDescription());
                    return false;
                }
                if (!processOnlyBandwidth || isWrite) break block9;
                SocketFormatMetricsCache lvSFMC = (SocketFormatMetricsCache)this.data.getPartialSocketFormattedName();
                lvSFMC.addToInputBandwidth(bytes);
                this.data.setPartialSocketFormattedName(lvSFMC);
                lvSFMC.loopMetricPoller(isWrite, false);
                return true;
            }
            SocketFormatMetricsCache lvSFMC = (SocketFormatMetricsCache)this.data.getPartialSocketFormattedName();
            if (isWrite) {
                lvSFMC.addToOutputBandwidth(bytes);
            }
            this.data.setPartialSocketFormattedName(lvSFMC);
            lvSFMC.loopMetricPoller(isWrite, true);
            if (lvSFMC.isClientConnection()) {
                this.annotateBlameStack(this.data, isWrite);
                record = true;
            }
            return record;
        }

        private void annotateBlameStack(@NotNull InvocationData data, boolean isWrite) {
            try {
                IBlameStackAnnotator defaultBackendBlameStackAnnotator;
                IStackElement element = VirtualStack.peek();
                if (element == null) {
                    return;
                }
                ITransactionElement currentCursor = element.getCursor();
                SocketFormatMetricsCache fCache = (SocketFormatMetricsCache)data.getPartialSocketFormattedName();
                if (currentCursor != null && (defaultBackendBlameStackAnnotator = BlameStackAnnotationHelper.getBlameStackAnnotator(BlameStackAnnotationHelper.kDefaultBackendBlameStackAnnotator)) != null) {
                    String formattedMetricName = fCache.getFormattedMetrics(9);
                    defaultBackendBlameStackAnnotator.annotateBlameStack((Object)formattedMetricName, fCache.getLocalAddress(), fCache.getHostName(), fCache.getHostAddress(), fCache.getPort(), currentCursor, element, true);
                }
            }
            catch (Exception exception) {}
        }
    }

    private static class NoOpCacheItem
    extends CacheItem {
        String itemDescription = "No Op";

        public NoOpCacheItem(String itemDescription) {
            this.itemDescription = itemDescription;
            this.type = NO_OP_ITEM;
        }

        @Override
        String getRawItem() {
            return this.itemDescription;
        }

        @Override
        boolean process(Object[] input) {
            return false;
        }
    }
}

