/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.transform.AClassTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.SubstituteStaticMethodTransformationBuilder;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IModeledClass;

public final class SubstituteStaticMethodTransformation
extends AClassTransformation {
    private final TracerGroup fTracerGroup;
    private final FullyQualifiedMethodName fSourceMethod;
    private final FullyQualifiedMethodName fReplacementMethod;

    public SubstituteStaticMethodTransformation(ICompilerLog log, FullyQualifiedMethodName sourceMethod, FullyQualifiedMethodName replacementMethod) {
        this(log, null, sourceMethod, replacementMethod);
    }

    public SubstituteStaticMethodTransformation(ICompilerLog log, TracerGroup tracerGroup, FullyQualifiedMethodName sourceMethod, FullyQualifiedMethodName replacementMethod) {
        super(log);
        this.fTracerGroup = tracerGroup;
        this.fSourceMethod = sourceMethod;
        this.fReplacementMethod = replacementMethod;
    }

    public TracerGroup getTracerGroup() {
        return this.fTracerGroup;
    }

    public FullyQualifiedMethodName getSourceMethod() {
        return this.fSourceMethod;
    }

    public FullyQualifiedMethodName getReplacementMethod() {
        return this.fReplacementMethod;
    }

    @Override
    protected boolean doShouldProcessClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return !ClassSettingsApplier.shouldSkipClassForTracerGroup(this.getLog(), targetClass, this.getTracerGroup());
    }

    @Override
    protected boolean doShouldMutateClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return true;
    }

    @Override
    protected IMutation doGenerateClassMutation(DGCompilerSettings settings, IClassMutator mutator, IModeledClass targetClass) {
        return mutator.newSubstituteStaticMethodClassMutation(settings, targetClass, this);
    }

    @Override
    public ITransformationBuilder generateTransformationBuilder(CompilerSettingsBuilder builder) {
        return new SubstituteStaticMethodTransformationBuilder(builder.getTracerGroupBuilder(this.getTracerGroup()), this.getSourceMethod(), this.getReplacementMethod());
    }
}

