/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.api;

import com.ca.apm.agent.jmxclient.api.JmxMetricNameFormatter;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.wily.introscope.spec.server.MetricNameUtils;
import com.wily.util.StringUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class BasicJmxMetricNameFormatter
implements JmxMetricNameFormatter {
    private static final String KEY_FORMAT = "{%s}";
    private final JmxNodeInfo nodeInfo;

    public BasicJmxMetricNameFormatter(JmxNodeInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    @Override
    public String format(String metricNamePattern, String objectNamePattern, ObjectName objectName, MBeanInfo beanInfo, MBeanAttributeInfo atInfo, MBeanOperationInfo opInfo) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("{rootNode}", this.nodeInfo.getMetricRoot());
        values.put("{componentName}", this.replaceForbiddenChars(this.nodeInfo.getSystemName()));
        values.put("{host}", this.replaceForbiddenChars(this.nodeInfo.getHost()));
        values.put("{port}", this.replaceForbiddenChars(String.valueOf(this.nodeInfo.getPort())));
        values.put("{domain}", this.replaceForbiddenChars(objectName.getDomain()));
        values.put("{className}", this.replaceForbiddenChars(beanInfo.getClassName()));
        if (atInfo != null) {
            values.put("{attribute}", this.replaceForbiddenChars(atInfo.getName()));
            values.put("{attributeType}", this.replaceForbiddenChars(atInfo.getType()));
        }
        if (opInfo != null) {
            values.put("{operation}", this.replaceForbiddenChars(opInfo.getName()));
            values.put("{operationReturnType}", this.replaceForbiddenChars(opInfo.getReturnType()));
        }
        StringBuilder propBuilder = new StringBuilder();
        TreeSet<Map.Entry<String, String>> tree = new TreeSet<Map.Entry<String, String>>(new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        tree.addAll(objectName.getKeyPropertyList().entrySet());
        Iterator<Map.Entry<String, String>> iterator = tree.iterator();
        if (iterator.hasNext()) {
            while (true) {
                Map.Entry<String, String> entry = iterator.next();
                String formattedKey = String.format(KEY_FORMAT, entry.getKey());
                if (!values.containsKey(formattedKey)) {
                    values.put(formattedKey, entry.getValue());
                }
                propBuilder.append(String.valueOf(this.replaceForbiddenChars(entry.getKey())) + "=" + this.replaceForbiddenChars(entry.getValue()));
                if (!iterator.hasNext()) break;
                propBuilder.append("|");
            }
        }
        values.put("{properties}", propBuilder.toString());
        for (Map.Entry entry : values.entrySet()) {
            String key = (String)entry.getKey();
            int index = metricNamePattern.indexOf(key);
            if (index == -1) continue;
            metricNamePattern = StringUtils.replace((String)metricNamePattern, (String)key, (String)((String)entry.getValue()));
        }
        return metricNamePattern;
    }

    private String replaceForbiddenChars(String value) {
        return value != null ? MetricNameUtils.substituteMetricSeparatorChars((String)value) : value;
    }
}

