/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.metric.calculator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IAgentMetricCalculatorService;
import com.wily.introscope.agent.metric.calculator.CalculatorSet;
import com.wily.introscope.agent.metric.calculator.Operation;
import com.wily.introscope.agent.metric.calculator.OperationDeserializer;
import com.wily.introscope.agent.metric.calculator.SustainabilityMetrics;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.Frequency;
import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.gatherer.GathererFactory;
import com.wily.introscope.stat.gatherer.IGatherer;
import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class CalculatorService
implements IAgentService,
IAgentMetricCalculatorService,
IConfigurationListener {
    private IAgent fAgent;
    public static final Module kModule = new Module("AgentMetricCalculator");
    private IModuleFeedbackChannel fFeedback;
    private final Set<CalculatorSet> calculators = new HashSet<CalculatorSet>();
    public final String calculatorPropertyKey = "com.wily.instroscope.agent.metric.calculators.";
    private Pattern dumpMetricsMatchPattern;
    private Map<String, IMetricDataValue> inputMetrics;
    private Map<String, OutputMetric> outputMetrics;
    private Set<String> removedMetrics;
    private SustainabilityMetrics sustainability;
    private Map<AgentMetric, Long> lastSeenMetricCache;

    public int IAgentService_getServiceVersion() {
        return 2;
    }

    public void IAgentService_startService(IAgent agent, Map params) throws Exception {
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fFeedback.info(kModule, "Calculator Service starting");
        this.sustainability = new SustainabilityMetrics(agent);
        this.lastSeenMetricCache = new ConcurrentHashMap<AgentMetric, Long>();
        this.fAgent.IAgent_setAgentCalculatorService((IAgentMetricCalculatorService)this);
        agent.addConfigurationListener((IConfigurationListener)this);
        String dumpMetricMatchingRegex = agent.IAgent_getIndexedProperties().getProperty("com.wily.instroscope.agent.metric.calculators.dumpMetricsMatchingRegex");
        if (dumpMetricMatchingRegex != null) {
            this.fFeedback.info(kModule, "[Metric Dump] Metric dump enabled for metrics matching regex: " + dumpMetricMatchingRegex);
            this.dumpMetricsMatchPattern = Pattern.compile(dumpMetricMatchingRegex);
        }
    }

    public void addCalculatorSet(CalculatorSet calcSet) {
        this.addCalculatorSet(calcSet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCalculatorSet(CalculatorSet calcSet) {
        boolean result = false;
        Set<CalculatorSet> set = this.calculators;
        synchronized (set) {
            result = this.calculators.remove(calcSet);
        }
        if (result) {
            this.fFeedback.info(kModule, "Successfully removed calculator set: " + calcSet.getName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCalculatorSet(CalculatorSet calcSet, String loadedFromFile) {
        if (loadedFromFile != null) {
            calcSet.setLoadedFromFile(loadedFromFile);
        }
        calcSet.setService(this);
        Set<CalculatorSet> set = this.calculators;
        synchronized (set) {
            this.calculators.add(calcSet);
        }
        this.fFeedback.info(kModule, "Successfully added calculator set: " + calcSet.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentMetricData[] processTimeslice(AgentMetricData[] bindings) {
        if (bindings == null || bindings.length == 0) {
            return bindings;
        }
        Set<CalculatorSet> set = this.calculators;
        synchronized (set) {
            if (this.calculators.size() == 0) {
                return bindings;
            }
        }
        long startTime = System.currentTimeMillis();
        Frequency frequency = bindings[0].getFrequency();
        this.inputMetrics = new HashMap<String, IMetricDataValue>(bindings.length);
        this.outputMetrics = new HashMap<String, OutputMetric>();
        this.removedMetrics = new HashSet<String>();
        AgentMetricData[] agentMetricDataArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            AgentMetricData data = agentMetricDataArray[n2];
            String metric = data.getAgentMetric().toString();
            IMetricDataValue value = data.getDataValue();
            this.inputMetrics.put(metric, value);
            if (this.dumpMetricsMatchPattern != null && this.dumpMetricsMatchPattern.matcher(metric).matches()) {
                this.fFeedback.info(kModule, "[Metric Dump] metric : " + metric + ", value: " + value.toString());
            }
            ++n2;
        }
        int calculatorCount = 0;
        Set<CalculatorSet> set2 = this.calculators;
        synchronized (set2) {
            for (CalculatorSet calcSet : this.calculators) {
                calcSet.calculate(this.inputMetrics);
                calculatorCount += calcSet.getCalculators().size();
            }
        }
        AgentMetricData[] outBindings = this.createOutputBindings(frequency, bindings);
        long endTime = System.currentTimeMillis();
        this.sustainability.reportTotalMetrics((int)(endTime - startTime), this.calculators.size(), calculatorCount, this.outputMetrics.size());
        this.inputMetrics = null;
        this.outputMetrics = null;
        this.removedMetrics = null;
        return outBindings;
    }

    public void updateLastSeenMetricCache(AgentMetric m) {
        if (m != null) {
            this.lastSeenMetricCache.put(m, System.currentTimeMillis());
        }
    }

    public AgentMetric[] computeDeadMetrics() {
        AgentMetric[] result = new AgentMetric[this.lastSeenMetricCache.size()];
        int i = 0;
        for (AgentMetric metric : this.lastSeenMetricCache.keySet()) {
            long lastSeenTime = this.lastSeenMetricCache.get(metric);
            if (System.currentTimeMillis() - lastSeenTime <= 15000L) continue;
            result[i] = metric;
            ++i;
        }
        AgentMetric[] agentMetricArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            AgentMetric m = agentMetricArray[n2];
            if (m != null) {
                this.lastSeenMetricCache.remove(m);
            }
            ++n2;
        }
        return result;
    }

    public IMetricDataValue getInputMetric(String metric) {
        IMetricDataValue result = this.inputMetrics.get(metric);
        if (result == null) {
            OutputMetric om = this.getOutputMetric(metric);
            if (om == null) {
                return null;
            }
            result = om.getValue();
        }
        return result;
    }

    public OutputMetric getOutputMetric(String metric) {
        return this.outputMetrics.get(metric);
    }

    public OutputMetric putOutputMetric(String metric, OutputMetric value) {
        return this.outputMetrics.put(metric, value);
    }

    public boolean addRemovedMetric(String metric) {
        return this.removedMetrics.add(metric);
    }

    public Map<String, OutputMetric> getOutputMetrics() {
        return this.outputMetrics;
    }

    private AgentMetricData[] createOutputBindings(Frequency frequency, AgentMetricData[] inputbindings) {
        AgentMetricData binding;
        ArrayList<AgentMetricData> outputbindings = new ArrayList<AgentMetricData>(this.outputMetrics.size());
        for (Map.Entry<String, OutputMetric> e : this.outputMetrics.entrySet()) {
            try {
                AgentMetric metric = AgentMetric.getAgentMetric((String)e.getKey(), (int)e.getValue().getValue().getType());
                if (metric != AgentMetric.kNullAgentMetric) {
                    outputbindings.add(new AgentMetricData(metric, frequency, e.getValue().getValue()));
                    continue;
                }
                if (!this.fFeedback.isDebugEnabled()) continue;
                this.fFeedback.debug(kModule, "Failed to create calculated metric due to metric clamp:" + e.getKey());
            }
            catch (BadlyFormedNameException e1) {
                this.fFeedback.error(kModule, "Failed to create calculated metric:" + e1.getMessage());
            }
        }
        AgentMetricData[] result = new AgentMetricData[outputbindings.size() + inputbindings.length - this.removedMetrics.size()];
        int i = 0;
        AgentMetricData[] agentMetricDataArray = inputbindings;
        int n = inputbindings.length;
        int n2 = 0;
        while (n2 < n) {
            binding = agentMetricDataArray[n2];
            if (!this.removedMetrics.contains(binding.getAgentMetric().toString())) {
                result[i] = binding;
                ++i;
            }
            ++n2;
        }
        Iterator iterator = outputbindings.iterator();
        while (iterator.hasNext()) {
            result[i] = binding = (AgentMetricData)iterator.next();
            ++i;
        }
        return result;
    }

    private boolean loadCalculatorSet(String key, String fileName) {
        try {
            this.fFeedback.info(kModule, "Loading calculator set from " + fileName);
            File file = new File(fileName);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Operation.class), new OperationDeserializer()).create();
            CalculatorSet set = gson.fromJson((Reader)reader, CalculatorSet.class);
            this.addCalculatorSet(set, fileName);
            return true;
        }
        catch (JsonSyntaxException e) {
            this.fFeedback.error(kModule, "Failed to load calculatorset from " + fileName + ": " + e.getMessage());
        }
        catch (JsonParseException e) {
            this.fFeedback.error(kModule, "Failed to load calculatorset from " + fileName + ": " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.fFeedback.error(kModule, "Error opening file for " + key + ": " + e.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(IndexedProperties newProps) {
        Set<CalculatorSet> set = this.calculators;
        synchronized (set) {
            HashMap<String, CalculatorSet> fileMap = new HashMap<String, CalculatorSet>(this.calculators.size());
            Iterator<CalculatorSet> it = this.calculators.iterator();
            while (it.hasNext()) {
                CalculatorSet cs = it.next();
                String file = cs.isLoadedFromFile();
                if (file == null) continue;
                it.remove();
                fileMap.put(file, cs);
            }
            for (String key : newProps.getAllKeys()) {
                if (!key.startsWith("com.wily.instroscope.agent.metric.calculators.")) continue;
                this.fFeedback.debug(kModule, "Processing property: " + key);
                String fileName = newProps.getProperty(key);
                CalculatorSet cs = (CalculatorSet)fileMap.get(fileName);
                if (cs == null) {
                    this.loadCalculatorSet(key, fileName);
                    continue;
                }
                this.calculators.add(cs);
                fileMap.remove(fileName);
            }
            for (CalculatorSet cs : fileMap.values()) {
                this.fFeedback.info(kModule, "Removed calculator set: " + cs.getName());
            }
        }
    }

    public SustainabilityMetrics getSustainability() {
        return this.sustainability;
    }

    public IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    public Module getModule() {
        return kModule;
    }

    static class OutputMetric {
        private IMetricDataValue value;
        private IGatherer gatherer;

        public OutputMetric(IMetricDataValue value) {
            this.value = value;
        }

        public IMetricDataValue getValue() {
            if (this.gatherer != null) {
                this.value = this.gatherer.harvestAndAbandonNonSync(this.value.getStopTimestampInMillis());
                this.gatherer = null;
            }
            return this.value;
        }

        public IGatherer getGatherer() {
            if (this.gatherer == null) {
                this.gatherer = GathererFactory.newSpaceAggregatingGathererByType((int)this.value.getType(), (long)this.value.getStartTimestampInMillis());
                try {
                    this.gatherer.acceptValueNonSync(this.value);
                }
                catch (IncompatibleTypesException incompatibleTypesException) {}
            }
            return this.gatherer;
        }
    }
}

