/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.metric.calculator;

import com.wily.introscope.agent.metric.calculator.BinaryOperation;
import com.wily.introscope.agent.metric.calculator.Operation;
import com.wily.introscope.spec.metric.TypeInquisitor;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.timeslice.ANumericalTimeslicedValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;

public class SubtractOperation
extends BinaryOperation {
    public SubtractOperation(Operation op1, Operation op2) {
        super(op1, op2);
    }

    @Override
    protected IMetricDataValue calculate(IMetricDataValue v1, IMetricDataValue v2) {
        ANumericalTimeslicedValue result = null;
        if (v1 instanceof ANumericalTimeslicedValue && v2 instanceof ANumericalTimeslicedValue) {
            result = this.subtractNumericalTimeslicedValues((ANumericalTimeslicedValue)v1, (ANumericalTimeslicedValue)v2);
        }
        return result;
    }

    private ANumericalTimeslicedValue subtractNumericalTimeslicedValues(ANumericalTimeslicedValue v1, ANumericalTimeslicedValue v2) {
        LongTimeslicedValue result = null;
        int type = !TypeInquisitor.isConstant((int)v1.getType()) ? v1.getType() : v2.getType();
        long startTimestamp = v1.getStartTimestampInMillis() > 0L ? v1.getStartTimestampInMillis() : v2.getStartTimestampInMillis();
        long stopTimestamp = v1.getStopTimestampInMillis() > 0L ? v1.getStopTimestampInMillis() : v2.getStopTimestampInMillis();
        BlameStackSnapshot blameStack = v1.getBlameStackSnapshot() != null ? v1.getBlameStackSnapshot() : v2.getBlameStackSnapshot();
        boolean dataIsAbsent = v1.dataIsAbsent() && v2.dataIsAbsent();
        long dataPointCount = v1.getDataPointCount() + v2.getDataPointCount();
        if (v1 instanceof LongTimeslicedValue || v2 instanceof LongTimeslicedValue) {
            long value = v1.getValueAsLong() - v2.getValueAsLong();
            long minimum = v1.getMinimumAsLong() - v2.getMinimumAsLong();
            long maximum = v1.getMaximumAsLong() - v2.getMaximumAsLong();
            dataPointCount = this.fixDataPointCount(type, dataPointCount, value);
            result = new LongTimeslicedValue(type, startTimestamp, stopTimestamp, blameStack, dataPointCount, dataIsAbsent, value, minimum, maximum);
        } else {
            int value = (int)v1.getValueAsLong() - (int)v2.getValueAsLong();
            int minimum = (int)v1.getMinimumAsLong() - (int)v2.getMinimumAsLong();
            int maximum = (int)v1.getMaximumAsLong() - (int)v2.getMaximumAsLong();
            dataPointCount = this.fixDataPointCount(type, dataPointCount, value);
            result = new IntegerTimeslicedValue(type, startTimestamp, stopTimestamp, blameStack, dataPointCount, dataIsAbsent, value, minimum, maximum);
        }
        return result;
    }
}

