/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.ACachingImmutableClassMatcher;
import com.wily.diagnos.cmp.directives.utility.CompilerSettingsUtility;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.introscope.api.instrument.DeepInheritanceHelper;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.ClassFileUtilities;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import java.util.HashMap;
import java.util.Map;

public class DGInheritedClassMatcher
extends ACachingImmutableClassMatcher {
    private static final Map<String, DGInheritedClassMatcher> singleton = new HashMap<String, DGInheritedClassMatcher>();
    private final IClassName fClassName;
    private final String fRootClassName;
    private final int fRootClassNameIndex;
    private final boolean shallowMatch;

    private DGInheritedClassMatcher(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (singleton.containsKey(name)) {
            throw new RuntimeException("Instance already created");
        }
        this.fClassName = className;
        this.fRootClassName = this.fClassName.getReflectionFriendlyQualifiedNameString();
        this.fRootClassNameIndex = DeepInheritanceHelper.classNameForest.addAndGetID(this.fRootClassName);
        this.shallowMatch = !DeepInheritanceHelper.onlyDeep;
    }

    public static DGInheritedClassMatcher getInstance(IClassName className) {
        String name = className.getReflectionFriendlyQualifiedNameString();
        if (!singleton.containsKey(name)) {
            singleton.put(name, new DGInheritedClassMatcher(className));
        }
        return singleton.get(name);
    }

    private boolean executeMatches(IModeledClass cls) {
        if (System.getProperty("com.wily.introscope.agent.starter").equals("premain") && System.getProperty("com.wily.introscope.deepInheritance.implementationVersion", "1").equals("1")) {
            if (cls.hasSuperClass() && ClassFileUtilities.looselyMatches((IClassName)this.fClassName, (IClassName)cls.getSuperClassName())) {
                return true;
            }
            return cls.inheritsDirectlyFromInterface(this.fClassName);
        }
        return DeepInheritanceHelper.matchForClass((int)this.fRootClassNameIndex, (IModeledClass)cls, (boolean)this.shallowMatch);
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return false;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        return false;
    }

    public IClassName getClassName() {
        return this.fClassName;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fClassName);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGInheritedClassMatcher) {
            DGInheritedClassMatcher m = (DGInheritedClassMatcher)obj;
            return this.fClassName.equals(m.fClassName);
        }
        return false;
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        boolean result = this.executeMatches(cls);
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setInheritedClassName(this.fClassName);
            current.setSkipCause(4096);
        }
        return result;
    }

    @Override
    public String[] getMatcherKeys() {
        return new String[]{CompilerSettingsUtility.getKeyFromString(this.fClassName.getPackageAndNameString())};
    }
}

