# muleesb (2022.6.0.6)
# Mule Esb Monitoring

## Description
Mule ESB is a lightweight Java-based enterprise service bus (ESB) and integration platform that allows developers to connect applications together quickly and easily, enabling them to exchange data. Mule ESB enables easy integration of existing systems, regardless of the different technologies that the applications use, including JMS, Web Services, JDBC, HTTP, and more. The key advantage of an ESB is that it allows different applications to communicate with each other by acting as a transit system for carrying data between applications within your enterprise or across the Internet.

# Installation Instructions
Mule extension is part of the default agent installer, no additional steps are needed.
## Usage Instructions
The Mule ESB is structured into three main areas driven by defined "Flow" The monitoring solution extension provides visibility into the Transport Layer, Integration Layer and Application Layer visualizing the invocation elements by individual Flows.

          
### Inbound HTTP Traffic

* HTTP Endpoint ( Mule 3.6 and higher) : 
 The monitoring solution aligns with the standard CA APM features and visualizes inbound HTTP traffic via SOAP or Restful Web Services in the Frontend node in the investigator. The Apps metric path item is replaced with the name 
 or identification of the deployed Mule ESB application. The URI section, if not configured different (configuration section) is formatted with the defined URI of the HTTP Listener configuration. 
 'Frontends|Apps|{mule-application-name}' and 
 'Frontends|Apps|{mule-application-name}|URLs|{URI defined in Mule HTTP Listener}'
  		  	
* Mule ESB 3.3.0 HTTP Message Receiver Support : 
  The usage of the deprecated older HTTP Message Receiver is still supported. Metrics are visualized different on this HTTP Message Receiver component. The App node in the metric path is replaced by the receiver name and the URLs path with the 
  initial HTTP listening flow name.
 'Frontends|Apps|{mule-http-receiver-name}' and 
 'Frontends|Apps|{mule-http-receiver-name}|URLs|{mule-flow-name}'
 
* CXF Inbound Web Services : 
  In addition to the inbound http frontend metrics, the mule esb extension also visualizes inbound Web Services calls under the Web Services node in the Investigator. The first part of the custom metric path contains the http request path and the 
  second any available soap action.
  'Webservices|Server|{http-request-path}' and 
  'Webservices|Server|{http-request-path}|{soap-action}'
  		

### Outbound HTTP requests
 For outbound HTTP requests, the monitoring solution leverages the Backends node identical to all other CA APM solutions. HTTP calls are shown with the formatting 'Backends|WebService at {protocol}_//{host}_{port}|Paths|{path}' where the path component is being replaced by the path element of the request URI.In addition to the standard metrics, the Mule monitoring extension creates the metric Async Invocation Time (ms) metric. The Async Invocation Time is computed based on the async communication behaviour for outbound HTTP calls. By measuring the HTTP Response in the request flow, CA APM can measure the time to establish a request (Async Invocation Time) and the total round trip / request - response time for a request (Average Response Time).The Transaction Trace visualization also differs because of the async nature of the requests.		


### HTTP request payload visualization
As a special feature, the monitoring solution visualizes the HTTP payload of all inbound and outbound requests including the response payload. The payload is visualized in the transaction trace on the root component of the correspondent process sending or receiving the call.Besides HTTP traffic monitoring, this solution provides inbound and outbound message processing coverage for all defined endpoints in the Mule Flow. 
   

### Flow Visualization

Flows are the main transactional processes inside the Mule ESB framework. The monitoring solution has a special coverage for Flows with additional metrics making it easier to understand the requests and showing detailed error and analysis 
information.Flows are visualized at the Mule|Flows node.

Flow usage Metrics : 
'Mule|Flows:Active Flow Instances'	- The number of active flow instances. Instances are usually active while in listening mode.
'Mule|Flows:Average Branch Processing Time (ms)' - The average total time spent on the flow for processing. 
'Mule|Flows:Branch Processings Per Interval' -	The number of branches processed for this flow per interval.
