/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.dynamic;

import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.beans.AAgentBeanNameListener;
import com.wily.introscope.agent.beans.AAgentRemoteBean;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.agent.transformer.dynamic.ICodeIntrospectionService;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationService;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.agent.transformer.dynamic.IGroupInstrumentationService;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.AbstractInstrumentationInfo;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.AbstractInstrumentationInfoResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicDirectivesResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicInstrumentationListener;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicInstrumentationResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.GroupInstrumentationInfo;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.GroupInstrumentationInfoResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.IAgentDynamicInstrumentationServiceWithCallbacks;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.IDynamicInstrumentationListener;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.InstrumentationInfo;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.InstrumentationInfoResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.MethodCallsResult;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.BaseDINotification;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.DynamicDirectivesNotification;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.DynamicInstrumentationNotification;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.GroupInstrumentationInfoNotification;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.IBaseDINotification;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.InstrumentationInfoNotification;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.MethodCallsNotification;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.SimpleBaseDINotification;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.callback.Callback;
import com.wily.isengard.messageprimitives.callback.ICallback;
import com.wily.isengard.messageprimitives.pipe.EndpointNotFoundException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.INameChangeListener;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import com.wily.util.task.IExecutableItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class AgentDynamicInstrumentationBean
extends AAgentRemoteBean
implements IAgentDynamicInstrumentationServiceWithCallbacks {
    private static final String kTemporaryInstrumentationPrefix = "Temporary Instrumentation|";
    private static final String TRACER_TYPE_PARAMETER_IS_NOT_VALID = "Tracer Type parameter is not valid";
    private static final String ADDED_BY_DI = " called {method} in {classname} (DI)";
    private static final String METHOD_CALLED_ADDED_BY_DI = " called {method} (DI)";
    private static final String CALLED_IN_CLASSNAME_ADDED_BY_DI = " called in {classname} (DI)";
    private static final String CALLED_ADDED_BY_DI = " called (DI)";
    private static final String DYNAMIC_BLAME_POINT_TRACER = "DynamicBlamePointTracer";
    private static final String CANNOT_ACCESS_CLASS_REPOSITORY = "Cannot access class repository";
    private static final String AGENT_INSTRUMENTATION_TRANSFORMER_OR_ITS_SERVICER_ARE_NOT_SET = "Agent Instrumentation Transformer or its servicer are not set";
    private static final String INVALID_METHOD_NAME_IN_DYNAMIC_INTRUMENTATION_REQUEST = "Invalid method name in dynamic intrumentation request: ";
    private static final String INVALID_CLASS_NAME_IN_DYNAMIC_INTRUMENTATION_REQUEST = "Invalid class name in dynamic intrumentation request: ";
    private static final String AGENT_DYNAMIC_INSTRUMENTATION_PROPERTY_IS_NOT_SET_OR_IS_SET_TO_FALSE = "Agent dynamic instrumentation property is not set or is set to false";
    private static final String AGENT_IS_BUSY = "Agent is busy";
    private static final String NOT_IMPLEMENTED = "Not implemented";
    private static final String DYNAMIC_INSTRUMENTATION_NOT_AVAIILABLE_JAVA_14 = "Agent is running in a Java environment that does not support DynamicInstrumentation";
    private static final String kRemoteAgentDynamicInstrumentationEnabledKey = "introscope.agent.remoteagentdynamicinstrumentation.enabled";
    private static final String kRemoteAgentDynamicInstrumentationStrictMethodCallsKey = "introscope.agent.remoteagentdynamicinstrumentation.strictMethodCalls";
    private static final String kRemoteAgentDynamicInstrumentationStrictMethodKey = "introscope.agent.remoteagentdynamicinstrumentation.strictMethod";
    private static final boolean kDefaultRemoteAgentDynamicInstrumentationEnabled = true;
    private static final boolean fIsInstrumentationAvailable;
    private static final boolean fIsPerformanceDebugEnabled;
    private static final Module kModule;
    private static final Module kPerformanceModule;
    private static final int kMaxOpenListeners = 500;
    private static volatile IntervalHeartbeat kTempInstrumentationHeartbeat;
    private LinkedList fListeners = new LinkedList();
    private static ThreadLocal kBusyReentrancy;

    static {
        kModule = new Module("DynamicInstrumentation");
        kPerformanceModule = new Module("DynamicInstrumentation.Performance");
        boolean value = false;
        try {
            Class<?> c = Class.forName("java.lang.instrument.Instrumentation");
            value = c != null;
        }
        catch (Throwable throwable) {
            value = false;
        }
        fIsInstrumentationAvailable = value;
        fIsPerformanceDebugEnabled = System.getProperty("introscope.agent.remoteagentdynamicinstrumentation.performancedata.enabled") != null;
        kBusyReentrancy = new ThreadLocal(){

            protected Object initialValue() {
                return 0;
            }
        };
    }

    private InstrumentationInfoResult getScaffolding(String verboseCause) {
        InstrumentationInfoResult result = new InstrumentationInfoResult();
        result.setStatus(0);
        result.setVerboseCause(verboseCause);
        return result;
    }

    private boolean isInstrumentationAvailable() {
        return fIsInstrumentationAvailable;
    }

    protected boolean getDefaultRemoteAgentDynamicIntrumentationEnabled() {
        return true;
    }

    protected String getRemoteAgentDynamicIntrumentationEnabledKey() {
        return kRemoteAgentDynamicInstrumentationEnabledKey;
    }

    protected Class getServiceClass() {
        return IAgentDynamicInstrumentationServiceWithCallbacks.class;
    }

    private DynamicDirectivesResult getDatabaseDirectivesResult(DynamicInstrumentationResult input) {
        if (input != null) {
            if (input instanceof DynamicDirectivesResult) {
                return (DynamicDirectivesResult)input;
            }
            DynamicDirectivesResult result = new DynamicDirectivesResult();
            result.importAll(input);
            return result;
        }
        return null;
    }

    private InstrumentationInfoResult getInstrumentationInfoResult(DynamicInstrumentationResult input) {
        if (input != null) {
            if (input instanceof InstrumentationInfoResult) {
                return (InstrumentationInfoResult)input;
            }
            InstrumentationInfoResult result = new InstrumentationInfoResult();
            result.importAll(input);
            return result;
        }
        return null;
    }

    private GroupInstrumentationInfoResult getGroupInstrumentationInfoResult(DynamicInstrumentationResult input) {
        if (input != null) {
            if (input instanceof GroupInstrumentationInfoResult) {
                return (GroupInstrumentationInfoResult)input;
            }
            GroupInstrumentationInfoResult result = new GroupInstrumentationInfoResult();
            result.importAll(input);
            return result;
        }
        return null;
    }

    private MethodCallsResult getMethodCallsResult(DynamicInstrumentationResult input) {
        if (input != null) {
            if (input instanceof MethodCallsResult) {
                return (MethodCallsResult)input;
            }
            MethodCallsResult result = new MethodCallsResult();
            result.importAll(input);
            return result;
        }
        return null;
    }

    private InstrumentationInfoResult synchronizePermanentResult(InstrumentationInfoResult input) {
        InstrumentationInfoResult result = input;
        if (!input.isError()) {
            try {
                this.synchronizePermanent((AbstractInstrumentationInfoResult)input);
            }
            catch (IOException e) {
                result = new InstrumentationInfoResult(100);
                result.setException((Throwable)e);
            }
        }
        return result;
    }

    private GroupInstrumentationInfoResult synchronizePermanentResult(GroupInstrumentationInfoResult input) {
        GroupInstrumentationInfoResult result = input;
        if (!input.isError()) {
            try {
                this.synchronizePermanent((AbstractInstrumentationInfoResult)input);
            }
            catch (IOException e) {
                result = new GroupInstrumentationInfoResult(100);
                result.setException((Throwable)e);
            }
        }
        return result;
    }

    private DynamicInstrumentationResult checkAndExecute(ExecuteInstrumentation execute) {
        return this.checkAndExecute(execute, false, false);
    }

    private DynamicInstrumentationResult checkAndExecute(ExecuteInstrumentation execute, boolean acceptUnknownStatus, boolean acceptBusyStatus) {
        if (this.isInstrumentationAvailable()) {
            if (this.isEnabled()) {
                boolean isNotBusy = this.isNotBusy(acceptUnknownStatus);
                isNotBusy = isNotBusy || acceptBusyStatus;
                try {
                    if (isNotBusy) {
                        DynamicInstrumentationResult dynamicInstrumentationResult = execute.execute();
                        return dynamicInstrumentationResult;
                    }
                    DynamicInstrumentationResult dynamicInstrumentationResult = new DynamicInstrumentationResult(115).setVerboseCause(AGENT_IS_BUSY);
                    return dynamicInstrumentationResult;
                }
                finally {
                    this.decreaseBusy();
                }
            }
            return new DynamicInstrumentationResult(112).setVerboseCause(AGENT_DYNAMIC_INSTRUMENTATION_PROPERTY_IS_NOT_SET_OR_IS_SET_TO_FALSE);
        }
        return new DynamicInstrumentationResult(112).setVerboseCause(DYNAMIC_INSTRUMENTATION_NOT_AVAIILABLE_JAVA_14);
    }

    private DynamicInstrumentationResult checkLabelAndExecute(String label, ExecuteInstrumentation execute) {
        return this.checkLabelAndExecute(label, execute, false);
    }

    private DynamicInstrumentationResult checkLabelAndExecute(String label, ExecuteInstrumentation execute, boolean acceptBusyStatus) {
        if (label == null) {
            DynamicInstrumentationResult result = new DynamicInstrumentationResult(114);
            result.setVerboseCause("Label is null");
            return result;
        }
        if (label.equals("")) {
            DynamicInstrumentationResult result = new DynamicInstrumentationResult(114);
            result.setVerboseCause("Label is empty");
            return result;
        }
        return this.checkAndExecute(execute, false, acceptBusyStatus);
    }

    private DynamicInstrumentationResult checkClassNameAndExecute(String classPattern, String methodPattern, String callingClassPattern, String callingMethodPattern, String tracerType, ExecuteInstrumentationWithClassNames execute) {
        if (this.isInstrumentationAvailable()) {
            if (this.isEnabled()) {
                boolean isNotBusy = this.isNotBusy(false);
                try {
                    if (isNotBusy) {
                        boolean tracerIsOk = this.checkTracerType(tracerType);
                        if (tracerIsOk) {
                            IClassRedefinitionDelegate.IRedefinedClassRepository rep = this.getDynamicInstrumentationTransformer().getClasses();
                            ICodeIntrospectionService.ClassMethodName names = this.getCodeIntrospectionService().getClassMethodName(rep, classPattern, methodPattern);
                            if (names.isError()) {
                                DynamicInstrumentationResult result = new DynamicInstrumentationResult(108);
                                result.setException(names.getException()).setVerboseCause(names.getVerbose());
                                DynamicInstrumentationResult dynamicInstrumentationResult = result;
                                return dynamicInstrumentationResult;
                            }
                            ICodeIntrospectionService.ClassMethodName callingNames = this.getCodeIntrospectionService().getClassMethodName(rep, callingClassPattern, callingMethodPattern);
                            if (callingNames.isError()) {
                                DynamicInstrumentationResult result = new DynamicInstrumentationResult(108);
                                result.setException(callingNames.getException()).setVerboseCause(callingNames.getVerbose());
                                DynamicInstrumentationResult dynamicInstrumentationResult = result;
                                return dynamicInstrumentationResult;
                            }
                            DynamicInstrumentationResult dynamicInstrumentationResult = execute.execute(names, callingNames);
                            return dynamicInstrumentationResult;
                        }
                        DynamicInstrumentationResult dynamicInstrumentationResult = new DynamicInstrumentationResult(114).setVerboseCause(TRACER_TYPE_PARAMETER_IS_NOT_VALID);
                        return dynamicInstrumentationResult;
                    }
                    DynamicInstrumentationResult dynamicInstrumentationResult = new DynamicInstrumentationResult(115).setVerboseCause(AGENT_IS_BUSY);
                    return dynamicInstrumentationResult;
                }
                finally {
                    this.decreaseBusy();
                }
            }
            return new DynamicInstrumentationResult(112).setVerboseCause(AGENT_DYNAMIC_INSTRUMENTATION_PROPERTY_IS_NOT_SET_OR_IS_SET_TO_FALSE);
        }
        return new DynamicInstrumentationResult(112).setVerboseCause(DYNAMIC_INSTRUMENTATION_NOT_AVAIILABLE_JAVA_14);
    }

    private boolean checkTracerType(String tracerType) {
        return tracerType == null || tracerType != null && tracerType.equals(DYNAMIC_BLAME_POINT_TRACER);
    }

    private DynamicInstrumentationResult checkClassNameAndLabelAndExecute(String label, String classPattern, String methodPattern, String callingClassPattern, String callingMethodPattern, String tracerType, ExecuteInstrumentationWithClassNames execute) {
        if (label == null) {
            DynamicInstrumentationResult result = new DynamicInstrumentationResult(114);
            result.setVerboseCause("Label is null");
            return result;
        }
        if (label.equals("")) {
            DynamicInstrumentationResult result = new DynamicInstrumentationResult(114);
            result.setVerboseCause("Label is empty");
            return result;
        }
        return this.checkClassNameAndExecute(classPattern, methodPattern, callingClassPattern, callingMethodPattern, tracerType, execute);
    }

    private IDynamicInstrumentationService getDynamicInstrumentationService() {
        IDynamicInstrumentationService result;
        IDynamicInstrumentationTransformer dit = this.getDynamicInstrumentationTransformer();
        if (dit != null && (result = dit.getDynamicInstrumentationService()) != null) {
            return result;
        }
        return (IDynamicInstrumentationService)Proxy.newProxyInstance(AgentDynamicInstrumentationBean.class.getClassLoader(), new Class[]{IDynamicInstrumentationService.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object arg0, Method arg1, Object[] arg2) throws Throwable {
                return new DynamicInstrumentationResult(106).setVerboseCause(AgentDynamicInstrumentationBean.AGENT_INSTRUMENTATION_TRANSFORMER_OR_ITS_SERVICER_ARE_NOT_SET);
            }
        });
    }

    private IDynamicInstrumentationTransformer getDynamicInstrumentationTransformer() {
        TransformerAdministrator tAdm = this.getAgent().IAgent_getTransformerAdministrator();
        IDynamicInstrumentationTransformer dit = tAdm.getDynamicInstrumentationTransformer();
        return dit;
    }

    private IGroupInstrumentationService getGroupInstrumentationService() {
        IDynamicInstrumentationTransformer dit = this.getDynamicInstrumentationTransformer();
        if (dit != null && dit instanceof IGroupInstrumentationService) {
            return (IGroupInstrumentationService)dit;
        }
        return (IGroupInstrumentationService)Proxy.newProxyInstance(AgentDynamicInstrumentationBean.class.getClassLoader(), new Class[]{IGroupInstrumentationService.class}, new InvocationHandler(){
            private HashMap map = new HashMap();

            @Override
            public Object invoke(Object arg0, Method arg1, Object[] arg2) throws Throwable {
                return this.map;
            }
        });
    }

    private IModuleFeedbackChannel getLog() {
        return this.getAgent().IAgent_getModuleFeedback();
    }

    private boolean isEnabled() {
        IAgent agent = this.getAgent();
        boolean isEnabled = agent.IAgent_getIndexedProperties().safeGetBooleanProperty(kRemoteAgentDynamicInstrumentationEnabledKey, false, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        return isEnabled;
    }

    public InstrumentationInfoResult addTemporaryInstrumentation(final String methodPattern, final String classPattern, final String resourceName) {
        return (InstrumentationInfoResult)new ExecuteTemporary(this){
            InstrumentationInfoResult resultOfInstrumentation;

            @Override
            DynamicInstrumentationResult execute() {
                this.resultOfInstrumentation = this.addInstrumentation(methodPattern, classPattern, resourceName, 1);
                return this.resultOfInstrumentation;
            }

            @Override
            void rollback() {
                if (this.resultOfInstrumentation != null && !this.resultOfInstrumentation.isError()) {
                    for (InstrumentationInfo info : this.resultOfInstrumentation.getInstrumentationInfos()) {
                        this.removeInstrumentationByLineNumber(info);
                    }
                }
            }
        }.executeTemporary(this);
    }

    public InstrumentationInfoResult addInstrumentation(String methodPattern, String classPattern, String resourceName) {
        return this.addInstrumentation(methodPattern, classPattern, resourceName, 2);
    }

    private InstrumentationInfoResult addInstrumentation(final String methodPattern, final String classPatterns, final String resourceName, final int status) {
        final String actualClassPattern = this.getActualClassWithMethod(classPatterns, methodPattern);
        return this.getInstrumentationInfoResult(this.checkClassNameAndExecute(actualClassPattern, methodPattern, null, null, null, new ExecuteInstrumentationWithClassNames(){

            @Override
            public DynamicInstrumentationResult execute(ICodeIntrospectionService.ClassMethodName names, ICodeIntrospectionService.ClassMethodName callingNames) {
                InstrumentationInfoResult resultOfMethodInfo = new InstrumentationInfoResult(0);
                InstrumentationInfoResult intrumentationForCallingMethod = AgentDynamicInstrumentationBean.this.getInstrumentationInfo(methodPattern, actualClassPattern);
                List infos = intrumentationForCallingMethod.getInstrumentationInfoByResourceName(resourceName);
                String parentGroupName = null;
                String labelName = "";
                String parentTracerType = null;
                String parentResourceName = resourceName;
                InstrumentationInfo parentInfo = null;
                if (infos.size() == 1) {
                    parentInfo = (InstrumentationInfo)infos.get(0);
                    parentGroupName = parentInfo.getGroupName();
                    labelName = parentInfo.getLabelName();
                    parentTracerType = parentInfo.getTracerType();
                }
                if (parentGroupName == null || parentGroupName.equals("")) {
                    parentGroupName = "Dynamic";
                }
                if (labelName == null || labelName.equals("") || labelName.equals("Undefined")) {
                    labelName = AgentDynamicInstrumentationBean.this.getTemporaryLabel();
                }
                if (parentResourceName == null) {
                    parentResourceName = "";
                }
                String childTracerType = this.getDynamicChildType(parentTracerType);
                String newResourceName = this.getResourceName(parentResourceName);
                if (status == 1 && !newResourceName.startsWith(AgentDynamicInstrumentationBean.kTemporaryInstrumentationPrefix)) {
                    newResourceName = AgentDynamicInstrumentationBean.kTemporaryInstrumentationPrefix + newResourceName;
                }
                MethodCallsResult methodCalls = AgentDynamicInstrumentationBean.this.getMethodCalls(methodPattern, classPatterns);
                for (DynamicInstrumentationResult.ClassMethodPair pair : methodCalls.getMethodCalls()) {
                    String className;
                    String methodName = pair.getMethodSignature();
                    InstrumentationInfoResult addInstrumentationResult = AgentDynamicInstrumentationBean.this.addInstrumentation(methodName, className = pair.getClassName(), methodPattern, actualClassPattern, newResourceName, childTracerType, parentGroupName, labelName, status);
                    if (addInstrumentationResult.isError()) continue;
                    resultOfMethodInfo.addIntrumentationInfo(addInstrumentationResult.getInstrumentationInfos());
                }
                return resultOfMethodInfo;
            }

            private String getResourceName(String resourceName2) {
                boolean hasClass = resourceName2.indexOf("{classname}") >= 0;
                boolean hasMethod = resourceName2.indexOf("{method}") >= 0;
                String formatter = this.getFormatter(hasClass, hasMethod);
                return String.valueOf(resourceName2) + formatter;
            }

            private String getFormatter(boolean hasClass, boolean hasMethod) {
                if (hasMethod && hasClass) {
                    return AgentDynamicInstrumentationBean.CALLED_ADDED_BY_DI;
                }
                if (hasMethod) {
                    return AgentDynamicInstrumentationBean.CALLED_IN_CLASSNAME_ADDED_BY_DI;
                }
                if (hasClass) {
                    return AgentDynamicInstrumentationBean.METHOD_CALLED_ADDED_BY_DI;
                }
                return AgentDynamicInstrumentationBean.ADDED_BY_DI;
            }

            private String getDynamicChildType(String tracerType) {
                return AgentDynamicInstrumentationBean.DYNAMIC_BLAME_POINT_TRACER;
            }
        }));
    }

    public InstrumentationInfoResult addTemporaryInstrumentation(final String methodPattern, final String classPattern, final String resourceName, final String tracerType, final String groupName) {
        return this.getInstrumentationInfoResult(new ExecuteTemporary(this){
            InstrumentationInfoResult resultOfInstrumentation;

            @Override
            DynamicInstrumentationResult execute() {
                this.resultOfInstrumentation = this.addInstrumentation(methodPattern, classPattern, null, null, resourceName, tracerType, groupName, 1);
                return this.resultOfInstrumentation;
            }

            @Override
            void rollback() {
                if (!this.resultOfInstrumentation.isError()) {
                    InstrumentationInfo info = (InstrumentationInfo)this.resultOfInstrumentation.getInstrumentationInfos().get(0);
                    this.removeInstrumentationByLineNumber(info);
                }
            }
        }.executeTemporary(this));
    }

    public InstrumentationInfoResult addInstrumentation(String methodPattern, String classPattern, String resourceName, String tracerType, String groupName) {
        return this.addInstrumentation(methodPattern, classPattern, null, null, resourceName, tracerType, groupName, 2);
    }

    private InstrumentationInfoResult addInstrumentation(String methodPattern, String classPattern, String callingMethodPattern, String callingClassPattern, final String resourceName, final String tracerType, final String groupName, final int status) {
        String actualClassPattern = this.getActualClassWithMethod(callingClassPattern, callingMethodPattern);
        return this.getInstrumentationInfoResult(this.checkClassNameAndExecute(classPattern, methodPattern, actualClassPattern, callingMethodPattern, tracerType, new ExecuteInstrumentationWithClassNames(){

            @Override
            public DynamicInstrumentationResult execute(ICodeIntrospectionService.ClassMethodName names, ICodeIntrospectionService.ClassMethodName callingNames) {
                boolean isConditional = callingNames.getClassName() != null;
                boolean isInheriting = names.isInterface() || names.isAbstractMethod();
                int tracerDirectiveType = AgentDynamicInstrumentationBean.this.getDirectiveType(isConditional, isInheriting);
                return AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().addInstrumentation(names.getClassName(), names.getMethodName(), resourceName, tracerType, groupName, status, tracerDirectiveType, callingNames.getClassName(), callingNames.getMethodName());
            }
        }));
    }

    public InstrumentationInfoResult addInstrumentation(String callingMethodPattern, String callingClassPattern, String methodPattern, String classPattern, String resourceName, String tracerType, String groupName) {
        return this.addInstrumentation(methodPattern, classPattern, callingMethodPattern, callingClassPattern, resourceName, tracerType, groupName, 2);
    }

    public InstrumentationInfoResult addTemporaryInstrumentation(final String callingMethodPattern, final String callingClassPattern, final String methodPattern, final String classPattern, final String resourceName, final String tracerType, final String groupName) {
        return this.getInstrumentationInfoResult(new ExecuteTemporary(this){
            InstrumentationInfoResult resultOfInstrumentation;

            @Override
            DynamicInstrumentationResult execute() {
                this.resultOfInstrumentation = this.addInstrumentation(methodPattern, classPattern, callingMethodPattern, callingClassPattern, resourceName, tracerType, groupName, 1);
                return this.resultOfInstrumentation;
            }

            @Override
            void rollback() {
                if (!this.resultOfInstrumentation.isError()) {
                    InstrumentationInfo info = (InstrumentationInfo)this.resultOfInstrumentation.getInstrumentationInfos().get(0);
                    this.removeInstrumentationByLineNumber(info);
                }
            }
        }.executeTemporary(this));
    }

    public void exportInstrumentation(final IDynamicInstrumentationListener listener) {
        this.checkAndExecute(new ExecuteInstrumentationWithCallback(){

            @Override
            public void executeWithCallbacks() {
                boolean executeForPermanentOnly = true;
                AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().getDynamicInstrumentationPBD(listener, null, executeForPermanentOnly);
            }

            @Override
            public DynamicInstrumentationResult execute() {
                this.executeWithCallbacks();
                return null;
            }
        });
    }

    public Callback getAvailableTracerTypes(DynamicInstrumentationNotification callback, String methodPattern, String classPattern) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("getAvailableTracerTypes", methodPattern, classPattern);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                DynamicInstrumentationResult result = this.checkAndExecute(new ExecuteInstrumentation(){

                    @Override
                    public DynamicInstrumentationResult execute() {
                        DynamicInstrumentationResult result = new DynamicInstrumentationResult(0);
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(AgentDynamicInstrumentationBean.DYNAMIC_BLAME_POINT_TRACER);
                        result.setAvailableTracers(list);
                        return result;
                    }
                });
                listener.deliverResult(result);
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback getClasses(DynamicInstrumentationNotification callback, final String packagePattern) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("getClasses", packagePattern);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                DynamicInstrumentationResult result = this.checkAndExecute(new ExecuteInstrumentation(){

                    @Override
                    public DynamicInstrumentationResult execute() {
                        TreeSet classes = new TreeSet();
                        this.getCodeIntrospectionService().getClasses(packagePattern, classes);
                        DynamicInstrumentationResult result = new DynamicInstrumentationResult(0);
                        result.setCodeCollection(classes);
                        return result;
                    }
                });
                listener.deliverResult(result);
            }
        }.execute((BaseDINotification)callback);
    }

    public DynamicInstrumentationResult getDynamicInstrumentationStatus() {
        return this.checkAndExecute(new ExecuteInstrumentation(){

            @Override
            public DynamicInstrumentationResult execute() {
                DynamicInstrumentationResult result = AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().isActive();
                return result;
            }
        });
    }

    public GroupInstrumentationInfoResult getGroups() {
        GroupInstrumentationInfoResult databaseResult = this.getGroupInstrumentationInfoResult(this.checkAndExecute(new ExecuteInstrumentation(){

            @Override
            public DynamicInstrumentationResult execute() {
                return AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().getGroupsDirectives();
            }
        }));
        if (!databaseResult.isError()) {
            this.updateWithStaticInformation(databaseResult, true);
        }
        return databaseResult;
    }

    private void updateWithStaticInformation(GroupInstrumentationInfoResult databaseResult, boolean addAllStaticInfo) {
        Map databaseDirectives = databaseResult.getIntrumentationInfo();
        Map staticGroups = this.getGroupInstrumentationService().getStaticGroups();
        for (Map.Entry entry : staticGroups.entrySet()) {
            TracerGroup group = (TracerGroup)entry.getKey();
            String groupName = group.getName().getName();
            boolean isStaticActive = group.isEnabled();
            Boolean isChangeable = (Boolean)entry.getValue();
            isChangeable = isChangeable != false && !isStaticActive;
            GroupInstrumentationInfo info = (GroupInstrumentationInfo)databaseDirectives.get(groupName);
            boolean isStaticLockedDisabled = group.isLockedDisabled();
            if (info == null && addAllStaticInfo) {
                databaseResult.addGroupIntrumentationInfo(0, groupName, isStaticActive, isStaticActive, true, "Static", isChangeable.booleanValue(), true);
                continue;
            }
            if (info == null) continue;
            if (isStaticLockedDisabled) {
                info.setStaticActive(false);
                info.setActive(false);
            } else if (!(info.hasPermanentInstrumentation() || info.isPermanent() || info.hasPermanentGroupInstrumentation())) {
                info.setStaticActive(isStaticActive);
            }
            info.setPermanent(true);
            info.setTemporary(false);
            info.setCanBeToggled(isChangeable.booleanValue());
            info.setLabelName("Static");
        }
    }

    public GroupInstrumentationInfoResult saveGroups() {
        return this.synchronizePermanentResult(this.getGroupInstrumentationInfoResult(this.checkAndExecute(new ExecuteInstrumentation(){

            @Override
            public DynamicInstrumentationResult execute() {
                return AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().makePermanentGroupDirectives();
            }
        })));
    }

    GroupInstrumentationInfoResult setGroupEnabledStatus(final String groupName, final Boolean isEnabled) {
        return this.synchronizePermanentResult(this.getGroupInstrumentationInfoResult(this.checkAndExecute(new ExecuteInstrumentation(){

            @Override
            public DynamicInstrumentationResult execute() {
                return AgentDynamicInstrumentationBean.this.executeSetGroupDirective(groupName, isEnabled, 2);
            }
        })));
    }

    public InstrumentationInfoResult getInstrumentationInfo(String methodPattern, String classPattern) {
        return this.getInstrumentationInfoResult(this.checkClassNameAndExecute(classPattern, methodPattern, null, null, null, new ExecuteInstrumentationWithClassNames(){

            @Override
            public DynamicInstrumentationResult execute(ICodeIntrospectionService.ClassMethodName names, ICodeIntrospectionService.ClassMethodName callingNames) {
                return AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().getInstrumentationInfo(names.getClassName(), names.getMethodName(), false);
            }
        }));
    }

    public InstrumentationInfoResult getInstrumentationInfo(String groupName) {
        return this.getScaffolding("Scaffolded getInstrumentationInfo(final String groupName)");
    }

    public InstrumentationInfoResult getInstrumentationInfo() {
        return this.getScaffolding("Scaffolded getInstrumentationInfo()");
    }

    public MethodCallsResult getMethodCalls(final String resourceName) {
        return this.getMethodCallsResult(this.checkAndExecute(new ExecuteInstrumentation(){

            @Override
            public DynamicInstrumentationResult execute() {
                return AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().getMethodCalls(resourceName);
            }
        }));
    }

    public MethodCallsResult getMethodCalls(String methodPattern, String classPattern) {
        Collection methodCalls;
        String actualClassPattern = this.getCodeIntrospectionService().findClassWithMethod(classPattern, methodPattern);
        MethodCallsResult result = this.getMethodCallsResult(this.checkClassNameAndExecute(actualClassPattern, methodPattern, null, null, null, new ExecuteInstrumentationWithClassNames(){

            @Override
            public DynamicInstrumentationResult execute(ICodeIntrospectionService.ClassMethodName names, ICodeIntrospectionService.ClassMethodName callingNames) {
                return AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().getMethodCalls(names.getClassName(), names.getMethodName());
            }
        }));
        if (!result.isError() && (methodCalls = result.getMethodCalls()) != null) {
            this.getCodeIntrospectionService().filterMethodCallsForInstrumentation(classPattern, methodCalls);
            result.setActualClassImplementingMethod(actualClassPattern);
            result.setRequestedClassName(classPattern);
        }
        return result;
    }

    public DynamicInstrumentationResult getMethods(final String classPattern) {
        return this.checkAndExecute(new ExecuteInstrumentation(){

            @Override
            public DynamicInstrumentationResult execute() {
                TreeSet methodClassPairs = new TreeSet();
                AgentDynamicInstrumentationBean.this.getCodeIntrospectionService().getMethods(classPattern, methodClassPairs);
                TreeSet<DynamicInstrumentationResult.SimpleClassMethodPair> simpleMethodClassPairs = new TreeSet<DynamicInstrumentationResult.SimpleClassMethodPair>();
                for (DynamicInstrumentationResult.ClassMethodPair pair : methodClassPairs) {
                    simpleMethodClassPairs.add(new DynamicInstrumentationResult.SimpleClassMethodPair(pair.getClassName(), pair.getMethodSignature()));
                }
                DynamicInstrumentationResult result = new DynamicInstrumentationResult(0);
                result.setCodeCollection(simpleMethodClassPairs);
                return result;
            }
        });
    }

    public DynamicInstrumentationResult getPackagesOrAssemblies() {
        return this.checkAndExecute(new ExecuteInstrumentation(){

            @Override
            public DynamicInstrumentationResult execute() {
                TreeSet packages = new TreeSet();
                AgentDynamicInstrumentationBean.this.getCodeIntrospectionService().getPackagesOrAssemblies(packages);
                DynamicInstrumentationResult result = new DynamicInstrumentationResult(0);
                result.setCodeCollection(packages);
                return result;
            }
        });
    }

    public InstrumentationInfoResult removeInstrumentation(String methodPattern, String classPattern, final String resourceName, final String tracerType, final String groupName) {
        return this.synchronizePermanentResult(this.getInstrumentationInfoResult(this.checkClassNameAndExecute(classPattern, methodPattern, null, null, null, new ExecuteInstrumentationWithClassNames(){

            @Override
            public DynamicInstrumentationResult execute(ICodeIntrospectionService.ClassMethodName names, ICodeIntrospectionService.ClassMethodName callingNames) {
                boolean redefineTree = true;
                return AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().removeInstrumentation(names.getClassName(), names.getMethodName(), resourceName, tracerType, groupName, redefineTree);
            }
        })));
    }

    private InstrumentationInfoResult removeTemporaryInstrumentation(final int lineNumber, final IClassName className, final IMethodName methodName) {
        return this.synchronizePermanentResult(this.getInstrumentationInfoResult(this.checkAndExecute(new ExecuteInstrumentation(){

            @Override
            public DynamicInstrumentationResult execute() {
                return AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().removeTemporaryInstrumentation(lineNumber, className, methodName);
            }
        })));
    }

    protected INameChangeListener createChangeListener() {
        return new AAgentBeanNameListener(this, this.getServiceClass()){

            public void INameChangeListener_nameChanged(String newName) {
                this.executeOnNameChanged(newName);
                AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().setRepositoryName(newName);
            }
        };
    }

    public InstrumentationInfoResult addTemporaryInstrumentation(final String methodPattern, final String classPattern, final String resourceName, final String tracerType, final String groupName, final String labelName) {
        return this.getInstrumentationInfoResult(new ExecuteTemporary(this){
            InstrumentationInfoResult resultOfInstrumentation;

            @Override
            DynamicInstrumentationResult execute() {
                this.resultOfInstrumentation = this.addInstrumentation(methodPattern, classPattern, null, null, resourceName, tracerType, groupName, labelName, 1);
                return this.resultOfInstrumentation;
            }

            @Override
            void rollback() {
                if (!this.resultOfInstrumentation.isError()) {
                    InstrumentationInfo info = (InstrumentationInfo)this.resultOfInstrumentation.getInstrumentationInfos().get(0);
                    this.removeInstrumentationByLineNumber(info);
                }
            }
        }.executeTemporary(this));
    }

    public InstrumentationInfoResult addInstrumentation(String methodPattern, String classPattern, String resourceName, String tracerType, String groupName, String labelName) {
        return this.addInstrumentation(methodPattern, classPattern, null, null, resourceName, tracerType, groupName, labelName, 2);
    }

    private InstrumentationInfoResult addInstrumentation(String methodPattern, String classPattern, String callingMethodPattern, String callingClassPattern, final String resourceName, final String tracerType, final String groupName, final String labelName, final int status) {
        String actualClassPattern = this.getActualClassWithMethod(callingClassPattern, callingMethodPattern);
        return this.getInstrumentationInfoResult(this.checkClassNameAndLabelAndExecute(labelName, classPattern, methodPattern, actualClassPattern, callingMethodPattern, tracerType, new ExecuteInstrumentationWithClassNames(){

            @Override
            public DynamicInstrumentationResult execute(ICodeIntrospectionService.ClassMethodName names, ICodeIntrospectionService.ClassMethodName callingNames) {
                boolean isConditional = callingNames.getClassName() != null;
                boolean isInheriting = names.isInterface() || names.isAbstractMethod();
                int tracerDirectiveType = AgentDynamicInstrumentationBean.this.getDirectiveType(isConditional, isInheriting);
                return AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().addInstrumentation(names.getClassName(), names.getMethodName(), labelName, resourceName, tracerType, groupName, status, tracerDirectiveType, callingNames.getClassName(), callingNames.getMethodName());
            }
        }));
    }

    public InstrumentationInfoResult assignLabel(String methodPattern, String classPattern, final String labelName, final String resourceName, final String tracerType, final String groupName) {
        return this.synchronizePermanentResult(this.getInstrumentationInfoResult(this.checkClassNameAndLabelAndExecute(labelName, classPattern, methodPattern, null, null, tracerType, new ExecuteInstrumentationWithClassNames(){

            @Override
            public DynamicInstrumentationResult execute(ICodeIntrospectionService.ClassMethodName names, ICodeIntrospectionService.ClassMethodName callingNames) {
                return AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().assignLabel(names.getClassName(), names.getMethodName(), labelName, resourceName, tracerType, groupName);
            }
        })));
    }

    private void synchronizePermanent(AbstractInstrumentationInfoResult result) throws IOException {
        IDynamicInstrumentationTransformer dit;
        if (!result.isError() && (dit = this.getDynamicInstrumentationTransformer()) != null) {
            HashSet<String> labelsInvolved = new HashSet<String>();
            List infos = result.getInstrumentationInfos();
            for (AbstractInstrumentationInfo info : infos) {
                String label = info.getLabelName();
                if (label == null) continue;
                labelsInvolved.add(label);
            }
            for (String label : labelsInvolved) {
                try {
                    DynamicInstrumentationListener listener = new DynamicInstrumentationListener(this.getLog(), kModule, this.getPostOffice(), (BaseDINotification)new SimpleBaseDINotification(new ExportInstrumentationBaseDINotification(label){

                        @Override
                        public void doWithResult(DynamicDirectivesResult result) {
                            try {
                                AgentDynamicInstrumentationBean.this.synchronizeToFile(this.getLabel(), result.getPbdLines());
                            }
                            catch (IOException iOException) {
                                AgentDynamicInstrumentationBean.this.getLog().error(kModule, "Unexpected input/output error when updating pbd files for dynamic instrumentation");
                                AgentDynamicInstrumentationBean.this.getLog().debug(kModule, "Unexpected input/output error when updating pbd files for dynamic instrumentation");
                            }
                        }
                    }){});
                    dit.getDynamicInstrumentationPBD((IDynamicInstrumentationListener)listener, label, true);
                }
                catch (EndpointNotFoundException endpointNotFoundException) {}
            }
        }
    }

    private void synchronizeToFile(String label, List pbdLines) throws IOException {
        String codePage = this.getCodePage();
        String agentConfigRootDir = new File(this.getAgent().IAgent_getConfigurationResource().IResource_getLocation()).getParent();
        String labelFileName = this.safeName(label);
        String destinationFileName = String.valueOf(agentConfigRootDir) + File.separator + "dynamic" + File.separator + labelFileName + ".pbd";
        if (pbdLines.size() > 0) {
            File newOne;
            this.checkExistDirectory(String.valueOf(agentConfigRootDir) + File.separator + "dynamic");
            String destinationTemporaryFileName = String.valueOf(agentConfigRootDir) + File.separator + "dynamic" + File.separator + labelFileName + ".pbd.new";
            if (!new File(new File(destinationTemporaryFileName).getParent()).exists()) {
                new File(new File(destinationTemporaryFileName).getParent()).mkdir();
            }
            OutputStreamWriter codedWriter = codePage == null ? new OutputStreamWriter(new FileOutputStream(destinationTemporaryFileName)) : new OutputStreamWriter((OutputStream)new FileOutputStream(destinationTemporaryFileName), codePage);
            BufferedWriter bw = new BufferedWriter(codedWriter);
            Iterator i = pbdLines.iterator();
            while (i.hasNext()) {
                bw.write((String)i.next());
                bw.newLine();
            }
            bw.flush();
            bw.close();
            File original = new File(destinationFileName);
            if (original.exists() && original.canWrite()) {
                original.delete();
            }
            if ((newOne = new File(destinationTemporaryFileName)).exists() && newOne.canWrite()) {
                newOne.renameTo(original);
            }
        } else {
            File original = new File(destinationFileName);
            if (original.exists() && original.canWrite()) {
                original.delete();
            }
        }
    }

    private String getCodePage() {
        String platform_ebcdic = "false";
        platform_ebcdic = System.getProperty("platform.notASCII");
        if (platform_ebcdic != null && platform_ebcdic.equals("true")) {
            String ibmSystemEncoding = System.getProperty("ibm.system.encoding");
            return ibmSystemEncoding;
        }
        return null;
    }

    private void checkExistDirectory(String directory) {
    }

    public DynamicDirectivesResult exportInstrumentation(final IDynamicInstrumentationListener listener, final String labelName) {
        return this.getDatabaseDirectivesResult(this.checkLabelAndExecute(labelName, new ExecuteInstrumentationWithCallback(){

            @Override
            public void executeWithCallbacks() {
                AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().getDynamicInstrumentationPBD(listener, labelName, false);
            }

            @Override
            public DynamicInstrumentationResult execute() {
                this.executeWithCallbacks();
                return null;
            }
        }));
    }

    public InstrumentationInfoResult getLabelInstrumentationInfo() {
        return this.getInstrumentationInfoResult(this.checkAndExecute(new ExecuteInstrumentation(){

            @Override
            public DynamicInstrumentationResult execute() {
                return AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().getInstrumentationInfoByLabel(null, false);
            }
        }));
    }

    public InstrumentationInfoResult getLabelInstrumentationInfo(final String labelName) {
        return this.getInstrumentationInfoResult(this.checkLabelAndExecute(labelName, new ExecuteInstrumentation(){

            @Override
            public DynamicInstrumentationResult execute() {
                return AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().getInstrumentationInfoByLabel(labelName, false);
            }
        }));
    }

    public InstrumentationInfoResult makePermanent(final String labelName) {
        return this.synchronizePermanentResult(this.getInstrumentationInfoResult(this.checkLabelAndExecute(labelName, new ExecuteInstrumentation(){

            @Override
            public DynamicInstrumentationResult execute() {
                return AgentDynamicInstrumentationBean.this.getDynamicInstrumentationService().makePermanent(labelName);
            }
        })));
    }

    public InstrumentationInfoResult removeInstrumentation(String labelName) {
        return this.removeInstrumentation(labelName, false);
    }

    public InstrumentationInfoResult removeInstrumentation(final String labelName, boolean acceptBusyStatus) {
        return this.synchronizePermanentResult(this.getInstrumentationInfoResult(this.checkLabelAndExecute(labelName, new ExecuteInstrumentation(){

            @Override
            public DynamicInstrumentationResult execute() {
                InstrumentationInfoResult mainResult = new InstrumentationInfoResult(0);
                InstrumentationInfoResult infoForLabel = AgentDynamicInstrumentationBean.this.getLabelInstrumentationInfo(labelName);
                if (!infoForLabel.isError()) {
                    List InstrumentationInfos = infoForLabel.getInstrumentationInfos();
                    for (InstrumentationInfo info : InstrumentationInfos) {
                        AgentDynamicInstrumentationBean.this.getLog().debug(kModule, "Instrumentation " + info.getResourceName() + " for class " + info.getClassName() + " and method " + info.getMethodName() + " is being removed");
                        InstrumentationInfoResult infoFromRemove = AgentDynamicInstrumentationBean.this.removeInstrumentation(info.getMethodName(), info.getClassName(), info.getResourceName(), info.getTracerType(), info.getGroupName());
                        if (!infoFromRemove.isError()) {
                            mainResult.addIntrumentationInfo(infoFromRemove.getInstrumentationInfos());
                            continue;
                        }
                        AgentDynamicInstrumentationBean.this.getLog().warn(kModule, "Instrumentation " + info.getResourceName() + " for class " + info.getClassName() + " and method " + info.getMethodName() + " has not been removed: errot code is " + infoFromRemove.getStatus());
                    }
                } else {
                    mainResult.importAll(infoForLabel);
                }
                return mainResult;
            }
        }, acceptBusyStatus)));
    }

    private String getTemporaryLabel() {
        return "@Temporary Label Prefix@";
    }

    private String safeName(String name) {
        String result = name;
        result = result.replaceAll("\\W", "_").replaceAll(" ", "_");
        return result;
    }

    public Callback addPermanentInstrumentation(InstrumentationInfoNotification callback, final String methodPattern, final String classPattern, final String resourceName, final String tracerType, final String groupName) throws ConnectionException {
        String description = this.getPerformanceDescription("addPermanentInstrumentation", methodPattern, classPattern, resourceName, tracerType, groupName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.addPermanentInstrumentation(methodPattern, classPattern, resourceName, tracerType, groupName));
            }
        }.execute((BaseDINotification)callback);
    }

    public InstrumentationInfoResult addPermanentInstrumentation(String methodPattern, String classPattern, String resourceName, String tracerType, String groupName) {
        InstrumentationInfoResult addedInstrumentation = this.addInstrumentation(methodPattern, classPattern, null, null, resourceName, tracerType, groupName, 0);
        if (addedInstrumentation.isError()) {
            this.removeInstrumentation(methodPattern, classPattern, resourceName, tracerType, groupName);
            return addedInstrumentation;
        }
        return this.synchronizePermanentResult(addedInstrumentation);
    }

    public InstrumentationInfoResult addPermanentInstrumentation(String callingMmethodPattern, String callingClassPattern, String methodPattern, String classPattern, String resourceName, String tracerType, String groupName, String labelName) {
        InstrumentationInfoResult addedInstrumentation = this.addInstrumentation(methodPattern, classPattern, callingMmethodPattern, callingClassPattern, resourceName, tracerType, groupName, labelName, 0);
        if (addedInstrumentation.isError()) {
            this.removeInstrumentation(methodPattern, classPattern, resourceName, tracerType, groupName);
            return addedInstrumentation;
        }
        return this.synchronizePermanentResult(addedInstrumentation);
    }

    public Callback addPermanentInstrumentation(InstrumentationInfoNotification callback, final String callingMethodPattern, final String callingClassPattern, final String methodPattern, final String classPattern, final String resourceName, final String tracerType, final String groupName, final String labelName) throws ConnectionException {
        String description = this.getPerformanceDescription("addPermanentInstrumentation", callingMethodPattern, callingClassPattern, methodPattern, classPattern, resourceName, tracerType, groupName, labelName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.addPermanentInstrumentation(callingMethodPattern, callingClassPattern, methodPattern, classPattern, resourceName, tracerType, groupName, labelName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback addPermanentInstrumentation(InstrumentationInfoNotification callback, final String methodPattern, final String classPattern, final String resourceName, final String tracerType, final String groupName, final String labelName) throws ConnectionException {
        String description = this.getPerformanceDescription("addPermanentInstrumentation", methodPattern, classPattern, resourceName, tracerType, groupName, labelName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                InstrumentationInfoResult addedInstrumentation = this.addInstrumentation(methodPattern, classPattern, null, null, resourceName, tracerType, groupName, labelName, 0);
                if (addedInstrumentation.isError()) {
                    this.removeInstrumentation(methodPattern, classPattern, resourceName, tracerType, groupName);
                    listener.deliverResult((DynamicInstrumentationResult)addedInstrumentation);
                } else {
                    addedInstrumentation = this.synchronizePermanentResult(addedInstrumentation);
                    listener.deliverResult((DynamicInstrumentationResult)addedInstrumentation);
                }
            }
        }.execute((BaseDINotification)callback);
    }

    private synchronized void registerListener(AgentDynamicInstrumentationListener listener) {
        this.fListeners.add(listener);
        if (this.fListeners.size() > 500) {
            AgentDynamicInstrumentationListener expiredListener = (AgentDynamicInstrumentationListener)((Object)this.fListeners.removeFirst());
            expiredListener.close();
        }
    }

    private ICodeIntrospectionService getCodeIntrospectionService() {
        IDynamicInstrumentationTransformer dit = this.getDynamicInstrumentationTransformer();
        return dit.getCodeIntrospectionService();
    }

    private String getActualClassWithMethod(String classPattern, String methodPattern) {
        if (classPattern == null) {
            return null;
        }
        if (this.isStrictMethod()) {
            return classPattern;
        }
        return this.getCodeIntrospectionService().findClassWithMethod(classPattern, methodPattern);
    }

    private boolean isStrictMethod() {
        boolean value = this.getAgent().IAgent_getIndexedProperties().safeGetBooleanProperty(kRemoteAgentDynamicInstrumentationStrictMethodKey, false, this.getAgent().IAgent_getModuleFeedback(), this.getAgent().IAgent_getStringLocalizer());
        return value;
    }

    private boolean isNotBusy(boolean acceptUnknownStatus) {
        Integer currentThreadLocal = (Integer)kBusyReentrancy.get();
        try {
            if (currentThreadLocal == 0) {
                this.getLog().debug(kModule, "Entering");
                int newStatus = this.getDynamicInstrumentationTransformer().getDynamicInstrumentationStatusCode(false);
                this.getLog().debug(kModule, "status is " + newStatus);
                if (newStatus >= 0) {
                    boolean bl = (newStatus & 0x100) == 0;
                    return bl;
                }
                if (acceptUnknownStatus) {
                    return true;
                }
                boolean bl = newStatus >= 0;
                return bl;
            }
        }
        finally {
            kBusyReentrancy.set(currentThreadLocal + 1);
        }
        this.getLog().debug(kModule, "Re-entering: not busy");
        return true;
    }

    private void decreaseBusy() {
        Integer currentThreadLocal = (Integer)kBusyReentrancy.get();
        kBusyReentrancy.set(currentThreadLocal - 1);
    }

    public Callback addInstrumentation(InstrumentationInfoNotification callback, final String methodPattern, final String classPattern, final String resourceName) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("addInstrumentation", methodPattern, classPattern, resourceName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.addInstrumentation(methodPattern, classPattern, resourceName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback addInstrumentation(InstrumentationInfoNotification callback, final String methodPattern, final String classPattern, final String resourceName, final String tracerType, final String groupName) throws ConnectionException {
        String description = this.getPerformanceDescription("addInstrumentation", methodPattern, classPattern, resourceName, tracerType, groupName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.addInstrumentation(methodPattern, classPattern, resourceName, tracerType, groupName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback addInstrumentation(InstrumentationInfoNotification callback, final String methodPattern, final String classPattern, final String resourceName, final String tracerType, final String groupName, final String labelName) throws ConnectionException {
        String description = this.getPerformanceDescription("addInstrumentation", methodPattern, classPattern, resourceName, tracerType, groupName, labelName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.addInstrumentation(methodPattern, classPattern, resourceName, tracerType, groupName, labelName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback addInstrumentation(InstrumentationInfoNotification callback, final String callingMethodPattern, final String callingClassPattern, final String methodPattern, final String classPattern, final String resourceName, final String tracerType, final String groupName) throws ConnectionException {
        String description = this.getPerformanceDescription("addInstrumentation", callingMethodPattern, callingClassPattern, methodPattern, classPattern, resourceName, tracerType, groupName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.addInstrumentation(callingMethodPattern, callingClassPattern, methodPattern, classPattern, resourceName, tracerType, groupName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback addTemporaryInstrumentation(InstrumentationInfoNotification callback, final String methodPattern, final String classPattern, final String resourceName) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("addTemporaryInstrumentation", methodPattern, classPattern, resourceName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.addTemporaryInstrumentation(methodPattern, classPattern, resourceName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback addTemporaryInstrumentation(InstrumentationInfoNotification callback, final String methodPattern, final String classPattern, final String resourceName, final String tracerType, final String groupName) throws ConnectionException {
        String description = this.getPerformanceDescription("addTemporaryInstrumentation", methodPattern, classPattern, resourceName, tracerType, groupName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.addTemporaryInstrumentation(methodPattern, classPattern, resourceName, tracerType, groupName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback addTemporaryInstrumentation(InstrumentationInfoNotification callback, final String methodPattern, final String classPattern, final String resourceName, final String tracerType, final String groupName, final String labelName) throws ConnectionException {
        String description = this.getPerformanceDescription("addTemporaryInstrumentation", methodPattern, classPattern, resourceName, tracerType, groupName, labelName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.addTemporaryInstrumentation(methodPattern, classPattern, resourceName, tracerType, groupName, labelName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback addTemporaryInstrumentation(InstrumentationInfoNotification callback, final String callingMethodPattern, final String callingClassPattern, final String methodPattern, final String classPattern, final String resourceName, final String tracerType, final String groupName) throws ConnectionException {
        String description = this.getPerformanceDescription("addTemporaryInstrumentation", callingMethodPattern, callingClassPattern, methodPattern, classPattern, resourceName, tracerType, groupName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.addTemporaryInstrumentation(callingMethodPattern, callingClassPattern, methodPattern, classPattern, resourceName, tracerType, groupName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback assignLabel(InstrumentationInfoNotification callback, final String methodPattern, final String classPattern, final String labelName, final String resourceName, final String tracerType, final String groupName) throws ConnectionException {
        String description = this.getPerformanceDescription("assignLabel", methodPattern, classPattern, labelName, resourceName, tracerType, groupName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.assignLabel(methodPattern, classPattern, labelName, resourceName, tracerType, groupName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback exportInstrumentation(final DynamicDirectivesNotification callback) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("exportInstrumentation");
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(final IDynamicInstrumentationListener listener) {
                this.getAgent().IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new IExecutableItem(){

                    public void IExecutableItem_execute() {
                        try {
                            this.exportInstrumentation(listener);
                        }
                        catch (Throwable t) {
                            this.getLog().error(kModule, "Unexpecte error when executing export instrumentation");
                            this.getLog().debug(kModule, "Unexpecte error when executing export instrumentation", t);
                            callback.close();
                        }
                    }

                    public void IExecutableItem_executionAborted() {
                        callback.close();
                    }

                    public boolean IExecutableItem_shouldStillExecute() {
                        return !callback.isClosed();
                    }
                });
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback exportInstrumentation(final DynamicDirectivesNotification callback, final String labelName) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("exportInstrumentation", labelName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(final IDynamicInstrumentationListener listener) {
                this.getAgent().IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new IExecutableItem(){

                    public void IExecutableItem_execute() {
                        try {
                            this.exportInstrumentation(listener, labelName);
                        }
                        catch (Throwable t) {
                            this.getLog().error(kModule, "Unexpecte error when executing export instrumentation");
                            this.getLog().debug(kModule, "Unexpecte error when executing export instrumentation", t);
                            callback.close();
                        }
                    }

                    public void IExecutableItem_executionAborted() {
                        callback.close();
                    }

                    public boolean IExecutableItem_shouldStillExecute() {
                        return !callback.isClosed();
                    }
                });
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback getDynamicInstrumentationStatus(DynamicInstrumentationNotification callback) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("getDynamicInstrumentationStatus");
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult(this.getDynamicInstrumentationStatus());
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback getGroups(GroupInstrumentationInfoNotification callback) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("getGroups");
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.getGroups());
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback getInstrumentationInfo(InstrumentationInfoNotification callback, final String methodPattern, final String classPattern) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("getInstrumentationInfo", methodPattern, classPattern);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.getInstrumentationInfo(methodPattern, classPattern));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback getInstrumentationInfo(InstrumentationInfoNotification callback, final String groupName) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("getInstrumentationInfo", groupName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.getInstrumentationInfo(groupName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback getInstrumentationInfo(InstrumentationInfoNotification callback) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("getInstrumentationInfo");
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.getInstrumentationInfo());
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback getLabelInstrumentationInfo(InstrumentationInfoNotification callback) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("getLabelInstrumentationInfo");
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.getLabelInstrumentationInfo());
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback getLabelInstrumentationInfo(InstrumentationInfoNotification callback, final String labelName) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("getLabelInstrumentationInfo", labelName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.getLabelInstrumentationInfo(labelName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback getMethodCalls(MethodCallsNotification callback, final String methodPattern, final String classPattern) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("getMethodCalls", methodPattern, classPattern);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.getMethodCalls(methodPattern, classPattern));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback getMethodCalls(MethodCallsNotification callback, final String resourceName) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("getMethodCalls", resourceName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.getMethodCalls(resourceName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback getMethods(DynamicInstrumentationNotification callback, final String classPattern) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("getMethods", classPattern);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult(this.getMethods(classPattern));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback getPackagesOrAssemblies(DynamicInstrumentationNotification callback) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("getPackagesOrAssemblies");
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult(this.getPackagesOrAssemblies());
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback makePermanent(InstrumentationInfoNotification callback, final String labelName) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("makePermanent", labelName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.makePermanent(labelName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback removeInstrumentation(InstrumentationInfoNotification callback, final String methodPattern, final String classPattern, final String resourceName, final String tracerType, final String groupName) throws ConnectionException {
        String description = this.getPerformanceDescription("removeInstrumentation", methodPattern, classPattern, resourceName, tracerType, groupName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.removeInstrumentation(methodPattern, classPattern, resourceName, tracerType, groupName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback removeInstrumentation(InstrumentationInfoNotification callback, final String labelName) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("removeInstrumentation", labelName);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.removeInstrumentation(labelName));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback saveGroups(GroupInstrumentationInfoNotification callback) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("saveGroups");
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                listener.deliverResult((DynamicInstrumentationResult)this.synchronizePermanentResult(this.getGroupInstrumentationInfoResult(this.checkAndExecute(new ExecuteInstrumentation(){

                    @Override
                    public DynamicInstrumentationResult execute() {
                        return this.getDynamicInstrumentationService().makePermanentGroupDirectives();
                    }
                }))));
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback setGroupEnabledStatus(GroupInstrumentationInfoNotification callback, final String groupName, final Boolean isEnabled) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("setGroupEnabledStatus", groupName, isEnabled.toString());
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                GroupInstrumentationInfoResult result = this.synchronizePermanentResult(this.getGroupInstrumentationInfoResult(this.checkAndExecute(new ExecuteInstrumentation(){

                    @Override
                    public DynamicInstrumentationResult execute() {
                        return this.executeSetGroupDirective(groupName, isEnabled, 2);
                    }
                })));
                listener.deliverResult((DynamicInstrumentationResult)result);
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback setGroupEnabledStatus(GroupInstrumentationInfoNotification callback, final Map groupNamesWithStatus) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("setGroupEnabledStatus", groupNamesWithStatus);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                Iterator i = groupNamesWithStatus.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    final String groupName = (String)e.getKey();
                    final Boolean isEnabled = (Boolean)e.getValue();
                    GroupInstrumentationInfoResult result = this.synchronizePermanentResult(this.getGroupInstrumentationInfoResult(this.checkAndExecute(new ExecuteInstrumentation(){

                        @Override
                        public DynamicInstrumentationResult execute() {
                            GroupInstrumentationInfoResult result = this.getDynamicInstrumentationService().setGroupDirectiveWithoutBusy(groupName, isEnabled.booleanValue(), 2);
                            this.updateWithStaticInformation(result, false);
                            return result;
                        }
                    }, true, false)));
                    if (i.hasNext()) {
                        result.setLastResult(Boolean.FALSE);
                    } else {
                        result.setLastResult(Boolean.TRUE);
                    }
                    listener.deliverResult((DynamicInstrumentationResult)result);
                }
            }
        }.execute((BaseDINotification)callback);
    }

    PostOffice getMyPostOffice() {
        return this.getPostOffice();
    }

    private int getDirectiveType(boolean isConditional, boolean isInheriting) {
        int tracerDirectiveType = -1;
        tracerDirectiveType = isConditional ? (isInheriting ? 5 : 4) : (isInheriting ? 3 : 0);
        return tracerDirectiveType;
    }

    public Callback exportInstrumentation(final DynamicDirectivesNotification callback, final List labels) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("exportInstrumentation", labels);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(final IDynamicInstrumentationListener listener) {
                final Iterator i = labels.iterator();
                while (i.hasNext()) {
                    IDynamicInstrumentationListener myListener = new IDynamicInstrumentationListener(){

                        public void deliverResult(DynamicInstrumentationResult result) {
                            if (result != null && i.hasNext()) {
                                result.setLastResult(Boolean.FALSE);
                            }
                            listener.deliverResult(result);
                        }
                    };
                    String labelName = (String)i.next();
                    try {
                        this.exportInstrumentation(myListener, labelName);
                    }
                    catch (Throwable t) {
                        this.getLog().error(kModule, "Unexpected error when executing export instrumentation");
                        this.getLog().debug(kModule, "Unexpected error when executing export instrumentation", t);
                    }
                }
                callback.close();
            }
        }.execute((BaseDINotification)callback);
    }

    public Callback removeInstrumentation(InstrumentationInfoNotification callback, final List labels) throws ConnectionException {
        String description = AgentDynamicInstrumentationBean.getPerformanceDescription("removeInstrumentation", labels);
        return new ExecuteWithCallback(this, description){

            @Override
            protected void execute(IDynamicInstrumentationListener listener) {
                Iterator i = labels.iterator();
                while (i.hasNext()) {
                    String labelName = (String)i.next();
                    InstrumentationInfoResult r = this.removeInstrumentation(labelName, true);
                    if (i.hasNext()) {
                        r.setLastResult(Boolean.FALSE);
                    } else {
                        r.setLastResult(Boolean.TRUE);
                    }
                    listener.deliverResult((DynamicInstrumentationResult)r);
                }
            }
        }.execute((BaseDINotification)callback);
    }

    private GroupInstrumentationInfoResult executeSetGroupDirective(String groupName, boolean isEnabled, int status) {
        GroupInstrumentationInfoResult result = this.getDynamicInstrumentationService().setGroupDirective(groupName, isEnabled, status);
        this.updateWithStaticInformation(result, false);
        return result;
    }

    private static final String getPerformanceDescription(String string) {
        if (fIsPerformanceDebugEnabled) {
            return AgentDynamicInstrumentationBean.getPerformanceDescription(string, new String[0]);
        }
        return null;
    }

    private static final String getPerformanceDescription(String string, String arg1) {
        if (fIsPerformanceDebugEnabled) {
            return AgentDynamicInstrumentationBean.getPerformanceDescription(string, new String[]{arg1});
        }
        return null;
    }

    private static final String getPerformanceDescription(String string, Map arg1) {
        if (fIsPerformanceDebugEnabled) {
            return AgentDynamicInstrumentationBean.getPerformanceDescription(string, new Object[]{arg1.entrySet().toArray()});
        }
        return null;
    }

    private static final String getPerformanceDescription(String string, List arg1) {
        if (fIsPerformanceDebugEnabled) {
            return AgentDynamicInstrumentationBean.getPerformanceDescription(string, new Object[]{arg1.toArray()});
        }
        return null;
    }

    private static final String getPerformanceDescription(String string, String arg1, String arg2) {
        if (fIsPerformanceDebugEnabled) {
            return AgentDynamicInstrumentationBean.getPerformanceDescription(string, new String[]{arg1, arg2});
        }
        return null;
    }

    private static final String getPerformanceDescription(String string, String arg1, String arg2, String arg3) {
        if (fIsPerformanceDebugEnabled) {
            return AgentDynamicInstrumentationBean.getPerformanceDescription(string, new String[]{arg1, arg2, arg3});
        }
        return null;
    }

    private String getPerformanceDescription(String string, String arg1, String arg2, String arg3, String arg4, String arg5) {
        if (fIsPerformanceDebugEnabled) {
            return AgentDynamicInstrumentationBean.getPerformanceDescription(string, new String[]{arg1, arg2, arg3, arg4, arg5});
        }
        return null;
    }

    private String getPerformanceDescription(String string, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6) {
        if (fIsPerformanceDebugEnabled) {
            return AgentDynamicInstrumentationBean.getPerformanceDescription(string, new String[]{arg1, arg2, arg3, arg4, arg5, arg6});
        }
        return null;
    }

    private String getPerformanceDescription(String string, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6, String arg7) {
        if (fIsPerformanceDebugEnabled) {
            return AgentDynamicInstrumentationBean.getPerformanceDescription(string, new String[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7});
        }
        return null;
    }

    private String getPerformanceDescription(String string, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6, String arg7, String arg8) {
        if (fIsPerformanceDebugEnabled) {
            return AgentDynamicInstrumentationBean.getPerformanceDescription(string, new String[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8});
        }
        return null;
    }

    private static String getPerformanceDescription(String string, Object[] strings) {
        StringBuilder sb = new StringBuilder(2048);
        sb.append(string).append("(");
        int i = 0;
        while (i < strings.length - 1) {
            sb.append(strings[i]).append(", ");
            ++i;
        }
        if (strings.length >= 1) {
            sb.append(strings[strings.length - 1]).append(")");
        } else {
            sb.append(")");
        }
        return sb.toString();
    }

    public void setAgent(IAgent agent) {
        super.setAgent(agent);
        if (kTempInstrumentationHeartbeat == null) {
            kTempInstrumentationHeartbeat = new IntervalHeartbeat("Temp Instrumentation Queue", this.getAgent().IAgent_getAgentThreadFactory(), this.getAgent().IAgent_getModuleFeedback(), this.getAgent().IAgent_getStringLocalizer());
            kTempInstrumentationHeartbeat.start();
        }
    }

    static class AgentDynamicInstrumentationListener
    extends DynamicInstrumentationListener {
        public AgentDynamicInstrumentationListener(IModuleFeedbackChannel log, Module module, PostOffice postOffice, BaseDINotification callback) throws EndpointNotFoundException {
            super(log, module, postOffice, callback);
        }

        public void close() {
            this.fNotificationConnector.close();
        }
    }

    private static interface CommonExecute {
    }

    private static interface ExecuteInstrumentation
    extends CommonExecute {
        public DynamicInstrumentationResult execute();
    }

    private static interface ExecuteInstrumentationWithCallback
    extends ExecuteInstrumentation {
        public void executeWithCallbacks();
    }

    private static interface ExecuteInstrumentationWithClassNames
    extends CommonExecute {
        public DynamicInstrumentationResult execute(ICodeIntrospectionService.ClassMethodName var1, ICodeIntrospectionService.ClassMethodName var2);
    }

    private abstract class ExecuteTemporary {
        private ExecuteTemporary() {
        }

        abstract DynamicInstrumentationResult execute();

        abstract void rollback();

        DynamicInstrumentationResult executeTemporary(AgentDynamicInstrumentationBean parent) {
            DynamicInstrumentationResult result = this.execute();
            if (!result.isError()) {
                ICallback callback = new ICallback(){

                    public void closing() throws ConnectionException {
                        IntervalHeartbeat heartbeat = kTempInstrumentationHeartbeat;
                        if (heartbeat == null) {
                            heartbeat = AgentDynamicInstrumentationBean.this.getAgent().IAgent_getConfigHeartbeat();
                        }
                        new WaitAndExecuteBehavior(heartbeat, 100L, "Rolling Back Temporary Intrumentation" + System.currentTimeMillis()){

                            protected boolean execute() {
                                try {
                                    if (AgentDynamicInstrumentationBean.this.isNotBusy(false)) {
                                        ExecuteTemporary.this.rollback();
                                        return true;
                                    }
                                    return false;
                                }
                                catch (Throwable t) {
                                    AgentDynamicInstrumentationBean.this.getLog().error(kModule, "Unable to remove Temporary instrumentation on callback closing");
                                    AgentDynamicInstrumentationBean.this.getLog().debug(kModule, "Unable to remove Temporary instrumentation on callback closing", t);
                                    return true;
                                }
                                finally {
                                    AgentDynamicInstrumentationBean.this.decreaseBusy();
                                }
                            }
                        };
                    }
                };
                Callback notification = new Callback(parent.getPostOffice(), ICallback.class, callback);
                result.setCallback(notification);
            }
            return result;
        }

        protected void removeInstrumentationByLineNumber(InstrumentationInfo info) {
            try {
                int lineNumber = info.getLineNumber();
                ClassName className = ClassName.getClassName((String)info.getClassName());
                MethodName methodName = MethodName.getMethodName((String)info.getMethodName());
                AgentDynamicInstrumentationBean.this.getLog().verbose(kModule, "Temporary instrumentation for class " + className + " is being removed");
                InstrumentationInfoResult internalResult = AgentDynamicInstrumentationBean.this.removeTemporaryInstrumentation(lineNumber, (IClassName)className, (IMethodName)methodName);
                AgentDynamicInstrumentationBean.this.getLog().verbose(kModule, "Temporary instrumentation for class " + className + " has been removed: " + internalResult.getStatus());
            }
            catch (InvalidClassNameException invalidClassNameException) {
            }
            catch (InvalidMethodDescriptorException invalidMethodDescriptorException) {
            }
            catch (InvalidMethodNameException invalidMethodNameException) {}
        }
    }

    abstract class ExecuteWithCallback {
        private long start;
        private String fPerformanceLogIdentifier;

        protected ExecuteWithCallback() {
        }

        protected ExecuteWithCallback(String logIdentifier) {
            this.fPerformanceLogIdentifier = logIdentifier;
        }

        public Callback execute(BaseDINotification callback) throws ConnectionException {
            if (fIsPerformanceDebugEnabled) {
                this.start = System.currentTimeMillis();
            }
            try {
                AgentDynamicInstrumentationListener listener = new AgentDynamicInstrumentationListener(AgentDynamicInstrumentationBean.this.getLog(), kModule, AgentDynamicInstrumentationBean.this.getPostOffice(), callback);
                AgentDynamicInstrumentationBean.this.registerListener(listener);
                ICallback agentFailsafe = new ICallback(){

                    public void closing() throws ConnectionException {
                    }
                };
                Callback agentFailsafeNotification = new Callback(AgentDynamicInstrumentationBean.this.getPostOffice(), ICallback.class, agentFailsafe);
                this.execute((IDynamicInstrumentationListener)listener);
                Callback callback2 = agentFailsafeNotification;
                return callback2;
            }
            catch (EndpointNotFoundException e) {
                AgentDynamicInstrumentationBean.this.getLog().error(kModule, "Cannot connect callback");
                throw new ConnectionException((Throwable)e);
            }
            catch (Throwable t) {
                AgentDynamicInstrumentationBean.this.getLog().error(kModule, "Unexpected error in Dynamic Instrumentation Invocation");
                AgentDynamicInstrumentationBean.this.getLog().debug(kModule, "Unexpected error in Dynamic Instrumentation Invocation", t);
                throw new ConnectionException(t);
            }
            finally {
                if (fIsPerformanceDebugEnabled) {
                    long end = System.currentTimeMillis();
                    AgentDynamicInstrumentationBean.this.getAgent().IAgent_getModuleFeedback().debug(kPerformanceModule, "Execute in " + (end - this.start) + " ms " + this.fPerformanceLogIdentifier);
                }
            }
        }

        protected abstract void execute(IDynamicInstrumentationListener var1);
    }

    public static abstract class ExportInstrumentationBaseDINotification
    implements IBaseDINotification {
        private DynamicDirectivesResult firstResult;
        private final String fLabel;

        public ExportInstrumentationBaseDINotification(String label) {
            this.fLabel = label;
        }

        public abstract void doWithResult(DynamicDirectivesResult var1);

        public void executeOnResult(DynamicInstrumentationResult result) throws ConnectionException {
            if (result != null && result instanceof DynamicDirectivesResult) {
                if (this.firstResult == null) {
                    this.firstResult = new DynamicDirectivesResult((DynamicDirectivesResult)result);
                } else if (this.firstResult != null) {
                    this.firstResult.addPbdLines(((DynamicDirectivesResult)result).getPbdLines());
                }
            }
            if (result != null && result.isLastResult().booleanValue() && this.firstResult != null) {
                this.doWithResult(this.firstResult);
            }
        }

        protected String getLabel() {
            return this.fLabel;
        }

        public Class getCharacterizingClass() throws ConnectionException {
            return IBaseDINotification.class;
        }

        public void closing() throws ConnectionException {
        }
    }
}

