/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;

public final class SystemOutFeedbackChannel
implements IModuleFeedbackChannel {
    private final PrintWriter fOutputWriter = new PrintWriter(System.out, true);
    private final PrintWriter fErrorWriter = new PrintWriter(System.err, true);
    private final DateFormat fTimeFormat = this.createTimeFormat();
    private final Object fLock = new Object();
    private String fModuleName;
    private volatile SeverityLevel fSeverityLevel;

    public SystemOutFeedbackChannel(String moduleName) {
        this(moduleName, SeverityLevel.VERBOSE);
    }

    public SystemOutFeedbackChannel(String moduleName, SeverityLevel severityLevel) {
        this.fSeverityLevel = severityLevel;
        this.fModuleName = moduleName;
    }

    private DateFormat createTimeFormat() {
        return DateFormat.getDateTimeInstance(3, 1);
    }

    public PrintWriter getOutputWriter() {
        return this.fOutputWriter;
    }

    public PrintWriter getErrorWriter() {
        return this.fErrorWriter;
    }

    private Object getFeedbackChannelLock() {
        return this.fLock;
    }

    public void setModuleName(String moduleName) {
        this.fModuleName = moduleName;
    }

    @Override
    public String getModuleName() {
        return this.fModuleName;
    }

    @Override
    public final String getApplicationName() {
        return "SystemOutFeedback";
    }

    @Override
    public void error(String message) {
        this.log(SeverityLevel.ERROR, message, null);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log(SeverityLevel.ERROR, message, t);
    }

    @Override
    public void warn(String message) {
        this.log(SeverityLevel.WARN, message, null);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log(SeverityLevel.WARN, message, t);
    }

    @Override
    public void info(String message) {
        this.log(SeverityLevel.INFO, message, null);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log(SeverityLevel.INFO, message, t);
    }

    @Override
    public void verbose(String message) {
        this.log(SeverityLevel.VERBOSE, message, null);
    }

    @Override
    public void verbose(String message, Throwable t) {
        this.log(SeverityLevel.VERBOSE, message, t);
    }

    @Override
    public void debug(String message) {
        this.log(SeverityLevel.DEBUG, message, null);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log(SeverityLevel.DEBUG, message, t);
    }

    @Override
    public void log(SeverityLevel severity, String message) {
        this.log(severity, message, null);
    }

    @Override
    public void log(SeverityLevel severity, String message, Throwable t) {
        if (this.isLogEnabled(severity, null)) {
            this.doLog(severity, message, t);
        }
    }

    @Override
    public void error(Throwable t) {
        this.log(SeverityLevel.ERROR, null, t);
    }

    @Override
    public void verbose(Throwable t) {
        this.log(SeverityLevel.VERBOSE, null, t);
    }

    @Override
    public void debug(Throwable t) {
        this.log(SeverityLevel.DEBUG, null, t);
    }

    @Override
    public void error(Module module, String message) {
        this.log(SeverityLevel.ERROR, module, message, null);
    }

    @Override
    public void error(Module module, String message, Throwable t) {
        this.log(SeverityLevel.ERROR, module, message, t);
    }

    @Override
    public void warn(Module module, String message) {
        this.log(SeverityLevel.WARN, module, message, null);
    }

    @Override
    public void warn(Module module, String message, Throwable t) {
        this.log(SeverityLevel.WARN, module, message, t);
    }

    @Override
    public void info(Module module, String message) {
        this.log(SeverityLevel.INFO, module, message, null);
    }

    @Override
    public void info(Module module, String message, Throwable t) {
        this.log(SeverityLevel.INFO, module, message, t);
    }

    @Override
    public void verbose(Module module, String message) {
        this.log(SeverityLevel.VERBOSE, module, message, null);
    }

    @Override
    public void verbose(Module module, String message, Throwable t) {
        this.log(SeverityLevel.VERBOSE, module, message, t);
    }

    @Override
    public void debug(Module module, String message) {
        this.log(SeverityLevel.DEBUG, module, message, null);
    }

    @Override
    public void debug(Module module, String message, Throwable t) {
        this.log(SeverityLevel.DEBUG, module, message, t);
    }

    @Override
    public void trace(String message) {
        this.log(SeverityLevel.TRACE, null, message, null);
    }

    @Override
    public void trace(Module module, String message) {
        this.log(SeverityLevel.TRACE, module, message, null);
    }

    @Override
    public void trace(Module module, String message, Throwable t) {
        this.log(SeverityLevel.TRACE, module, message, t);
    }

    @Override
    public void log(SeverityLevel severity, Module module, String message) {
        this.log(severity, module, message, null);
    }

    @Override
    public void log(SeverityLevel severity, Module module, String message, Throwable t) {
        this.log(severity, message, t);
    }

    @Override
    public void logImmediate(SeverityLevel severity, Module module, String message) {
        this.log(severity, module, message, null);
    }

    @Override
    public void logImmediate(SeverityLevel severity, Module module, String message, Throwable t) {
        this.log(severity, module, message, t);
    }

    @Override
    public boolean isVerboseEnabled() {
        return this.isLogEnabled(SeverityLevel.VERBOSE, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLogEnabled(SeverityLevel.DEBUG, null);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLogEnabled(SeverityLevel.TRACE, null);
    }

    @Override
    public boolean isErrorEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.ERROR, module);
    }

    @Override
    public boolean isWarningEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.WARN, module);
    }

    @Override
    public boolean isInfoEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.INFO, module);
    }

    @Override
    public boolean isVerboseEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.VERBOSE, module);
    }

    @Override
    public boolean isDebugEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.DEBUG, module);
    }

    @Override
    public boolean isTraceEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.TRACE, module);
    }

    @Override
    public boolean isLogEnabled(SeverityLevel severity, Module module) {
        return severity.compareTo(this.fSeverityLevel) <= 0;
    }

    @Override
    public SeverityLevel getEffectiveLevel(Module module) {
        return this.fSeverityLevel;
    }

    @Override
    public SeverityLevel getLevel(Module module) {
        return this.fSeverityLevel;
    }

    @Override
    public void setLevel(SeverityLevel level, Module module) {
        this.fSeverityLevel = level;
    }

    private void doLog(SeverityLevel severity, String message, Throwable t) {
        if (message != null) {
            this.doLogMessage(severity, message);
        }
        if (t != null) {
            this.doLogException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLogMessage(SeverityLevel severity, String message) {
        Object object = this.getFeedbackChannelLock();
        synchronized (object) {
            PrintWriter writer = severity == SeverityLevel.ERROR ? this.getErrorWriter() : this.getOutputWriter();
            this.writeFormattedTimestamp(writer);
            writer.print(" ");
            this.writeSegment(writer, severity.toString());
            writer.print(" ");
            this.writeSegment(writer, this.getModuleName());
            writer.print(" ");
            writer.println(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLogException(Throwable t) {
        Object object = this.getFeedbackChannelLock();
        synchronized (object) {
            PrintWriter writer = this.getErrorWriter();
            this.writeFormattedTimestamp(writer);
            writer.print("    ");
            t.printStackTrace(writer);
        }
    }

    private void writeSegment(PrintWriter writer, String segment) {
        writer.print("[");
        writer.print(segment);
        writer.print("]");
    }

    private void writeFormattedTimestamp(PrintWriter writer) {
        this.writeFormattedTimestamp(writer, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFormattedTimestamp(PrintWriter writer, Date when) {
        Object object = this.getFeedbackChannelLock();
        synchronized (object) {
            if (this.fTimeFormat != null) {
                writer.print(this.fTimeFormat.format(when));
            }
        }
    }

    public void setConfigPath(String configPath) {
    }

    public void setConfigURL(URL configURL) {
    }

    public void setRootVerbose() {
    }
}

