/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.parent.instrumentation.filter;

import com.ca.apm.parent.instrumentation.filter.TraceElementFilter;
import com.ca.apm.parent.instrumentation.helper.ParentInstrumentationHelper;
import com.ca.apm.parent.instrumentation.helper.WrappedStackTraceElement;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class ClassFilter
implements TraceElementFilter {
    private final Set<Pattern> packageFilters = new HashSet<Pattern>();

    public ClassFilter(Set<String> packageExprns) {
        this.init(packageExprns, true);
    }

    public ClassFilter(String commaSepratedPackagesList, String regex) {
        if (commaSepratedPackagesList != null && !commaSepratedPackagesList.isEmpty()) {
            String[] stringArray = commaSepratedPackagesList.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pkg = stringArray[n2];
                pkg = ParentInstrumentationHelper.convertToPackageRegex(pkg);
                this.packageFilters.add(Pattern.compile(pkg, 2));
                ++n2;
            }
        }
        if (regex != null && !regex.isEmpty()) {
            this.packageFilters.add(Pattern.compile(regex, 2));
        }
    }

    private void init(Set<String> packageExprns, boolean isRegexBased) {
        for (String packageExpr : packageExprns) {
            if (!isRegexBased) {
                packageExpr = ParentInstrumentationHelper.convertToPackageRegex(packageExpr);
            }
            this.packageFilters.add(Pattern.compile(packageExpr, 2));
        }
    }

    @Override
    public boolean doFilter(WrappedStackTraceElement traceElement) {
        String className = traceElement.getClassName();
        if (className == null) {
            return true;
        }
        return !ParentInstrumentationHelper.doesPackgeMatchesPatterns(className, this.packageFilters);
    }
}

