/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.backend.http.helper.HttpResponseHelper;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class HttpResponseCodeFetcherTracer
extends ASingleInstanceTracerFactory {
    private ReentrancyLevel fReEntryLeveL = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    private static Module sModule = new Module("HttpResponseCodeFetcherTracer");
    protected IModuleFeedbackChannel logger = null;

    public HttpResponseCodeFetcherTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int index, InvocationData data) {
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        try {
            int responseCode = (Integer)data.getInvocationReturnValueAsObject();
            if (!HttpResponseHelper.getBackendCalledAttribute(data.getInvocationObject())) {
                return;
            }
            HttpResponseHelper.putResponseCode(data.getInvocationObject(), responseCode, this.logger);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.logger.error(sModule, "getHttpStatusCode() Unable to get response code: " + t.toString());
                this.logger.verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReEntryLeveL;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

