/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.WSCorrelationTracer;
import com.wily.util.properties.AttributeListing;

public class Axis2ClientHTTPCorrelationTracer
extends WSCorrelationTracer {
    boolean doFinish = true;

    public Axis2ClientHTTPCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    @Override
    public void ITracer_startTrace(int index, InvocationData data) {
        boolean isHTTPInsertionEnabled = WSMUtils.correlationHTTPInsertionEnabled();
        try {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ClientHTTPCorrelationTracer:: getInvocationParameterCount=" + data.getInvocationParameterCount());
                int i = 0;
                while (i < data.getInvocationParameterCount()) {
                    this.logger.debug("Axis2ClientHTTPCorrelationTracer::" + data.getInvocationParameterAsObject(i).getClass());
                    ++i;
                }
            }
            this.insertHTTPCorrelationInfo(data, isHTTPInsertionEnabled);
        }
        catch (Throwable bomb) {
            String message = "Axis2ClientHTTPCorrelationTracer ITracer_startTrace exception:  " + bomb;
            WSMUtils.handleException(this.getAgent(), message, bomb);
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (!WSMUtils.correlationHTTPInsertionEnabled()) {
            return;
        }
        if (this.doFinish) {
            int correlationCount = new CorrelationId().decrementCorrelationCount();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ClientHTTPCorrelationTracer ITracer_finishTrace correlationCount=" + correlationCount);
            }
        }
    }

    protected void insertHTTPCorrelationInfo(InvocationData data, boolean isHTTPInsertionEnabled) throws Exception {
        if (isHTTPInsertionEnabled) {
            Object messageContext = data.getInvocationParameterAsObject(1);
            Object transportOut = WSMUtils.invokeMethodOnObject(messageContext, "getProperty", new Class[]{String.class}, new Object[]{"TRANSPORT_OUT"});
            if (transportOut != null) {
                this.doFinish = false;
                return;
            }
            this.doFinish = true;
            Object hTTPMethod = data.getInvocationParameterAsObject(3);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ClientHTTPCorrelationTracer:: call class=" + hTTPMethod.getClass());
            }
            this.addCorrelationInfoToHttpHeaders(data, messageContext, hTTPMethod);
        }
    }

    protected void addCorrelationInfoToHttpHeaders(InvocationData data, Object messageContext, Object httpMethod) throws Exception {
        String correlationId = (String)WSMUtils.invokeMethodOnObject(messageContext, "getProperty", new Class[]{String.class}, new Object[]{"CORRELATION_ID"});
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Axis2ClientHTTPCorrelationTracer CorID: " + correlationId);
        }
        WSMUtils.invokeMethodOnObject(httpMethod, "setRequestHeader", new Class[]{String.class, String.class}, new Object[]{"CorID", correlationId});
    }
}

