/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.WSCorrelationTracer;
import com.wily.util.properties.AttributeListing;
import java.util.Iterator;

public class WL9ServerCorrelationTracer
extends WSCorrelationTracer {
    public WL9ServerCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        this.logger.debug("WL9ServerCorrelationTracer.ITracer_finishTrace");
        super.ITracer_finishTrace(tracerIndex, data);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean correlationIdFound;
        block8: {
            this.logger.debug("WL9ServerCorrelationTracer.ITracer_startTrace");
            correlationIdFound = false;
            try {
                Object messageContext = data.getInvocationParameterAsObject(0);
                boolean isHTTPCorrelationEnabled = WSMUtils.correlationHTTPReadEnabled();
                correlationIdFound = this.readHTTPCorrelationInfo(messageContext, isHTTPCorrelationEnabled);
                if (!WSMUtils.correlationSOAPReadEnabled() || correlationIdFound) break block8;
                Object message = WSMUtils.invokeMethodOnObject(messageContext, "getMessage");
                Object soapPart = WSMUtils.invokeMethodOnObject(message, "getSOAPPart");
                Object envelope = WSMUtils.invokeMethodOnObject(soapPart, "getEnvelope");
                Object soapHeader = WSMUtils.invokeMethodOnObject(envelope, "getHeader");
                Object childElement = null;
                if (soapHeader != null) {
                    this.logger.debug("WL9ServerCorrelationTracer.ITracer_startTrace header !=null");
                    Iterator itr = (Iterator)WSMUtils.invokeMethodOnObject(soapHeader, "getChildElements");
                    while (itr.hasNext()) {
                        childElement = itr.next();
                        this.logger.debug("WL9ServerCorrelationTracer.ITracer_startTrace soap in while childElement=" + childElement.getClass());
                        if (!childElement.getClass().getName().equals("weblogic.xml.saaj.SOAPHeaderElementImpl")) continue;
                        Object elementName = WSMUtils.invokeMethodOnObject(childElement, "getElementName");
                        String headerName = (String)WSMUtils.invokeMethodOnObject(elementName, "getLocalName");
                        this.logger.debug("WL9ServerCorrelationTracer.ITracer_startTrace SOAP headerName=" + headerName);
                        if (!headerName.equals("WSCorIDSOAPHeader")) continue;
                        if (this.logger != null && this.logger.isDebugEnabled()) {
                            this.logger.debug("WL9ServerCorrelationTracer::CorId Found.");
                        }
                        correlationIdFound = true;
                        Object attrName = WSMUtils.invokeMethodOnObject(envelope, "createName", new Class[]{String.class}, new Object[]{"CorID"});
                        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                        String corrID = (String)WSMUtils.invokeMethodOnObject(childElement, "getAttributeValue", new Class[]{Class.forName("javax.xml.soap.Name", false, threadClassLoader)}, new Object[]{attrName});
                        if (corrID != null && !corrID.equals("")) {
                            new CorrelationId(corrID);
                            correlationIdFound = true;
                        }
                        if (this.logger != null && this.logger.isDebugEnabled()) {
                            this.logger.debug("WL9ServerCorrelationTracer CorID: " + corrID);
                        }
                        WSMUtils.invokeMethodOnObject(soapHeader, "removeChild", new Class[]{Class.forName("org.w3c.dom.Node")}, new Object[]{childElement});
                        break block8;
                    }
                    break block8;
                }
                this.logger.debug("WL9ServerCorrelationTracer.ITracer_startTrace header ==null");
            }
            catch (Exception e) {
                WSMUtils.handleException(this.getAgent(), "WL9ServerCorrelationTracer:ITracer_startTrace", e);
            }
        }
        if (!correlationIdFound) {
            new CorrelationId();
        }
        super.ITracer_startTrace(tracerIndex, data);
    }

    protected boolean readHTTPCorrelationInfo(Object messageContext, boolean isHTTPCorrelationEnabled) throws Exception {
        boolean correlationIdFound = false;
        if (isHTTPCorrelationEnabled) {
            Object soapMess = WSMUtils.invokeMethodOnObject(messageContext, "getMessage");
            Object mimeheaders = WSMUtils.invokeMethodOnObject(soapMess, "getMimeHeaders");
            correlationIdFound = this.getCorrelationInfoToHttpHeaders(mimeheaders);
        }
        return correlationIdFound;
    }

    protected boolean getCorrelationInfoToHttpHeaders(Object mimeheaders) throws Exception {
        boolean correlationIdFound = false;
        String[] corid = (String[])WSMUtils.invokeMethodOnObject(mimeheaders, "getHeader", new Class[]{String.class}, new Object[]{"CorID"});
        if (corid != null && corid.length > 0) {
            if (corid.length > 1) {
                this.logger.info("WL9ServerCorrelationTracer: multiple Correlation ID values found, the first value will be used");
            }
            new CorrelationId(corid[0]);
            this.logger.debug("WL9ServerCorrelationTracer.ITracer_startTrace http correlationid found");
            correlationIdFound = true;
        } else {
            new CorrelationId();
            this.logger.debug("WL9ServerCorrelationTracer.ITracer_startTrace http correlationid not found");
        }
        return correlationIdFound;
    }
}

