/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.fault.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.webservices.SOAPUtils;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.fault.ASOAPFaultTracer;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;

public class WLS10ServerFaultTracer
extends ASOAPFaultTracer {
    public WLS10ServerFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected boolean reportFaultIfExists(InvocationData data) {
        boolean faultExists = false;
        try {
            data.getInvocationObject();
            Object packet = data.getInvocationParameterAsObject(1);
            if (!packet.getClass().getName().equals("com.sun.xml.ws.api.message.Packet")) {
                packet = data.getInvocationReturnValueAsObject();
                WSMUtils.getLogger().debug("Client error packet=" + packet);
            }
            Object message = WSMUtils.invokeMethodOnObject(packet, "getMessage");
            Class<?> messageClass = message.getClass();
            String messageClassName = messageClass.getName();
            while (!messageClassName.equals("com.sun.xml.ws.api.message.Message") && !messageClassName.equals("java.lang.Object")) {
                messageClass = messageClass.getSuperclass();
                messageClassName = messageClass.getName();
            }
            if (messageClassName.equals("com.sun.xml.ws.api.message.Message")) {
                Method isFault = messageClass.getMethod("isFault", null);
                Boolean hasFault = (Boolean)isFault.invoke(message, null);
                WSMUtils.getLogger().debug("WLS10ServerFaultTrace::reportFaultIfExists hasFault=" + hasFault);
                if (hasFault.booleanValue()) {
                    Method readAsSOAPMessage = messageClass.getMethod("readAsSOAPMessage", null);
                    try {
                        Object soapMessage = readAsSOAPMessage.invoke(message, null);
                        String fault = SOAPUtils.getFaultString(soapMessage);
                        faultExists = true;
                        this.reportFault(fault, data);
                    }
                    catch (Throwable throwable) {
                        WSMUtils.getLogger().debug("WLS10ServerFaultTracer reportFaultIfExists 1");
                    }
                }
            }
            if (!faultExists && data.hasInvocationThrownException()) {
                this.reportFault(data.getInvocationThrownException().getMessage(), data);
                faultExists = true;
            }
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Retrieving_Message_Fault", t);
        }
        return faultExists;
    }

    protected Object getMessageContext(InvocationData data) {
        WSMUtils.getLogger().debug("WLS10ServerFaultTracer getMessageContext");
        try {
            data.getInvocationObject();
            Object context = data.getInvocationParameterAsObject(0);
            return context;
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Retrieving_Message_Context", t);
            return null;
        }
    }
}

