/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.weblogic.WLS8Formatter;
import java.lang.reflect.Method;

public class WLS9Formatter
extends WLS8Formatter {
    public WLS9Formatter(IAgent agent) {
        super(agent);
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespaceURI = null;
        try {
            Object stub = data.getInvocationObject();
            Object service = WSMUtils.invokeMethodOnObject(stub, "_getProperty", new Class[]{String.class}, new Object[]{"weblogic.wsee.ws.WsService"});
            Object wsdl = WSMUtils.invokeMethodOnObject(service, "getWsdlService");
            Object qname = WSMUtils.invokeMethodOnObject(wsdl, "getName");
            namespaceURI = (String)WSMUtils.invokeMethodOnObject(qname, "getNamespaceURI");
            namespaceURI = WSMUtils.formatURLToBeResourceSafe(namespaceURI);
        }
        catch (Throwable bomb) {
            StringBuilder message = new StringBuilder();
            message.append(Thread.currentThread()).append(" Caught unexpected exception while resolving web service operation namespace URI from ").append(data.getInvocationObject().getClass()).append(", ").append(bomb);
            WSMUtils.getLogger().warn(message.toString());
        }
        if (namespaceURI == null || namespaceURI.equals("")) {
            namespaceURI = this.getServiceName(data);
        }
        return namespaceURI.equals("UnknownService") ? "UnknownNamespace" : namespaceURI;
    }

    @Override
    public String getServiceName(InvocationData data) {
        String name = null;
        try {
            Object stub = data.getInvocationObject();
            Class<?> stubClass = stub.getClass();
            Method _getProperty = WSMUtils.find_GetPropertyWithStringArgMethod(stubClass);
            Object url = _getProperty.invoke(stub, "javax.xml.rpc.service.endpoint.address");
            String urlString = WSMUtils.toString(url);
            name = WSMUtils.formatURLToBeResourceSafe(urlString);
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Service_Name", t);
        }
        return name == null || name.equals("") ? "UnknownService" : name;
    }
}

