/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class JAXWSServerEndpointCtrlTracer
extends ASingleInstanceTracerFactory {
    protected final IModuleFeedbackChannel logger;

    public JAXWSServerEndpointCtrlTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("START:JAXWSServerEndpointCtrlTracer.ITracer_startTrace()");
        }
        String strCorId = null;
        boolean correlationIdFound = false;
        try {
            boolean isHTTPReadEnabled;
            Object objRequestMessageContext;
            Object objEndpointInvocation = data.getInvocationParameterAsObject(0);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("JAXWSServerEndpointCtrlTracer.ITracer_startTrace() objEndpointInvocation class=" + objEndpointInvocation.getClass());
            }
            if ((strCorId = this.readHTTPCorrelationInfo(objRequestMessageContext = WSMUtils.invokeMethodOnObject(objEndpointInvocation, "getRequestMessageContext"), isHTTPReadEnabled = WSMUtils.correlationHTTPReadEnabled())) != null) {
                correlationIdFound = true;
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("JAXWSServerEndpointCtrlTracer.ITracer_startTrace() correlationIdFound  " + correlationIdFound);
                }
            }
            if (WSMUtils.correlationSOAPReadEnabled() && !correlationIdFound) {
                Object axisMessageContext = WSMUtils.invokeMethodOnObject(objRequestMessageContext, "getAxisMessageContext");
                Object envelope = WSMUtils.invokeMethodOnObject(axisMessageContext, "getEnvelope");
                Object headers = WSMUtils.invokeMethodOnObject(envelope, "getHeader");
                Object ele = null;
                if (headers != null) {
                    Iterator itr = (Iterator)WSMUtils.invokeMethodOnObject(headers, "getChildElements");
                    while (itr.hasNext()) {
                        ele = itr.next();
                        String eleName = (String)WSMUtils.invokeMethodOnObject(ele, "getLocalName");
                        if (!eleName.equals("WSCorIDSOAPHeader")) continue;
                        if (this.logger != null && this.logger.isDebugEnabled()) {
                            this.logger.debug("JAXWSServerEndpointCtrlTracer::CorId Found.");
                        }
                        strCorId = (String)WSMUtils.invokeMethodOnObject(ele, "getAttributeValue", new Class[]{QName.class}, new Object[]{new QName("CorID")});
                        correlationIdFound = true;
                        WSMUtils.invokeMethodOnObject(ele, "detach");
                        break;
                    }
                }
            }
            if (correlationIdFound) {
                if (strCorId != null && !strCorId.equals("")) {
                    new CorrelationId(strCorId);
                } else {
                    new CorrelationId();
                }
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("JAXWSServerEndpointCtrlTracer.ITracer_startTrace( CorID: " + strCorId);
                }
            } else {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("JAXWSServerEndpointCtrlTracer.ITracer_startTrace no CorID header.");
                }
                new CorrelationId();
            }
        }
        catch (Throwable e) {
            this.logger.error(e);
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("END:JAXWSServerEndpointCtrlTracer.ITracer_startTrace()");
        }
    }

    public void ITracer_finishTrace(int arg0, InvocationData arg1) {
        if (!WSMUtils.correlationSOAPReadEnabled()) {
            return;
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("JAXWSServerEndpointCtrlTracer ITracer_finishTrace");
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    protected String readHTTPCorrelationInfo(Object objRequestMessageContext, boolean isHTTPReadEnabled) throws Exception {
        String strCorId = null;
        if (isHTTPReadEnabled) {
            Object objMessage = WSMUtils.invokeMethodOnObject(objRequestMessageContext, "getMessage");
            Object mapHeaders = WSMUtils.invokeMethodOnObject(objMessage, "getMimeHeaders");
            Map mHeaders = (Map)mapHeaders;
            strCorId = this.getCorrelationInfoFromHttpHeaders(mHeaders);
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("readHTTPCorrelationInfo :: strCorId " + strCorId);
            }
        }
        return strCorId;
    }

    protected String getCorrelationInfoFromHttpHeaders(Map mHeaders) throws Exception {
        String strCorId = null;
        Set entries = mHeaders.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if (!"CorID".equals(key)) continue;
            strCorId = (String)entry.getValue();
            if (this.logger == null || !this.logger.isDebugEnabled()) break;
            this.logger.debug("HTTP header CorIDfound");
            break;
        }
        return strCorId;
    }
}

