/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.formatter.consumer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.ANameFormatter;
import com.wily.powerpack.webservices.WSMUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NetWeaverFormatter
extends ANameFormatter {
    private static final String kInput = "input";
    private static final String kOperationName = "operationName";
    private static final String kEndpointUrl = "endpointUrl";
    private static final String kBindingConfig = "bindingConfig";

    public NetWeaverFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    public String getServiceName(InvocationData data) {
        String name = null;
        try {
            Object configObj = this.getBindingConfig(data);
            Method m = WSMUtils.getMethodForObject(configObj, "getProperty", new Class[]{String.class});
            name = (String)m.invoke(configObj, kEndpointUrl);
            name = WSMUtils.formatURLToBeResourceSafe(name);
        }
        catch (Throwable throwable) {}
        return name == null ? "UnknownService" : name;
    }

    private Object getBindingConfig(InvocationData data) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object invObj = data.getInvocationParameterAsObject(0);
        Method m = WSMUtils.getMethodForObject(invObj, "getSubContext", new Class[]{String.class});
        Object configObj = m.invoke(invObj, kBindingConfig);
        return configObj;
    }

    @Override
    public String getOperation(InvocationData data) {
        String name = null;
        try {
            Object configObj = this.getBindingConfig(data);
            Method m = WSMUtils.getMethodForObject(configObj, "getSubContext", new Class[]{String.class});
            Object inputObj = m.invoke(configObj, kInput);
            m = WSMUtils.getMethodForObject(inputObj, "getProperty", new Class[]{String.class});
            name = (String)m.invoke(inputObj, kOperationName);
        }
        catch (Throwable throwable) {}
        return name == null ? "UnknownOperationName" : name;
    }
}

