/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.jboss;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.JMXDelegatingService;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.introscope.agent.service.ServiceAdministrator;
import com.wily.introscope.agent.transformer.dynamic.IClassLoaderVerifier;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationService;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.agent.webappsupport.jboss.JBossAgentNamer;
import com.wily.introscope.api.jboss.IntroscopeCustomServiceMBean;
import java.util.HashMap;
import org.jboss.system.ServiceMBeanSupport;

public class IntroscopeCustomService
extends ServiceMBeanSupport
implements IntroscopeCustomServiceMBean {
    private static final String kJavaVersionPropertyValue14 = "1.4";
    private static final String kJavaVersionPropertyValue15 = "1.5";
    private static final String kJavaVersionProperty = "java.specification.version";

    public String getName() {
        return "Introscope Service for JBoss";
    }

    public void startService() throws Exception {
        IDynamicInstrumentationService s;
        IDynamicInstrumentationTransformer t;
        IAgent agent = AgentShim.getAgentShim().IAgentShim_getAgent();
        JBossAgentNamer agentNamer = new JBossAgentNamer(agent);
        agentNamer.setAgentNamingCallback();
        ServiceAdministrator serviceAdministrator = agent.IAgent_getServiceAdministrator();
        serviceAdministrator.registerServiceAsync(agent, "JMX", (IAgentService)new JMXDelegatingService(), new HashMap());
        boolean isJava15OrBelow = false;
        String property = System.getProperty(kJavaVersionProperty);
        agent.IAgent_getModuleFeedback().debug("java.specification.version=" + property);
        if (property != null && (property.equals(kJavaVersionPropertyValue15) || property.equals(kJavaVersionPropertyValue14))) {
            isJava15OrBelow = true;
        }
        if (isJava15OrBelow && (t = agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer()) != null && (s = t.getDynamicInstrumentationService()) != null) {
            s.setNotInitialized();
        }
        JBossClassLoaderVerifier verifier = new JBossClassLoaderVerifier();
        IDynamicInstrumentationTransformer t2 = agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
        if (t2 != null) {
            t2.addClassloaderVerifier((IClassLoaderVerifier)verifier);
        }
    }

    public void stopService() throws Exception {
    }

    public static class JBossClassLoaderVerifier
    implements IClassLoaderVerifier {
        public boolean verify(ClassLoader loader) {
            try {
                if (loader != null && loader.getClass().getName().indexOf("WebAppClassLoader") >= 0) {
                    boolean isOk;
                    boolean bl = isOk = loader.toString().indexOf("INF") >= 0;
                    return isOk;
                }
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }
}

