/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.errors;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;

public class Throttle
implements ITimestampedRunnable {
    private int currentCount;
    private int throttle;
    private final IModuleFeedbackChannel feedbackChannel;

    public Throttle(IntervalHeartbeat clearHeartbeat, IModuleFeedbackChannel channel, int throttle) {
        this.feedbackChannel = channel;
        this.throttle = throttle;
        this.currentCount = 0;
        clearHeartbeat.addBehavior((ITimestampedRunnable)this, "Throttle clear", true, 15000L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ITimestampedRunnable_execute(long nowInMillis) {
        Throttle throttle = this;
        synchronized (throttle) {
            this.currentCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean peekIsOK() {
        Throttle throttle = this;
        synchronized (throttle) {
            return this.currentCount < this.throttle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThrottle(int throttle) {
        Throttle throttle2 = this;
        synchronized (throttle2) {
            this.throttle = throttle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean request() {
        int cur = 0;
        Throttle throttle = this;
        synchronized (throttle) {
            cur = this.currentCount++;
        }
        if (cur == this.throttle) {
            this.feedbackChannel.warn("Temporarily throttling the errors sent because more than " + this.throttle + " have occurred in a short time");
        }
        return cur < this.throttle;
    }

    public String toString() {
        return String.valueOf(this.throttle);
    }
}

