/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter.sampling;

import com.wily.introscope.agent.filter.sampling.IStatisticalHeap;
import com.wily.introscope.agent.filter.sampling.IntervalBasedSampler;
import com.wily.introscope.agent.filter.sampling.SamplingResult;
import com.wily.introscope.agent.filter.sampling.StatisticalElement;
import com.wily.introscope.agent.filter.sampling.StatisticalHeap;
import com.wily.introscope.agent.transactiontrace.ISamplingInput;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import java.util.concurrent.atomic.AtomicReference;

abstract class BaseStatisticalSampler
extends IntervalBasedSampler {
    private final AtomicReference<IStatisticalHeap> heapReference = new AtomicReference<IStatisticalHeap>(this.createHeap());

    BaseStatisticalSampler() {
    }

    private IStatisticalHeap createHeap() {
        return StatisticalHeap.create(this.fSamplesCountPerInterval);
    }

    @Override
    public ISamplingResult shouldSample() {
        if (this.isEnabled()) {
            if (this.fFeedback.isTraceEnabled(kSamplingModule)) {
                this.fFeedback.trace(kSamplingModule, String.valueOf(this.name()) + " sampling strategy 'may be' allowed sampling of transaction");
            }
            return new StatisticalSamplingResult();
        }
        return SamplingResult.NO;
    }

    private void insert(StatisticalElement element) {
        IStatisticalHeap heap = this.heapReference.get();
        StatisticalElement discarded = heap.insert(element);
        if (discarded != element) {
            this.executeCallback(element, ISamplingResult.Answer.create(ISamplingResult.Choice.MAYBE, this.name()));
        }
        if (discarded != null) {
            this.executeCallback(discarded, ISamplingResult.Answer.create(ISamplingResult.Choice.NO, this.name()));
        }
    }

    final void executeCallback(StatisticalElement element, ISamplingResult.Answer answer) {
        if (this.fFeedback.isDebugEnabled(kSamplingModule)) {
            switch (answer.choice) {
                case YES: {
                    this.fFeedback.debug(kSamplingModule, "Sampler " + this.name() + " will report sampled transacion with score=" + element.value + ", hash=" + element);
                    break;
                }
                case NO: {
                    this.fFeedback.debug(kSamplingModule, "Sampler " + this.name() + " discarded sampled transacion with score=" + element.value + ", hash=" + element);
                    break;
                }
                case LEAD_IS_NOT_READY: {
                    break;
                }
                case MAYBE: {
                    this.fFeedback.debug(kSamplingModule, "Sampler " + this.name() + " is trying to keep sampled transacion with score=" + element.value + ", hash=" + element);
                }
            }
        }
        SamplingResult.execute(element.pendingCallback, answer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeCallbacks(IStatisticalHeap heap, ISamplingResult.Choice returnValue) {
        IStatisticalHeap iStatisticalHeap = heap;
        synchronized (iStatisticalHeap) {
            StatisticalElement[] arr = heap.toArray();
            int count = arr.length;
            if (count == 0) {
                return;
            }
            ISamplingResult.Answer answer = ISamplingResult.Answer.create(returnValue, this.name());
            int i = 0;
            while (i < count) {
                this.executeCallback(arr[i], answer);
                ++i;
            }
        }
    }

    protected abstract long appraise(ISamplingInput var1);

    @Override
    protected void cleanup() {
        IStatisticalHeap old = this.heapReference.getAndSet(this.createHeap());
        this.executeCallbacks(old, ISamplingResult.Choice.NO);
        super.cleanup();
    }

    @Override
    protected void onDurationExpired() {
        IStatisticalHeap old = this.heapReference.getAndSet(this.createHeap());
        this.executeCallbacks(old, ISamplingResult.Choice.YES);
    }

    private final class StatisticalSamplingResult
    extends SamplingResult {
        public StatisticalSamplingResult() {
            super(ISamplingResult.Answer.create(ISamplingResult.Choice.MAYBE, null));
        }

        @Override
        protected void determineSamplingInternal(ISamplingInput input, ISamplingResult.Callback callback) {
            long value = BaseStatisticalSampler.this.appraise(input);
            String resource = input.resource();
            StatisticalElement element = new StatisticalElement(callback, resource, value);
            BaseStatisticalSampler.this.insert(element);
        }
    }
}

