/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.io;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ManagedFileInputStream
extends FileInputStream {
    private static final Object sLock = new Object();
    private static volatile IIntegerRateDataAccumulator sFileInputRate = null;
    private ThreadLocal fIsReading;

    public ManagedFileInputStream(FileDescriptor fd) {
        super(fd);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedFileInputStream(String file) throws FileNotFoundException {
        super(file);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedFileInputStream(File file) throws FileNotFoundException {
        super(file);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void com_wily_initialize() {
        block14: {
            Object tl = AgentShim.getAgentShimThreadLocal();
            if (AgentShim.isThreadInAgentCode(tl)) {
                return;
            }
            try {
                try {
                    AgentShim.setThreadInAgentCode(tl);
                    this.fIsReading = new ThreadLocal();
                    if (sFileInputRate != null) break block14;
                    Object object = sLock;
                    synchronized (object) {
                        if (sFileInputRate == null) {
                            sFileInputRate = ManagedFileInputStream.createAccumulator();
                            sFileInputRate.IDataAccumulator_getMetric();
                        }
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("Exception initializing ManagedFileInputStream", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                    AgentShim.clearThreadInAgentCode(tl);
                }
            }
            finally {
                AgentShim.clearThreadInAgentCode(tl);
            }
        }
    }

    private static IIntegerRateDataAccumulator createAccumulator() throws AgentNotAvailableException {
        DataAccumulatorFactory factory = AgentShim.getAgent().IAgent_getDataAccumulatorFactory();
        IIntegerRateDataAccumulator result = factory.safeGetIntegerRateDataAccumulator("File System:File Input Rate (Bytes Per Second)");
        return result;
    }

    @Override
    public int read() throws IOException {
        int n;
        boolean shouldMeter;
        Object tl;
        block34: {
            tl = AgentShim.getAgentShimThreadLocal();
            if (AgentShim.isThreadInAgentCode(tl) || ManagedFileInputStream.checkWithOverheadMgr()) {
                return super.read();
            }
            shouldMeter = false;
            try {
                try {
                    AgentShim.setThreadInAgentCode(tl);
                    shouldMeter = this.com_wily_shouldMeterThisCall();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("Exception recording read() from file input stream", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                    AgentShim.clearThreadInAgentCode(tl);
                    break block34;
                }
            }
            catch (Throwable throwable) {
                AgentShim.clearThreadInAgentCode(tl);
                throw throwable;
            }
            AgentShim.clearThreadInAgentCode(tl);
        }
        try {
            int byteRead = super.read();
            AgentShim.setThreadInAgentCode(tl);
            try {
                if (shouldMeter) {
                    sFileInputRate.IIntegerRateDataAccumulator_addSingleIncident(this.com_wily_getBlameStackSnapshot());
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording read() from file input stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
            n = byteRead;
        }
        catch (Throwable throwable) {
            try {
                if (shouldMeter) {
                    this.com_wily_doneMeteringThisCall();
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording read() from file input stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable2) {}
            }
            AgentShim.clearThreadInAgentCode(tl);
            throw throwable;
        }
        try {
            if (shouldMeter) {
                this.com_wily_doneMeteringThisCall();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception recording read() from file input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        AgentShim.clearThreadInAgentCode(tl);
        return n;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int n;
        boolean shouldMeter;
        Object tl;
        block34: {
            tl = AgentShim.getAgentShimThreadLocal();
            if (AgentShim.isThreadInAgentCode(tl) || ManagedFileInputStream.checkWithOverheadMgr()) {
                return super.read(b);
            }
            shouldMeter = false;
            try {
                try {
                    AgentShim.setThreadInAgentCode(tl);
                    shouldMeter = this.com_wily_shouldMeterThisCall();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("Exception recording read(byte[]) from file input stream", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                    AgentShim.clearThreadInAgentCode(tl);
                    break block34;
                }
            }
            catch (Throwable throwable) {
                AgentShim.clearThreadInAgentCode(tl);
                throw throwable;
            }
            AgentShim.clearThreadInAgentCode(tl);
        }
        try {
            int bytesRead = super.read(b);
            AgentShim.setThreadInAgentCode(tl);
            try {
                if (shouldMeter) {
                    sFileInputRate.IIntegerRateDataAccumulator_addBatchIncidents(bytesRead, this.com_wily_getBlameStackSnapshot());
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording read(byte[]) from file input stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
            n = bytesRead;
        }
        catch (Throwable throwable) {
            try {
                if (shouldMeter) {
                    this.com_wily_doneMeteringThisCall();
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording read(byte[]) from file input stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable2) {}
            }
            AgentShim.clearThreadInAgentCode(tl);
            throw throwable;
        }
        try {
            if (shouldMeter) {
                this.com_wily_doneMeteringThisCall();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception recording read(byte[]) from file input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        AgentShim.clearThreadInAgentCode(tl);
        return n;
    }

    @Override
    public int read(byte[] b, int offset, int len) throws IOException {
        int n;
        boolean shouldMeter;
        Object tl;
        block34: {
            tl = AgentShim.getAgentShimThreadLocal();
            if (AgentShim.isThreadInAgentCode(tl) || ManagedFileInputStream.checkWithOverheadMgr()) {
                return super.read(b, offset, len);
            }
            shouldMeter = false;
            try {
                try {
                    AgentShim.setThreadInAgentCode(tl);
                    shouldMeter = this.com_wily_shouldMeterThisCall();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("Exception recording read(byte[],int,int) from file input stream", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                    AgentShim.clearThreadInAgentCode(tl);
                    break block34;
                }
            }
            catch (Throwable throwable) {
                AgentShim.clearThreadInAgentCode(tl);
                throw throwable;
            }
            AgentShim.clearThreadInAgentCode(tl);
        }
        try {
            int bytesRead = super.read(b, offset, len);
            AgentShim.setThreadInAgentCode(tl);
            try {
                if (shouldMeter) {
                    sFileInputRate.IIntegerRateDataAccumulator_addBatchIncidents(bytesRead, this.com_wily_getBlameStackSnapshot());
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording read(byte[],int,int) from file input stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
            n = bytesRead;
        }
        catch (Throwable throwable) {
            try {
                if (shouldMeter) {
                    this.com_wily_doneMeteringThisCall();
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording read(byte[],int,int) from file input stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable2) {}
            }
            AgentShim.clearThreadInAgentCode(tl);
            throw throwable;
        }
        try {
            if (shouldMeter) {
                this.com_wily_doneMeteringThisCall();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception recording read(byte[],int,int) from file input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        AgentShim.clearThreadInAgentCode(tl);
        return n;
    }

    private final BlameStackSnapshot com_wily_getBlameStackSnapshot() {
        try {
            ComponentTracer componentTracer = AgentShim.getAgent().IAgent_getComponentTracer();
            if (componentTracer != null) {
                return componentTracer.getSnapshot(ComponentTracer.kNoComponent);
            }
        }
        catch (AgentNotAvailableException anae) {
            AgentShim.handleError("Unable to access component tracer", anae);
        }
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    private final boolean com_wily_shouldMeterThisCall() {
        boolean shouldMeter;
        boolean bl = shouldMeter = sFileInputRate != null;
        if (shouldMeter) {
            boolean bl2 = shouldMeter = this.fIsReading.get() != Boolean.TRUE;
            if (shouldMeter) {
                AgentMetric metric = sFileInputRate.IDataAccumulator_getMetric();
                boolean bl3 = shouldMeter = !AgentShim.getAgentShim().IAgentShim_isMetricShutOff(metric);
                if (shouldMeter) {
                    this.fIsReading.set(Boolean.TRUE);
                }
            }
        }
        return shouldMeter;
    }

    private final void com_wily_doneMeteringThisCall() {
        Assertion.wilyAssert(false);
        this.fIsReading.set(Boolean.FALSE);
    }

    public static boolean checkWithOverheadMgr() {
        return OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND == OverheadAdministrator.getOverheadMode() || OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode();
    }
}

