/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;

public class NonBlockingTxnMarker
extends ASingleInstanceTracerFactory {
    private static final String kBooleanTrue = "true";

    public NonBlockingTxnMarker(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    protected boolean isCurrentTxnNonBlocking() {
        return true;
    }

    protected void conditionallyMarkNonBlockingTxn(InvocationData data) {
        if (this.isCurrentTxnNonBlocking()) {
            ComponentTracer componentTracer = this.getAgent().IAgent_getComponentTracer();
            IBlameStack stack = data.getStack(componentTracer, false);
            componentTracer.addRootParameter(stack, "NBThreadTxn", kBooleanTrue);
            if (this.getAgent().IAgent_getModuleFeedback().isTraceEnabled()) {
                this.getAgent().IAgent_getModuleFeedback().trace("NonBlockingTxnMarker current Txn has been marked as non-blocking in nature");
            }
        }
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        this.conditionallyMarkNonBlockingTxn(data);
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

