/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.cas.APureMapTransactionElement;
import com.wily.introscope.agent.trace.cas.APureSetTransactionElement;
import com.wily.introscope.agent.trace.cas.AbstractTransactionElement;
import com.wily.introscope.agent.trace.cas.EndTransactionElement;
import com.wily.introscope.agent.trace.cas.IChildEditor;
import com.wily.introscope.agent.trace.cas.IChildRead;
import com.wily.introscope.agent.trace.cas.IEditableTransactionElement;
import com.wily.introscope.agent.trace.cas.IErrorSubscriber;
import com.wily.introscope.agent.trace.cas.IFaultSubscriber;
import com.wily.introscope.agent.trace.cas.IStallSubscriber;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.SetElement;
import com.wily.wilyassert.Assertion;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AMixedTransactionElement
extends AbstractTransactionElement
implements ITransactionElement,
IEditableTransactionElement {
    private volatile ConcurrentHashMap fChildrenMap;
    private final CopyOnWriteArrayList fChildrenSet = new CopyOnWriteArrayList();
    protected volatile boolean fUseMap = false;
    private static final int kMaxSetSize = 15;
    private WeakReference<AMixedTransactionElement> fWeakRef = new WeakReference<AMixedTransactionElement>(this);

    public AMixedTransactionElement(ITransactionElement parent, boolean isStartTrace) {
        super(parent, isStartTrace);
    }

    private synchronized void switchToMap() {
        if (this.fUseMap) {
            return;
        }
        int originalLength = -1;
        do {
            originalLength = this.fChildrenSet.size();
            this.fChildrenMap = new ConcurrentHashMap();
            for (SetElement element : this.fChildrenSet) {
                this.fChildrenMap.put(element.key, element.element);
            }
        } while (originalLength != this.fChildrenSet.size());
        this.fUseMap = true;
        this.fChildrenSet.clear();
    }

    @Override
    public Iterator iterateChildren() {
        if (this.fUseMap) {
            return new APureMapTransactionElement.PureMapIterator(this.fChildrenMap, this.fEndTransactionChild);
        }
        return new APureSetTransactionElement.PureSetIterator(this.fChildrenSet, this.fEndTransactionChild);
    }

    private ITransactionElement goToChild(Object key, int tracerIndex, IStackElement data, ITransactionElementProvider provider) {
        if (this.fUseMap) {
            ITransactionElement result = (ITransactionElement)this.fChildrenMap.get(key);
            if (result == null) {
                AMixedTransactionElement.checkCount(provider, key, tracerIndex, data, this);
                result = provider.getElementOnStartTrace(key, tracerIndex, data, this);
                ITransactionElement isPresent = this.fChildrenMap.putIfAbsent(key, result);
                if (isPresent != null) {
                    this.needToSendDiscoveryTraceAgain(data, result);
                    return isPresent;
                }
                result.notifyPublished();
                this.markTransactionElementForDiscoveryTrace(data, result);
                return result;
            }
            this.needToSendDiscoveryTraceAgain(data, result);
            return result;
        }
        int currentSize = this.fChildrenSet.size();
        if (currentSize >= 15) {
            this.switchToMap();
            return this.goToChild(key, tracerIndex, data, provider);
        }
        int i = 0;
        while (i < currentSize) {
            try {
                SetElement se = (SetElement)this.fChildrenSet.get(i);
                if (se.equalsObject(key)) {
                    this.needToSendDiscoveryTraceAgain(data, se.element);
                    return se.element;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            ++i;
        }
        AMixedTransactionElement.checkCount(provider, key, tracerIndex, data, this);
        ITransactionElement result = provider.getElementOnStartTrace(key, tracerIndex, data, this);
        SetElement newElement = new SetElement(key, result);
        if (this.fChildrenSet.addIfAbsent(newElement)) {
            result.notifyPublished();
            this.markTransactionElementForDiscoveryTrace(data, result);
            return result;
        }
        return this.goToChildStartTransaction(key, tracerIndex, data, provider);
    }

    @Override
    public final int countChildren() {
        int sizeOfEnd;
        int n = sizeOfEnd = this.fEndTransactionChild.get() == null ? 0 : 1;
        if (this.fUseMap) {
            return this.fChildrenMap.size() + sizeOfEnd;
        }
        return this.fChildrenSet.size() + sizeOfEnd;
    }

    @Override
    public boolean isLastInTransaction() {
        return false;
    }

    @Override
    public final ITransactionElement goToChildStartTransaction(Object key, int tracerIndex, IStackElement data, ITransactionElementProvider provider) {
        return this.goToChild(key, tracerIndex, data, provider);
    }

    @Override
    public final ITransactionElement goToChild(Object key, ITransactionElementProvider provider) {
        return this.goToChild(key, 0, null, provider);
    }

    @Override
    public final ITransactionElement goToChild(Object key, IStackElement data, ITransactionElementProvider provider) {
        return this.goToChild(key, 0, data, provider);
    }

    @Override
    public final void terminateTransaction(String endKey) {
        if (!this.isEndTrace()) {
            this.setEndTrace(true);
            if (this.fUseMap) {
                this.fChildrenMap.put(endKey, new EndTransactionElement(this));
            } else {
                this.fChildrenSet.add(new SetElement(endKey, new EndTransactionElement(this)));
            }
        }
    }

    @Override
    public final boolean hasChildren() {
        if (this.fUseMap) {
            return !this.fChildrenMap.isEmpty();
        }
        return !this.fChildrenSet.isEmpty();
    }

    @Override
    public IErrorSubscriber getErrorSubscriber() {
        return null;
    }

    @Override
    public IStallSubscriber getStallSubscriber() {
        return null;
    }

    @Override
    public IFaultSubscriber getFaultSubscriber() {
        return null;
    }

    @Override
    public ITransactionElement getNextOnEndTransaction() {
        return this;
    }

    @Override
    public void notifyPublished() {
        if (Assertion.isEnabled()) {
            throw new IllegalArgumentException("this method should not be called on a Mixed Transaction Element");
        }
    }

    @Override
    public void notifyRemoved() {
        this.invalidate();
        if (Assertion.isEnabled()) {
            throw new IllegalArgumentException("this method should not be called on a Mixed Transaction Element");
        }
    }

    @Override
    public void offerChildrenForEdit(IChildEditor editor) {
        if (this.fUseMap) {
            Iterator i = this.fChildrenMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry ee = i.next();
                ITransactionElement e = (ITransactionElement)ee.getValue();
                if (!editor.removeElement(e, ee.getKey())) continue;
                i.remove();
                editor.onPostRemove(e);
            }
        } else {
            for (SetElement se : this.fChildrenSet) {
                ITransactionElement e = se.element;
                if (!editor.removeElement(e, se.key)) continue;
                this.fChildrenSet.remove(se);
                editor.onPostRemove(se);
            }
        }
    }

    @Override
    public void offerChildrenForRead(IChildRead reader) {
        if (this.fUseMap) {
            for (ITransactionElement e : this.fChildrenMap.values()) {
                reader.readElement(e);
            }
        } else {
            int currentSize = this.fChildrenSet.size();
            int i = 0;
            while (i < currentSize) {
                try {
                    SetElement se = (SetElement)this.fChildrenSet.get(i);
                    ITransactionElement e = se.element;
                    reader.readElement(e);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                ++i;
            }
        }
        ITransactionElement e = (ITransactionElement)this.fEndTransactionChild.get();
        if (e != null) {
            reader.readElement(e);
        }
    }

    @Override
    public void clearAllChildren() {
        if (this.fUseMap) {
            this.fChildrenMap.clear();
        } else {
            this.fChildrenSet.clear();
        }
        this.fEndTransactionChild.set(null);
    }

    public WeakReference<AMixedTransactionElement> getWeakReference() {
        return this.fWeakRef;
    }
}

